/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/sndabomsg.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* sndabomsg.c -- snd bad address message
 * actually sends an 'additional bytes' portion of a message
 * of the given length and a 'bad transmission' trailer.
 */

#define SAFWRTSIZ 10

      char safwrt [SAFWRTSIZ+1] = "eeeeeeeeee";
      void inibadacktrl();
extern int usrdsc;

#include "ivw.h"

sndabomsg (lng)
  int lng;

{ 
      char acktrl[ACKTRLSIZ];
       int numwrt;
       int i;

  /* calc multiple of 'save write' array buffers to send,
   * and send them.
   */
  numwrt = lng / SAFWRTSIZ;
  for (i=1; i<=numwrt; i++)
     { (void)write (usrdsc, (char *)safwrt, SAFWRTSIZ, 0);
     }

  /* send remaining necessary bytes to fill
   * length of original intended message
   */
  numwrt = lng % SAFWRTSIZ;
  (void)write (usrdsc, (char *)safwrt, numwrt, 0);

  /* now send bad ack trailer bytes */
  inibadacktrl(acktrl);
  (void)write (usrdsc, (char *)acktrl, ACKTRLSIZ, 0);
}
