/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/scanner.c 
*				 					* 
*   Copyright (C) 1991 Tim Maroney
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: scanning routines						*
*									* 
\***********************************************************************/ 

#ifndef lint
static char rcsid[] = "$Header: /r/zep/usr/rts/p/personal/hkaram/tech/src/lib/libidl/RCS/scanner.c,v 4.2 90/08/20 16:29:42 hkaram Release42 Locker: hkaram $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	scanner.c,v $
 * Revision 4.2  90/08/20  16:29:42  hkaram
 * @
 * 
 * Revision 4.0  89/04/12  08:53:05  cheung
 * scanner.c  Ver 4.0
 * 
 * Revision 3.9  89/04/07  23:39:09  cheung
 * scanner.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  12:31:53  cheung
 * scanner.c version 3.9
 * 
 * Revision 3.2  88/03/05  14:02:15  rajan
 * This is the version distributed with release 3.2
 * 
 * Revision 1.1  87/04/18  13:42:13  shannon
 * Initial revision
 * 
 * Revision 1.1  85/06/11  10:34:04  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     May  1984 (maroney) Created.					*
*									*
\* ******************************************************************* */
# include <C/global.h>
# include <stdio.h>

#define PIPECHAR '\174'
#define QUOTE	 '\042'
#define TILDE	 '\176'
#define DEL	 '\177'

#define BUFFERSIZE 8000
static char C;
static int Line;
static char BUFFER[BUFFERSIZE];
static int BUFLEN;

void exit();
void escape_check();

char *BufCopy()
{	register char *S;
	register int i;
	String RetrieveReaderString();

	BUFFER[BUFLEN] = '\0';
	if (BUFLEN == 0)
	  return NULL;
	/* if S is not a node or attribute name, allocate storage */
	if ((S = RetrieveReaderString(BUFFER)) == NULL) {
	    S = (char *) GetHeap(BUFLEN+1);
	    for (i=0; i<BUFLEN; ++i) S[i] = BUFFER[i];
	    S[i] = '\0';
	}
	return S;
}

#define AddBuffer(c)	\
	{if (BUFLEN<BUFFERSIZE) BUFFER[BUFLEN++] = c; \
	else {(void)fprintf(stderr, "idlreader: Insufficient buffer space\n"); exit(1);}}

# include <C/reader.h>

void LexInit(F)
FILE *F;
{	
	Line = 1;
	C = getc(F);
}

Lexeme GetLex(MyFile)
FILE * MyFile;
{	
	Lexeme Ret;

	Ret.Token = NULL;
	BUFLEN = 0;
	Ret.Pos.line = Line;

Start:	
	if ( feof(MyFile) )
	{
		Ret.Kind = LexEOF;
		goto Term;
	}
	else switch (C) {
	case '"':
	{
		Ret.Kind = LexString;
		C = getc(MyFile);
		goto InString;
	}

	/* white space */

	case ' ':	
		{
			C = getc(MyFile);
			goto Start;
		}
	case '	':
		{
			C = getc(MyFile);
			goto Start;
		}
	case '\n':	
		{
			C = getc(MyFile);
			Line++;
			Ret.Pos.line = Line;
			goto Start;
		}

	/* punctuation */

	case '{':	
		{
			Ret.Kind =  LexOpenBrace;
			C = getc(MyFile);
			goto Term;
		}
	case '}':	
		{
			Ret.Kind =  LexCloseBrace;
			C = getc(MyFile);
			goto Term;
		}
	case '<':	
		{
			Ret.Kind =  LexOpenAngleBracket;
			C = getc(MyFile);
			goto Term;
		}
	case '>':	
		{
			Ret.Kind =  LexCloseAngleBracket;
			C = getc(MyFile);
			goto Term;
		}
	case '[':	
		{
			Ret.Kind =  LexOpenSquareBracket;
			C = getc(MyFile);
			goto Term;
		}
	case ']':	
		{
			Ret.Kind =  LexCloseSquareBracket;
			C = getc(MyFile);
			goto Term;
		}
	case ';':	
		{
			Ret.Kind =  LexSemiColon;
			C = getc(MyFile);
			goto Term;
		}
	case '+':	
		{
			AddBuffer(C);
			C = getc(MyFile);
			goto Sign;
		}
	case '-':	
		{
			C = getc(MyFile);
			if (C == '-') {
			    /* comment so eat up rest of line and go to start*/
			    while ((C != '\n') && (!feof(MyFile)))
				C = getc(MyFile);
			    BUFLEN = 0;
			    goto Start;
			}
			else {
			    AddBuffer('-');
			    goto Sign;
			}
		}
	case '#':	/* soft EOF */
		{	Ret.Kind = LexEOF;
			goto Term;
		}
	default:	
		if ( (C == '0') || ((C >= '1') && (C <= '9')) )
		{
			Ret.Kind = LexInteger;
			AddBuffer(C);
			C = getc(MyFile);
			goto INT;
		}
		else if ( ((C >= 'a') && (C <= 'z'))
		    || ((C >= 'A') && (C <= 'Z')) )
		{
			Ret.Kind = LexName;
			AddBuffer(C);
			C = getc(MyFile);
			goto NAME;
		}
		else	Error(ErrBadLex,Ret.Pos);
	}

Sign:	
	if ( (C == '0') || ((C >= '1') && (C <= '9')) )
	{
		Ret.Kind = LexInteger;
		AddBuffer(C);
		C = getc(MyFile);
		goto INT;
	}
	else	Error(ErrBadLex,Ret.Pos);

INT:	
	if ( (C == '0') || ((C >= '1') && (C <= '9')) )
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto INT;
	}
	else switch(C) {
	case '#':
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto S1;
	}
	case 'E':
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto S2;
	}
	case '.':
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto S3;
	}
	default:
	{	Ret.Token = BufCopy();
		goto Term;
	}
}

S1:	
	if ( (C == '0') || ((C >= '1') && (C <= '9'))
	    || ((C >= 'A') && (C <= 'F')) )
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto S4;
	}
	else	Error(ErrBadLex,Ret.Pos);

S2:	
	if ( (C == '0') || ((C >= '1') && (C <= '9')) )
	{
		Ret.Kind = LexRational;
		AddBuffer(C);
		C = getc(MyFile);
		goto BRat2;
	}
	else if ((C == '+') || (C == '-')) {
		AddBuffer(C);
		C = getc(MyFile);
		goto S2;
	}
	else	Error(ErrBadLex,Ret.Pos);

S3:	
	if ( (C == '0') || ((C >= '1') && (C <= '9')) )
	{
		Ret.Kind = LexRational;
		AddBuffer(C);
		C = getc(MyFile);
		goto BRat1;
	}
	else	Error(ErrBadLex,Ret.Pos);

S4:	
	if ( (C == '0') || ((C >= '1') && (C <= '9'))
	    || ((C >= 'A') && (C <= 'F')) )
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto S4;
	}
	else switch(C) {
	case '#':
	{
		Ret.Kind = LexRational;
		AddBuffer(C);
		C = getc(MyFile);
		goto BRat3;
	}
	case '.':
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto S5;
	}
	default:
		Error(ErrBadLex,Ret.Pos);
	}

S5:	
	if ( (C == '0') || ((C >= '1') && (C <= '9'))
	    || ((C >= 'A') && (C <= 'F')) )
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto S6;
	}
	else	Error(ErrBadLex,Ret.Pos);

S6:	
	if ( (C == '0') || ((C >= '1') && (C <= '9'))
	    || ((C >= 'A') && (C <= 'F')) )
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto S6;
	}
	else if (C=='#')
	{
		Ret.Kind = LexRational;
		AddBuffer(C);
		C = getc(MyFile);
		goto BRat3;
	}
	else	Error(ErrBadLex,Ret.Pos);

BRat1:	
	if ( (C == '0') || ((C >= '1') && (C <= '9')) )
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto BRat1;
	}
	else if ( C == 'E' )
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto S2;
	}
	else
	{	Ret.Token = BufCopy();
		goto Term;
	}

BRat2:	
	if ( (C == '0') || ((C >= '1') && (C <= '9')) )
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto BRat2;
	}
	else
	{	Ret.Token = BufCopy();
		goto Term;
	}

BRat3:	
	if ( C == 'E' )
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto S2;
	}
	else
	{	Ret.Token = BufCopy();
		goto Term;
	}

NAME:	
	if ( ((C >= 'a') && (C <= 'z')) || ((C >= 'A') && (C <= 'Z'))
	    || (C == '0') || ((C >= '1') && (C <= '9'))
	    || (C == '_') )
	{
		AddBuffer(C);
		C = getc(MyFile);
		goto NAME;
	}
	else if ( C == '^' )
	{
		C = getc(MyFile);
		goto LRef;
	}
	else if ( C == ':' )
	{
		C = getc(MyFile);
		goto LDef;
	}
	else if ( C == ' ' )
	{
		C = getc(MyFile);
		goto NWS;
	}
	else if ( C == '	' )
	{
		C = getc(MyFile);
		goto NWS;
	}
	else	goto NCheck;

NWS:	
	if ( C == '^' )
	{
		C = getc(MyFile);
		goto LRef;
	}
	else if ( C == ':' )
	{
		C = getc(MyFile);
		goto LDef;
	}
	else if ( C == ' ' )
	{
		C = getc(MyFile);
		goto NWS;
	}
	else if ( C == '	' )
	{
		C = getc(MyFile);
		goto NWS;
	}
	else if ( C == '\n' )
	{
		Line++;
		C = getc(MyFile);
		goto NWS;
	}
	else	goto NCheck;	/* if no case matches */

LDef:	
	Ret.Kind = LexLabelDef;
	Ret.Token = BufCopy();
	goto Term;

LRef:	
	Ret.Kind = LexLabelRef;
	Ret.Token = BufCopy();
	goto Term;

NCheck:	
	if ( (BUFLEN == 4) )
	{
		if ( (BUFFER[0] == 'T') &&
		    (BUFFER[1] == 'R') &&
		    (BUFFER[2] == 'U') &&
		    (BUFFER[3] == 'E') )
		{	Ret.Kind = LexTrue;
			goto Term;
		}
	}
	else if ( (BUFLEN == 5) )
	{
		if ( (BUFFER[0] == 'F') &&
		    (BUFFER[1] == 'A') &&
		    (BUFFER[2] == 'L') &&
		    (BUFFER[3] == 'S') &&
		    (BUFFER[4] == 'E') )
		{	Ret.Kind = LexFalse;
			goto Term;
		}
	}
	Ret.Token = BufCopy();
	goto Term;

InString:
	if(C != '"')
	{
		if (C == '~')
		    escape_check(MyFile, Ret);
		else AddBuffer(C);
		C = getc(MyFile);
		goto InString;
	}
	else  /* QUOTE */
	{
		C = getc(MyFile);
		if(C == '"')
		{
		    AddBuffer(C);
		    C = getc(MyFile);
		    goto InString;
		}
		else 
		{
		    Ret.Token = BufCopy();
		    goto Term;
		}
	}

Term:
	return(Ret);
}

void
escape_check(MyFile, Ret)
FILE	*MyFile;
Lexeme Ret;
{
	char	nc;			/* next character */

	nc = getc(MyFile);
	if(nc >= '@' && nc <= '_')	/* next char is '@' - '_' */
	{
	    nc = nc - '@';
	    AddBuffer(nc);
	}
	else if(nc == '~'){		/* next char is '~'  */
	    AddBuffer(TILDE);
	}
	else if(nc == '{'){		/* next char is '{' */
	    AddBuffer(DEL);
	}
	else if(nc == '|'){		/* next char is '|' */
	    AddBuffer(PIPECHAR);
	}
	else {
	    Error(ErrBadEscapedChar,Ret.Pos);
	}
}
		
