/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/rmisc.c 
*				 					* 
*   Copyright (C) 1991 Tim Maroney
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: miscellaneous reading routines				8
*									*
\***********************************************************************/ 

#ifndef lint
static char rcsid[] = "$Header: /r/zep/usr/rts/p/personal/hkaram/tech/src/lib/libidl/RCS/rmisc.c,v 4.2 90/08/20 16:29:40 hkaram Release42 Locker: hkaram $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	rmisc.c,v $
 * Revision 4.2  90/08/20  16:29:40  hkaram
 * @
 * 
 * Revision 1.1  89/07/14  11:10:20  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  08:52:56  cheung
 * rmisc.c  Ver 4.0
 * 
 * Revision 3.9  89/04/07  23:39:03  cheung
 * rmisc.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  12:29:42  cheung
 * rmisc.c version 3.9
 * 
 * Revision 3.2  88/03/05  14:02:07  rajan
 * This is the version distributed with release 3.2
 * 
 * Revision 1.1  87/04/18  13:42:08  shannon
 * Initial revision
 * 
 * Revision 1.1  85/06/11  10:33:48  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     May  1984 (maroney) Created.					*
*									*
\* ******************************************************************* */
# include <stdio.h>
#include <C/global.h>
#include <C/reader.h>

/* error functions */

void Error(What,Where)
ErrType What;
PosType Where;
{
	int lineNum;

	lineNum = Where.line;
	(void)fprintf(stderr,"IDL Error: ");
	switch (What) {
		case ErrAngleExpected:
			(void)fprintf(stderr,"Expected angle bracket on line %d\n",
				lineNum);
			break;
		case ErrBraceExpected:
			(void)fprintf(stderr,"Expected square bracket on line %d\n",
				lineNum);
			break;
		case ErrEOF:
			(void)fprintf(stderr,"Unexpected end of file on line %d\n",
				lineNum);
			break;
		case ErrSemiColonExpected:
			(void)fprintf(stderr,"Expected semicolon on line %d\n",
				lineNum);
			break;
		case ErrSkipStopped:
			(void)fprintf(stderr,"Resuming input parsing at %d\n",
				lineNum);
			break;
		case ErrValueExpected:
			(void)fprintf(stderr,"Expected to see value on line %d\n",
				lineNum);
			break;
		case ErrBadNodeType:
			(void)fprintf(stderr,"Bad node type for this port on line %d\n",
				lineNum);
			break;
		case ErrNodeExpected:
			(void)fprintf(stderr,"Expected to see a node on line %d\n",
				lineNum);
			break;
		case ErrEOFExpected:
			(void)fprintf(stderr,"Expected to see end of file on line %d\n",
				lineNum);
			break;
		case ErrBadRootType:
			(void)fprintf(stderr,"Root type invalid for this port\n");
			break;
		case ErrNoRoot:
			(void)fprintf(stderr,"No root!!!\n");
			break;
		case ErrBadAttribute:
			(void)fprintf(stderr,"Bad attribute on line %d\n",
				lineNum);
			break;
		case ErrBadLex:
			(void)fprintf(stderr,"Bad token in input, line %d\n",
				lineNum);
			break;
		case ErrBadClassNode:
			(void)fprintf(stderr,"Bad class type on line %d\n",
				lineNum);
			break;
		case ErrBadEscapedChar:
			(void)fprintf(stderr, "Illegal escaped character on line %d\n",				lineNum);
			break;
		default:
			(void)fprintf(stderr,"Unknown error type %d on line %d\n",
				What,lineNum);
		}
}

void ErrInit()
	{
	}

void ErrFinish()
	{
	}

/* sequence functions */

SeqType NewSeq()
	{
	return(NULL);
	}

SeqType AddSeq(L,V)
SeqType L;
RepType V;
{	
	SeqType t, L2;

	t = (SeqType)GetHeap(sizeof(struct CellType));
	t->next = NULL;
	if (V->Kind == RepLabelRef)
		t->value = NULL;
	else
		t->value = V;

	if (L == NULL)
	    L = t;
	else {
	    for (L2=L; L2->next != NULL; L2 = L2->next) ;
	    L2->next = t;
	}

	return(L);
}

/* functions that return RepTypes */

RepType MakeVal(Attr,Lex)
RepKind Attr;
Lexeme Lex;
{	RepType R;

	R = (RepType)GetHeap(sizeof(struct RecRepType));
	R->Pos = Lex.Pos;
	R->Labelled = 0;
	R->StringField = Lex.Token;
	R->Kind = Attr;
	return R;
}

RepType MakeBool(TorF,P)
int TorF;
PosType P;
{	RepType R;

	R = (RepType)GetHeap(sizeof(struct RecRepType));
	R->Pos = P;
	R->Kind = AtrBoolean;
	R->Labelled = 0;
	R->UnionField.boolVal = TorF;
	R->StringField = NULL;
	return(R);
}

RepType MakeNode(N,P)
NodeType N;
PosType P;
{	RepType R;

	R = (RepType)GetHeap(sizeof(struct RecRepType));
	R->Pos = P;
	R->StringField = NULL;
	R->Labelled = 0;
	R->Kind = RepNode;
	R->UnionField.NodeField = N;
	return(R);
}

RepType MakeSeq(S,P)
SeqType S;
PosType P;
{	RepType R;

	R = (RepType)GetHeap(sizeof(struct RecRepType));
	R->Pos = P;
	R->StringField = NULL;
	R->Labelled = 0;
	R->Kind = AtrSequence;
	R->UnionField.seqVal = S;
	return(R);
}

/* misc. reader functions */

char *strncpy();

String StrCopy(S)
register String S;
{	register int i;
	register String Ret;

	i = strlen(S);
	Ret = (String) GetHeap(i+1);
	(void) strncpy(Ret,S,i+1);
	return Ret;
}

String GString(R)
register RepType R;
{	register String S;

	if (R)
	{	S = NewString(R->StringField);
	} else
	{	S = NULL;
	}
	return S;
}

Boolean GBoolean(R)
register RepType R;
{	register Boolean B;

	B = R->UnionField.boolVal;
	return B;
}

void DelRep(R)
register RepType R;
{	if (R->Labelled==0)
	{	/* if (R->StringField) FreeHeap(R->StringField); */
		/* FreeHeap(R); */
	}
}
