/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/rcvwdwmsg.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* rcvwdwmsg -- read an entire message from IDLView 
 * 10-Aug-1987  9:35
 * 30-Nov-1987 -- changed USRDSC constant to usrdsc variable.
 *  9-Oct-1988 -- added code to input "successful status" bytes
 *                from IDLView (feature is unused)
 *
 */

#include "ivw.h"
#include <stdio.h>

/* external routines */
char * malloc();

extern int usrdsc;

int rcvwdwmsg (ivwmsg, blkptr)
  ivwmsghdr *ivwmsg;
  ptr       *blkptr;
{
  int redsts;
  char acktrl[ACKTRLSIZ];

  redsts = read (usrdsc, (char *)ivwmsg, sizeof(*ivwmsg), 0);
  
  if (redsts == -1)
    {
      return redsts;
    }

  if ((*ivwmsg).addmsglng <= 0) 
    { *blkptr = IVWNUL;
    }
  else { *blkptr = malloc ((unsigned)(*ivwmsg).addmsglng);
	 redsts = read (usrdsc, (char *)*blkptr, ivwmsg->addmsglng, 0);
	 /* this would read "successful status" message trailer
	  * bytes if they were ever used; however, these are
	  * not ever sent from IDLView to the debugged process,
	  * because no use has yet been made of "additional message"
	  * bytes in that direction.  They ARE used going from
	  * the dbxtool process to IDLView, so for orthogality's
	  * sake, they should also come the other way.  Therefore,
	  * this code is not tested.
	  */
	 if (redsts != -1)
	   redsts = read (usrdsc, acktrl, ACKTRLSIZ, 0);
       }
  return redsts;
}
