/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/libcnncmm.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook, Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Return descriptor of socket connected with IDLView			*
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/errno.h>
#include <signal.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>

#include "ivw.h"

#define ERROR -1

void exit();
extern int readline();
extern void writeline();

int gethostname();
char hstnam[MAXHSTNAMLNG];
struct hostent *hp, *gethostbyname();

int 
libcnncmm(id, wdwds, idlfilnam, serv_host, disp_host, idlbrowse, port)
     int id, wdwds;
     char *idlfilnam;
     char *serv_host, *disp_host;
     int idlbrowse;
     char *port;
{ 
  int sock, porty;
  struct sockaddr_in sockstruct;
  int sts;
  char port_str[MAXPRTNAMLNG], serv[MAXHSTNAMLNG], fil[MAXHSTNAMLNG], wdw[MAXHSTNAMLNG];
  char *port_ptr, *serv_ptr, *fil_ptr, *wdw_ptr;
  char token[MAXHSTNAMLNG], *token_ptr;
  char idlb[MAXHSTNAMLNG], ivwsess[MAXHSTNAMLNG], *idlb_ptr, *ivwsess_ptr;
  int do_broadcast();

  bzero(ivwsess, MAXHSTNAMLNG);
  (void)sprintf (ivwsess,"%d", id);

  bzero(token, MAXHSTNAMLNG);
  token_ptr = &token[0];

  bzero(idlb, MAXHSTNAMLNG);
  (void)sprintf (idlb,"%d", idlbrowse);
  idlb_ptr = &idlb[0];

  bzero(fil, MAXHSTNAMLNG);
  (void)strcpy (fil, idlfilnam);

  bzero (wdw, MAXHSTNAMLNG);
  (void)sprintf(wdw, "%d", wdwds);
  wdw_ptr = &wdw[0];

  /* create a stream socket in the internet domain */
  sock = socket (AF_INET, SOCK_STREAM, 0);
  if (sock < 0) { perror("opening stream socket");
		  exit(1);
		}
  /* connect the socket using the given host's name and
   * a number which is a constant in this program.  
   * If operating between machines, this number may have to
   * be run through the function htons(), which converts
   * integers from different architectures to one format.
   */

  (void)strcpy(hstnam, SERV_HOST_NAME);  

  bzero ((char *)&sockstruct, sizeof sockstruct);
  sockstruct.sin_family = AF_INET;
  hp = gethostbyname(hstnam);
  if (hp == 0) { (void)fprintf(stderr, "%s: unknown host\n", hstnam);
		 exit(2);
	       }
  bcopy ((char *)hp->h_addr, (char *)&sockstruct.sin_addr, hp->h_length);
  sockstruct.sin_port = htons(MASTER_PORT); 

  /* connect to the socket created */
  sts = connect(sock, (struct sockaddr *) &sockstruct, sizeof(sockstruct));
  if (sts < 0) { perror("1connecting stream socket");
		 exit(1);
	       }
  bzero(port_str, MAXPRTNAMLNG);
  bzero(serv, MAXHSTNAMLNG);

  if (strlen(port) > 0)
    (void)strcpy(port_str, port);
  else
    (void)strcpy(port_str, "");

  port_ptr = &port_str[0];
  serv_ptr = &serv[0];
  fil_ptr = &fil[0];
  ivwsess_ptr = &ivwsess[0];

  /* replace this by call to inform_master() */
  (void)strcpy(token, "DBXCON");
  writeline(sock, token_ptr);
  writeline(sock, disp_host);
  writeline(sock, serv_host);
  writeline(sock, fil_ptr);
  writeline(sock, ivwsess_ptr);
  writeline(sock, idlb_ptr);
  writeline(sock, wdw_ptr);
  writeline(sock, port_ptr);

  (void)readline(sock, &port_ptr);
  (void)readline(sock, &serv_ptr);
  porty = atoi(port_str);
  (void)close(sock);

/* create a stream socket in the internet domain */
  sock = socket (AF_INET, SOCK_STREAM, 0);
  if (sock < 0) { perror("opening stream socket");
		  exit(1);
		}

  /* connect the socket using the given host's name and
   * a number which is a constant in this program.  
   * If operating between machines, this number may have to
   * be run through the function htons(), which converts
   * integers from different architectures to one format.
   */
  sockstruct.sin_family = AF_INET;
  hp = gethostbyname(serv);
  if (hp == 0) { (void)fprintf(stderr, "%s: unknown host\n", serv);
		 exit(2);
	       }
  bcopy ((char *)hp->h_addr, (char *)&sockstruct.sin_addr, hp->h_length);
  sockstruct.sin_port = htons((unsigned short)porty);

  /* connect to the socket created */
  if(connect(sock, (struct sockaddr *) &sockstruct, sizeof(sockstruct)) < 0)
    {
      perror("connect failure");
      exit(1);
    }
      
  return sock;
}


