/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/ivwmsg.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

/* ivwmsg.inc -- pertaining to messages between the two IDLView processes
 *  6-Aug-1987 17:20
 *  9-Aug-1987 11:45 -- changed from one structure to header + block structure
 * 10-Aug-1987  9:15 -- changed 'blklng' to 'addmsglng', and added
 *			'blklng' as the length of a requested block.
 * 12-Aug-1987 13:10 -- added 'STRREQMSG' type
 * 12-Aug-1987 14:00 -- changed mnemonics to reflect start/end structure;
 *			communications now start from user end and continue
 *			until ended from IDLView end.
 * 15-Jun-1988 21:15 -- added port number constant for internet
 *                      socket connection -- see the routine cnncmm()
 *  9-Oct-1988 14:32 -- removed ABOCMM as a message type -- we are no
 *                      longer attempting to abort communications with
 *                      a message type at all.
 *  9-Oct-1988 14:56 -- Added structure to contain status indication
 *                      after "additional message" bytes.  Currently
 *                      implemented as a 2-character array.
 * 20-Nov-1988 15:29 -- Added this comment to correct documentation on 
 *                      ack trailer, which is no longer put in message header.
 *                      The change to this file for ack trailers is
 *                      the a constant which defines the number of
 *                      characters used for the trailer.
 */

/* types of idlview messages */
typedef enum {	  UNKMSG	/* unknown message */
		, ENDCMM	/* End comm -- to user */
		, CDLMSG 	/* Candle file name from user */
		, FSTNODMSG 	/* First node from user  */
		, BLKMSG 	/* memory block from user  */
		, BLKREQMSG	/* request for memory block from user */
		, STRREQMSG	/* request for user string */
		, LLSCNTREQ	/* request for count of linked list set/seq */
		, LLSCNT	/* count returned for llist set/seq */
	     } ivwmsgtyp;

/* size of the character array containing bytes indicating
 * success or otherwise of additional bytes message transmission.
 */
#define ACKTRLSIZ 2

/* IDLView message header -- constant info across all messages */
/* any additional info comes in a block, with length specified below,
 * immediately after the header.
 */
typedef struct
{ ivwmsgtyp	msgtyp;		/* message identifier 		   */
  int		nodidt;		/* node identifier 		   */
  char *	adr;		/* address 			   */
  int		blklng;		/* length of block starting w/ adr */
  int		addmsglng;	/* length of additional message
				 *  (not including trailer chars)  */
}     ivwmsghdr;

#define SCKPRTNUM 2001		/* internet port number, arbitrarily chosen */
