/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/getstrttyprm.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* getstrttyprm -- get string from user's terminal with prompt
 *    this particular version replaces the newline character
 *    with a null character, just because that's what I needed
 *    this time...
 * 20-Nov-1987
 */

#include <stdio.h>
#include <string.h>

char *IDLstrchr();

char * getstrttyprm (prmstr, str, numchr)
  char *prmstr;
  char * str;
  int  numchr;
{
   FILE *ttyfil;
   char *newlinptr;

   /* open terminal for input/output */
   ttyfil = fopen ("/dev/tty", "r+");

   /* output prompt to user's terminal */
   (void)fputs (prmstr, ttyfil);

   /* get this input from the terminal */
   str = fgets (str, numchr, ttyfil);

   /* close the terminal -- we don't need it anymore */
   (void)fclose (ttyfil);

   /* replace the newline with a null character */
   newlinptr = IDLstrchr (str, '\n');
   *newlinptr = '\0';

   /* return our string argument */
   return str;
}
