/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/dump.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

		/*DOC+*/
/* dump.c
 * 	dump a block of memory to stdout -- included as a debugging
 *	aid for IDLView, where we often have to deal with 
 *	blocks of unstructured memory...
 */
#include <stdio.h>

dump(ptr, cnt)
  char* ptr;	/* pointer to memory to dump */
  int   cnt;	/* count of bytes to dump */
		/*DOC-*/
{
  char dspstr[10];
  char *dspstr2;
  int   i;

  (void)printf("%08x:", ptr);

  for (i=1; i<=cnt; i++) 
   {  (void)sprintf (dspstr, "%02x", (unsigned)(*(ptr++)));
      dspstr2 = &(dspstr[ (strlen(dspstr)) - 2 ]);
      (void)printf (" %s", dspstr2);
      if ((i % 8)==0) (void)printf("\n%08x:", ptr);
   }
  (void)printf("\n");
}
