/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/debug.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <C/global.h>
#include <C/reader.h>
#include <stdio.h>


/* for printing out label table */
/* print only entries which have values */

#define LTABSIZ 1024

PrintLabelTable(LabelTable)
LabelRefType LabelTable[LTABSIZ];
{

	int i;
	LabelRefType R;

	(void)fprintf(stderr, "LABEL TABLE\n");
	for (i=0; i<LTABSIZ; i++) {
	    
	    R = LabelTable[i];
	    if (R) (void)fprintf(stderr, "\n %d: ", i);
	    while (R) {
		(void)fprintf(stderr, "%s ", R->Name);
		R = R->next;
	    }
	}
	(void)fprintf(stderr, "\n\n");
	(void)fflush(stderr);
}
