/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/cmmlop.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: communications loop
*
*	loops through requests from IDLView process until an		*
*	end-of-communications message is received or error.  Returns	*
*	-1 on error in read/write, any other return is success.  	*
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
* 12-Aug-1987 16:15 Created.
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include <C/global.h>
#include "ivw.h"

		/*DOC+*/
cmmlop()
		/*DOC-*/
{
  ivwmsghdr	ivwmsg;		/* header for messages from IDLView */
  int		redsts;		/* status from socket read */
  int		wrtsts;		/* write status */
  ptr		blkptr;		/* pointer to any additional req. bytes */

  int		llscnt;		/* count of elements in llist structure */
  char	*	dmystr = "";	/* dummy string to send in case
                                 * we get a bad string 
				 */


  (void)printf("IDLView active...\n");

  ivwmsg.msgtyp = !ENDCMM;
  while (ivwmsg.msgtyp != ENDCMM)
  { redsts = rcvwdwmsg (&ivwmsg, &blkptr);
    if (redsts == -1) { perror ("IDLVlib: Error receiving IDLView header");
                        return -1;
                      }

    switch (ivwmsg.msgtyp)
    { case 
      BLKREQMSG: 
         /* build and send block message and block */
         ivwmsg.msgtyp = BLKMSG;
	 if (IVWFLS==chkadr(ivwmsg.adr, ivwmsg.blklng)
	    )
	    { (void)printf("Illegal block address (%x, length %d [%x hex])\n",
		     ivwmsg.adr, ivwmsg.blklng, ivwmsg.blklng);
	      ivwmsg.adr = dmystr;
	      ivwmsg.addmsglng = 1;
	    }
	    else
            { ivwmsg.addmsglng = ivwmsg.blklng;
	    }

         wrtsts = sndwdwmsg (ivwmsg);
         if (wrtsts == -1) 
           { perror ("IDLVlib: Error sending requested block");
             return -1;
           }
         break;

      case 
      STRREQMSG:
	 ivwmsg.msgtyp = BLKMSG;
         if (IVWFLS==chkadr(ivwmsg.adr, 1))
           { (void)printf("Illegal string address (%x)\n", ivwmsg.adr);
	     ivwmsg.addmsglng = 1;
	     ivwmsg.adr = dmystr;
           }
         else 
	   { ivwmsg.addmsglng = strlen(ivwmsg.adr) + 1;
	   }
         wrtsts = sndwdwmsg (ivwmsg);
         if (wrtsts == -1) 
           { perror ("IDLVlib: Error sending requested string");
             return -1;
           }
	 break;

      case 
      LLSCNTREQ:
         ivwmsg.msgtyp = LLSCNT;

	 if (IVWFLS==chkadr(ivwmsg.adr,4))
	        { (void)printf("Illegal set or sequence address (%x)\n");
	          llscnt = 0;
	        }
	   else { llscnt = IDLListLength((pGenList)ivwmsg.adr);
	        }

         ivwmsg.addmsglng = sizeof(llscnt);
         ivwmsg.adr       = (char*)&llscnt;
         wrtsts = sndwdwmsg (ivwmsg);
         if (wrtsts == -1)
           { perror ("IDLVlib: Error sending requested llist count");
             return -1;
           }
         break;

      case 
      ENDCMM:
	 break;

      default: 
	 (void)printf("Bad IDLView message type, #%d\n", ivwmsg.msgtyp);
	 (void)printf("Aborting communications with IDLView\n");
	 return 0;
    }
  }

  return 0;
}
