/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/chkadr.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*									* 
*   Function: check address: Determine whether a given address points   *
*	to a legal address.
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*  8-Jan-1989 --  rc -- creation
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include "ivw.h"
#include <sys/types.h>

#define TOPADR 0xeffffff
caddr_t sbrk();
extern int end, etext, edata;

int chkadr (adr, len)
  int adr;
  int len;

{ int bosadr;		/* address of bottom of stack --
			 * THIS VARIABLE NEEDS TO BE THE FIRST
			 * LOCAL VARIABLE DECLARED IN THIS ROUTINE.
			 * DON'T MOVE IT OR DECLARE IT DIFFERENTLY.
			 */
  int topdatadr;	/* top data address */
  caddr_t heptop;	/* top of heap */
  int dspflg = IVWFLS;	/* display flag -- used in debugging
			 * to display values of etext, bosadr,
			 * and heptop.  dbx 'print' nor
			 * "printf()" seem to do the job.
			 * To use, the user needs to set 'dspflg'
			 * to IVWTRU in the debugger.
			 */

  topdatadr = adr + len - 1;  /* calculate top address of data structure */
  heptop = sbrk(0);           /* get top of heap from Unix */

  /* The entire address area of the user (thus, both addresses) must
   * be either within the stack area or within the data
   * area of a C program.  The stack runs from the address
   * of our first locally-declared variable to 0effffff;
   * the data area runs from the top of the executable code (&etext) to
   * the top of the heap (returned by sbrk())
   */

  /* display the relevant addresses if the flag says to;
   * reset the flag also.
   */
  if (dspflg==IVWTRU) { (void)printf (" %8x %8x \n %8x %8x \n",
				     (int)(&bosadr), TOPADR,
				     (int)(&etext),  (int)heptop
			       );
			dspflg = IVWFLS;
		      }

  if    (   ( 
	         (      adr >= (int)(&bosadr) &&       adr < TOPADR)
              && (topdatadr >= (int)(&bosadr) && topdatadr < TOPADR)
	    )
          ||
	    (    (      adr >= (int)(&etext) &&       adr < (int)(heptop))
	      && (topdatadr >= (int)(&etext) && topdatadr < (int)(heptop))
	    )
	)

	  return IVWTRU;
     else return IVWFLS;
}

