/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/boxstc.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*		
*	structures describing box on screen				* 
*   A 'box' in IDLView is a screen display object.  It could be:
*  	atomic or node
*  	member of set, or member of sequence, or not member of either
*
*   In later versions of IDLView, a box could contain other things; 
*   e.g., one IDLView feature under discussion is expanding the detail
*   shown for an attribute, and such an expansion might be shown in another
*   box.
*
*   A box on the screen has a screen position and zero or more 'box
*   attributes' (abbreviation 'bat'); these are analagous to attributes
*   of IDL nodes.  They have their own structure, see 'batstc.h'
*
*   requires:
*	ivw.h
*	scrpos.h
*	batstc.h
*  	idl-generated-include file
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*	6-Aug-1987 17:20 (cook) Created.
*									* 
\***********************************************************************/ 

#ifndef BOXSTCDEF
#define BOXSTCDEF 1

#ifndef IVWDEF
#include "ivw.h"	/* for 'ptr' declaration */
#endif

#ifndef SCRPOSDEF
#include "scrpos.h"	/* for box screen description */
#endif

#ifndef BATSTCDEF
#include "batstc.h"	/* for box attribute descriptions */
#endif
 
 /* since box and box attribute handles are in box and box attribute 
  * structures, they both define the handles used in the structures. 
  * The conditional compilation allows them to be defined only once. 
  */ 
#ifndef HNDDEF   
#define HNDDEF
typedef long bathnd;            /* integer into array of box attrib handles */
typedef long boxhnd;            /* integer into array of box handles */
#endif 

typedef enum {    UNKBOXTYP	/* unknown or uninitialized type */
		, NODBOXTYP	/* box for an IDL node */
		, STRBOXTYP	/*  string */
		, INTBOXTYP	/*  integer */
		, RATBOXTYP	/*  float */
		, BOOBOXTYP	/*  Boolean */
	     } boxtyptyp;

#define FSTBOXNUM 1    /* first number used as index to array of boxes */
#define MAXBOXARY 2500 /* maximum number of boxes in IDLView */
#define NULBOX -1      /* non-existent box handle */

/* boxdscstc -- structure describing box */
struct boxstc
{ boxtyptyp	boxtyp;		    /* type of box */
  int		boxnum;		    /* identifying number of this box */
  bathnd	srcbat; 	    /* box attribute pointing to this box */
  TypeEntity   	cdltypent;	    /* Candle type entity */
  ptr		lclblk;		/**//* ptr to representation for this block */
  ptr		usradr;		    /* address of block in user addr space */
  struct scrposstc scrpos;	    /* screen description */
  bathnd	batlnk;		    /* handle to first attribute */
  int		setseqnum;	    /* number of this element in set or seq 
				     * -1 indicates not member of set or seq 
				     */
  boxhnd	nxtsetseqbox;	    /* next next box in set or seq */
  ptr		setseqllsnodadr;    /* user's address of linked list node */
  int		attnamwid;	    /* width for display of attribute names */
  int		dtldsp;		    /* IVWTRU=>detail displayed */
} ;

struct boxstc *cnvboxhnd();	/* convert box handle to box pointer */

#endif /* end ifndef BOXSTCDEF */
