/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/batstc.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   box attribute (bat) description
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
* 6-Aug-1987 17:20
*    attributes are sub-elements of boxes, and get their own
*    descriptive structure 
* 13-Sep-1987 -- changed named to batdsc.h -- established 'bat'
*    as abbreviation for 'box attribute' to distinguish it more
*    easily from a Candle attribute description.
* requires:
*    valptrunn.h	union for one of each C data type
*    ivw.h
*    'h' file from Candle (for Attribute declaration)
*    scrpos.h
*									* 
\***********************************************************************/ 


#ifndef BATSTCDEF
#define BATSTCDEF

#ifndef IVWDEF
#include "ivw.h"
#endif

#ifndef BOXSTCDEF
#include "boxstc.h"
#endif

#ifndef VALPTRUNNDEF
#include "valptrunn.h"
#endif

#ifndef SCRPOSDEF
#include "scrpos.h"
#endif

#define NULBAT -1		/* non-existent box attribute handle */
#define MAXBATARY 10000		/* maximum box attributes in IDLView */

/* since box and box attribute handles are in box and box attribute
 * structures, they both define the handles used in the structures.
 * The conditional compilation allows them to be defined only once.
 */
#ifndef HNDDEF
#define HNDDEF
typedef long bathnd;		/* integer into array of box attrib handles */
typedef long boxhnd;		/* integer into array of box handles */
#endif

#define FSTBATNUM 1		/* first index into box attribute pointers */

typedef enum {   UNKBATTYP	/* unknown or uninitialized box attribute */
	       , ATMBATTYP	/* atomic box attribute */
	       , SETBATTYP	/* set box attribute */
	       , SEQBATTYP	/* sequence box attribute */
	       , NODBATTYP	/* node box attribute */
	     } battyptyp;

struct batstc
{  
   battyptyp	    battyp;	    /* type of box attribute */
   boxhnd           srcbox;	    /* box containing this box attribute */
   bathnd           thsbat;	    /* handle to this box attribute */
   boxhnd	    dstbox;	    /* destination box -- box expanded to */
   union valptrunn  valptr;	    /* pointer to value in memory */
   ptr		    usradr;	    /* pointer to value in user's memory */
   Attribute	    cdlatt;	    /* Candle attribute */
   bathnd           batlnk;	    /* handle to next box attribute */
   struct scrposstc scrpos;	    /* position on screen */
   int		    setseqcnt;	/**//* count of set or sequence */
   int		    dtldsp;	    /* detail displayed */
};

struct batstc *cnvbathnd();	/* convert box attribute handle to pointer */

#endif
