/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/array.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <C/global.h>

# define FArray(arr,siz)	FreeHeap(arr,siz)
	/* allocate 8 cells at a time */
# define MORECELLS 8

Boolean IDLInArray(arr, elem)
GenArray arr;
int elem;
{
    register int i;
    for (i=0; i<arr.length; i++)
	if (arr.array[i] == elem)
	    return(TRUE);
    return(FALSE);
}

GenArray IDLArraySort(arr, cmpfn)
GenArray arr;
Boolean (*cmpfn)();
{
    register int i,j;
    int tmp;
    int change;

    for (i=0; i<arr.length-1; i++){
	change = 0;
	for (j=0; j<arr.length-1-i; j++){
	    if (cmpfn(arr.array[j+1], arr.array[j])){ /* swap */
		tmp = arr.array[j+1];
		arr.array[j+1] = arr.array[j];
		arr.array[j] = tmp;
		change = 1;
	    }
	}
	if (!change) break;
    }
    return arr;
}

GenArray IDLArraySortUnion(arr, cmpfn)
GenArray arr;
Boolean (*cmpfn)();
{
    register int i,j;
    int tmp;
    int change;

    for (i=0; i<arr.length-1; i++){
	change = 0;
	for (j=0; j<arr.length-1-i; j++){
#ifdef sparc
#define UNION_FLAG
	    if (cmpfn((int *)&(arr.array[j+1]), (int *)&(arr.array[j]))) {
#endif
#ifndef UNION_FLAG
	    if (cmpfn(arr.array[j+1], arr.array[j])) {
#endif
		tmp = arr.array[j+1];
		arr.array[j+1] = arr.array[j];
		arr.array[j] = tmp;
		change = 1;
	    }
	}
	if (!change) break;
    }
    return arr;
}

void IDLArrayOrderedInsert(arr, elem, cmpfn)
GenArray *arr;
int elem;
Boolean (*cmpfn)();
{
    Boolean insert = FALSE;
    int *newarray;
    int i,j;

    if (arr->length >= arr->size) { /* allocate more space */
	arr->size += MORECELLS;
	newarray = IDLNewArray(arr->size);
	for (i=0; i<arr->length; i++)
	    newarray[i] = arr->array[i];
	if(arr->size-MORECELLS) {
           FArray(arr->array, arr->size-MORECELLS);
        }
	arr->array = newarray;
    }
	
    for (i=0; i<arr->length; i++)
	if (cmpfn(arr->array[i], elem)) {
	    insert = TRUE;
	    break;
	}
    if (insert) {
	for (j=arr->length; j>i; j--)
	    arr->array[j] = arr->array[j-1];
	++(arr->length);
	arr->array[i] = elem;
    }
    else {
	arr->array[arr->length] = elem;
	++(arr->length);
    }
}

void IDLArrayOrderedInsertUnion(arr, elem, cmpfn)
GenArray *arr;
int elem;
Boolean (*cmpfn)();
{
    Boolean insert = FALSE;
    int *newarray;
    int i,j;

    if (arr->length >= arr->size) { /* allocate more space */
	arr->size += MORECELLS;
	newarray = IDLNewArray(arr->size);
	for (i=0; i<arr->length; i++)
	    newarray[i] = arr->array[i];
	if(arr->size-MORECELLS) {
           FArray(arr->array, arr->size-MORECELLS);
        }
	arr->array = newarray;
    }
	
    for (i=0; i<arr->length; i++)
#ifdef sparc
#define UNION_FLAG
	if (cmpfn((int *)&(arr->array[i]), (int *)&(elem))) {
#endif
#ifndef UNION_FLAG
	if (cmpfn(arr->array[i], elem)) {
#endif
	    insert = TRUE;
	    break;
	}
    if (insert) {
	for (j=arr->length; j>i; j--)
	    arr->array[j] = arr->array[j-1];
	++(arr->length);
	arr->array[i] = elem;
    }
    else {
	arr->array[arr->length] = elem;
	++(arr->length);
    }
}


    
void IDLArrayAddFront(arr, elem)
GenArray *arr;
int elem;
{
    int i;
    int *newarray;

    if (arr->length >= arr->size) { /* allocate more space */
	arr->size += MORECELLS;
	newarray = IDLNewArray(arr->size);
	for (i=0; i<arr->length; i++)
	    newarray[i] = arr->array[i];
	if(arr->size-MORECELLS) {
           FArray(arr->array, arr->size-MORECELLS);
        }
	arr->array = newarray;
    }

    for (i=arr->length; i>0; i--)
	arr->array[i] = arr->array[i-1];
    arr->array[0] = elem;
    ++(arr->length);
}

void IDLArrayAddRear(arr, elem)
GenArray *arr;
int elem;
{
    int i;
    int *newarray;

    if (arr->length >= arr->size) { /* allocate more space */
	arr->size += MORECELLS;
	newarray = IDLNewArray(arr->size);
	for (i=0; i<arr->length; i++)
	    newarray[i] = arr->array[i];
	if(arr->size-MORECELLS) {
           FArray(arr->array, arr->size-MORECELLS);
        }
	arr->array = newarray;
    }

    ++(arr->length);
    arr->array[arr->length-1] = elem;
}

GenArray IDLArrayTail(arr)
GenArray arr;
{
    int i;
    GenArray tailarr;

    tailarr.array = IDLNewArray(arr.size);
    tailarr.size = arr.size;
    tailarr.length = arr.length - 1;
    for (i=1; i<arr.length; i++)
	tailarr.array[i-1] = arr.array[i];
    return(tailarr);
}

void IDLArrayRemoveFirstElem(arr)
GenArray *arr;
{
    int i;

    if (arr->length) {
	for (i=0; i<arr->length - 1; i++)
	    arr->array[i] = arr->array[i+1];
	--(arr->length);
    }
}

void IDLArrayRemoveIthElem(arr,index)
GenArray *arr;
int index;
{
    int i;

    if (arr->length && index >= 1 && index <= arr->length) {
	for (i=index-1; i<arr->length - 1; i++)
	    arr->array[i] = arr->array[i+1];
	--(arr->length);
    }
}

void IDLArrayRemoveElem(arr, elem)
GenArray *arr;
int elem;
{
    int i,j;
    Boolean found = FALSE;

    for (i=0; i<arr->length; i++)
	if (arr->array[i] == elem) {
	    found = TRUE;
	    break;
	}
    if (found) {
	for (j=i; j<arr->length - 1; j++)
	    arr->array[j] = arr->array[j+1];
	--(arr->length);
    }
}

GenArray IDLArrayCopy(arr)
GenArray arr;
{
	GenArray newarraystruct;
	int i;

	newarraystruct.array = IDLNewArray(arr.size);
	newarraystruct.size = arr.size;
	newarraystruct.length = arr.length;
	for (i=0; i<arr.length; i++)
	    newarraystruct.array[i] = arr.array[i];

	return(newarraystruct);
}
