/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/alloc.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
extern char *malloc();


/* keep an array of different sizes for free */

/* maximum size for this array (size=index * 4) */
#define MAXSIZE	 400
#define MAXINDEX MAXSIZE/4+1

typedef struct memchunk {
	struct memchunk *next;
} *memchunkptr;
static struct {
	memchunkptr free;
} memory_chunks[MAXINDEX];

/* number of chunks to allocate at one time    */
/* for sizes <= BOUNDARY, MANY are allocated.  */
/* for sizes > BOUNDARY.  FEW are allocated.   */
#define MANY		100
#define FEW		10
#define BOUNDARY	48

#ifdef MONITOR
/* keep an array for count for each size */
int mem_counts[MAXINDEX];
#endif

void out_of_memory();
void exit();

int GetHeap(size)
int size;
{
    int 	storage;
    int 	mod4;
    int 	index;
    int 	num_allocs;
    int		i;
    memchunkptr mp;

    /* the size must be a multiple of 4 */
    if ((mod4 = size%4) > 0)
	size += 4 - mod4;
    index = size/4;

    /* if too big, just use malloc */
    if (size > MAXSIZE) {
	storage = (int)malloc((unsigned)size);
#ifdef DEBUG
	(void)fprintf(stderr, "allocating big size %d at ptr %ld\n", size, storage);
#endif
	if (storage == 0)
	    out_of_memory();
	else return(storage);
    }


    /* check if there are any free chunks left for this size */
    if (memory_chunks[index].free == NULL) {

	/* allocate MANY if size <= BOUNDARY else allocate FEW */
	if (size <= BOUNDARY)
	    num_allocs = MANY;
	else
	    num_allocs = FEW;

	while (num_allocs > 0) {
	    mp = (memchunkptr)malloc((unsigned)size * num_allocs);
	    /* if there isn't enough storage, try half as many */
	    if (mp == NULL) {
		num_allocs = num_allocs/2;
	    }
	    else break;
	}
	if (mp == NULL) {
	    out_of_memory();
	}
#ifdef DEBUG
	(void)fprintf(stderr, "allocated %d for size %d\n", num_allocs, size);
#endif
	memory_chunks[index].free = mp;

	/* reset the next pointers */
	for (i=0; i<num_allocs-1; i++) {
	    mp->next = (memchunkptr)((char *)mp + size);
	    mp = mp->next;
	}
	mp->next = NULL;
    }

    storage = (int)(memory_chunks[index].free);
    memory_chunks[index].free = memory_chunks[index].free->next;

#ifdef DEBUG
    {
    static int count=0;
    if ((++count % 1000)==0) {
	if (malloc_verify()!=1) {
	    (void)printf("heap corrupted\n");
	    exit(-1);
	}
    }
    }
#endif
#ifdef MONITOR
    ++mem_counts[index];
#endif

    return(storage);
}

/*VARARGS*/
void FreeHeap(ptr, size)
char *ptr;
int size;
{
    int index;

    index = size/4;

    /* if too big, just use free */
    if (size > MAXSIZE) 
	free(ptr);
    else {
	((memchunkptr)ptr)->next = memory_chunks[index].free;
	memory_chunks[index].free = (memchunkptr)ptr;
    }
}

void
out_of_memory()
{
    (void)fprintf(stderr, "******Ran out of heap storage*****\n");
    exit(1);
}

#ifdef MONITOR
void print_memcounts()
{
    register int i;

    for (i=0; i<MAXINDEX; i++) {
	if (mem_counts[i] > 0)
	    (void)fprintf(stderr, "size %3d: cnt %6d\n", i*4, mem_counts[i]);
    }
}
#endif
