/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libidl/IDLstring.c 
*				 					* 
*   Copyright (C) 1991 Hasnain Karampurwala
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*   Contains the functions IDLstrchr and IDLstrrchr.			*
*   Across implementations of UNIX these functions are not uniformly	*
*   supported. They provide replacements for strchr(index) and 		*
*   strrchr (rindex) within the IDLtoolkit.
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*	5 Feb 1991 (hkaram) Created.
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>

/* IDLstrchr(s,c) - Returns a pointer to the first occurrance 
 * of character c in string s. If s is NULL or the character 
 * was not found in s, then a NULL pointer is returned. 
 */
char *IDLstrchr(s,c)
char *s,c;
{
 if (s == NULL) 
   return NULL;
 for(; *s; s++)
   if(*s == c) 
     return s;
 return (c == '\0') ? s : NULL;
}

/* IDLstrrchr(s,c) - Returns a pointer to the last occurrance 
 * of character c in string s. If s is NULL or the character 
 * was not found in s, then a NULL pointer is returned. 
 */
char *IDLstrrchr(s,c)
char *s,c;
{
 char *last = NULL;
 
 if (s == NULL) 
   return NULL;
 for(; *s; s++)
   if(*s == c) 
     last = s;
 return (c == '\0') ? s : last;
}
