/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/liberr/err.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* 'ERR' added in front of all module names */
#include <stdio.h>

FILE *current_file= NULL;  		  /* the current file pointer */

void ERRNewErrorInstance(fp, number, sourcepos)
FILE *fp;
int number;	/* error number */
int sourcepos;  /* source position of error */
{
	current_file = fp;
	(void)fprintf(current_file, "ErrorInstance  [\n");
	(void)fprintf(current_file, "    number %d;\n", number);
	(void)fprintf(current_file, "    source_position %d;\n", sourcepos);
	(void)fprintf(current_file, "    arguments <\n");
}

void ERRAddStringArg(strarg)
char *strarg;
{

	if (current_file == NULL) {
	    (void)fprintf(stderr, "liberr.a: No Error Instance created.\n");
	    return;
	}
	(void)fprintf(current_file, "\tstring_argument[value \"%s\"]\n", strarg);
}

void ERRAddIntegerArg(intarg)
int intarg;
{
	if (current_file == NULL) {
	    (void)fprintf(stderr, "liberr.a: No Error Instance created.\n");
	    return;
	}
	(void)fprintf(current_file, "\tinteger_argument[value %d]\n", intarg);
}

void ERRWriteErrorInstance()
{
	if (current_file == NULL) {
	    (void)fprintf(stderr, "liberr.a: No Error Instance created.\n");
	    return;
	}
	(void)fprintf(current_file, "    >\n");
	(void)fprintf(current_file, "]\n");
	(void)fprintf(current_file, "#\n");
	current_file = NULL;
}
