/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/strarg.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  strarg  --  parse a string
 *
 *  Usage:  p = strarg (ptr, brk, prompt, defalt, buf);
 *	char *p, **ptr, *brk, *prompt, *defalt, *buf;
 *
 *  Strarg will parse an argument from the string pointed to by "ptr",
 *  bumping ptr to point to the next argument in the string.
 *  The argument parsed will be copied into "buf".  If there is no
 *  argument, then getstr() will be called, and the value placed into
 *  buf.  In any event, the address of buf is returned as a value.
 *  "Brk" is the list of characters which terminate an argument;
 *  if 0, then " " is used.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Rewritten for VAX.
 *
 */

#include <string.h>

int strcmp();
char *nxtarg();
char *getstr();

char *strarg (ptr, brk, prompt, defalt, buf)
char **ptr, *brk, *prompt, *defalt, *buf;
{
	register char *arg;

	arg = nxtarg (ptr,brk);		/* parse an argument */

	if (*arg && strcmp (arg,"?")!=0)  (void)strcpy (buf,arg);
	else (void)getstr (prompt,defalt,buf);

	return (buf);
}
