/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/shortarg.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  shortarg  --  parse short integer argument
 *
 *  Usage:  i = shortarg (ptr,brk,prompt,min,max,default)
 *    short i,min,max,default;
 *    char **ptr,*brk,*prompt;
 *
 *  Will attempt to parse an argument from the string pointed to
 *  by "ptr", incrementing ptr to point to the next arg.  If
 *  an arg is found, it is converted into a short.  If there is
 *  no arg or the value of the arg is not within the range
 *  [min..max], then "getshort" is called to ask the user for an
 *  short value.
 *  "brk" is the list of characters which terminate an argument;
 *  if 0, then " " is used.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Created for VAX.
 *
 */

#include <stdio.h>
#include <ctype.h>

short getshort();
char *nxtarg();
int atoi();
int strcmp();

short shortarg (ptr,brk,prompt,min,max,defalt)
char **ptr;
char *brk,*prompt;
short min,max,defalt;
{
	register short i;
	register char *arg,*p;

	arg = nxtarg (ptr,brk);

	if (*arg != '\0') {		/* if there was an arg */
		for (p=arg; *p && (isdigit(*p) || *p == '-' || *p == '+'); p++) ;
		if (*p) {
			if (strcmp(arg,"?") != 0)  (void)printf ("%s not numeric.  ",arg);
		} 
		else {
			i = atoi (arg);
			if (i<min || i>max) {
				(void)printf ("%d out of range.  ",i);
			}
		}
	}

	if (*arg == '\0' || *p != '\0' || i<min || i>max) {
		i = getshort (prompt,min,max,defalt);
	}

	return (i);
}
