/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/runv.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  run, runv --  execute process and wait for it to exit
 *
 *  Usage:
 *	i = run (file, arg1, arg2, ..., argn, 0);
 *	i = runv (file,arglist);
 *
 *  Run and runv have argument lists exactly like the corresponding
 *  routines, execl and execv.  The run routines  perform a fork, then:
 *  IN THE NEW PROCESS, an execl or execv is performed with the
 *  specified arguments.  The process returns with a -1 code if the
 *  exec was not successful.
 *  IN THE PARENT PROCESS, the signals SIGQUIT and SIGINT are disabled,
 *  the process waits until the newly forked process exits, the
 *  signals are restored to their original status, and the return
 *  status of the process is analyzed.
 *  Run and runv return:  -1 if the exec failed or if the child was
 *  terminated abnormally; otherwise, the exit code of the child is
 *  returned.
 *
 *  HISTORY
 * 15-July-82 Mike Accetta (mja) and Neal Friedman (naf)
 *				  at Carnegie-Mellon University
 *	Added a return(-1) if vfork fails.  This should only happen
 *	if there are no more processes available.
 *
 * 28-Jan-80  Steven Shafer (sas) at Carnegie-Mellon University
 *	Added setuid and setgid for system programs' use.
 *
 * 21-Jan-80  Steven Shafer (sas) at Carnegie-Mellon University
 *	Changed fork to vfork.
 *
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Rewritten for VAX (no real changes from PDP-11).
 *	The sleazy "&" hack is the same as that in quit(); see the first
 *	HISTORY message there for a justification of its use.
 *
 */
/*LINTLIBRARY*/
#include <stdio.h>
#include <signal.h>

int run (name,argv)
char *name,*argv;
{
	return (runv (name,&argv));
}


/* Two different versions of signals are used in different UNIX implementations
      int  (*signal)();
   and 
      void (*signal)();
   The sequent and vax use the 1st defn. Suns and mips use the 2nd defn.
   If you have problems please change the defines below for your purpose.
*/ 
#ifdef sequent
#define TYPEOFSIGNAL int
#endif
#ifdef vax
#define TYPEOFSIGNAL int
#endif
/* for suns, mips */
#ifndef TYPEOFSIGNAL
#define TYPEOFSIGNAL void
#endif

int runv (name,argv)
char *name,**argv;
{
	int status,wpid;
	register int pid;
	register TYPEOFSIGNAL (*savint)(), (*savquit)();


	if ((pid = vfork()) == -1)
		return(-1);	/* no more process's, so exit with error */


	if (pid == 0) {			/* child process */
		(void)setgid(getgid());
		(void)setuid(getuid());
		(void)execv (name,argv);
		(void)fprintf (stderr,"run: can't exec %s\n",name);
		_exit (0377);
	}

	savint = signal (SIGINT,(TYPEOFSIGNAL (*)()) SIG_IGN); /* ignore intrpts */
	savquit = signal (SIGQUIT,(TYPEOFSIGNAL (*)()) SIG_IGN); /* ignore quits */
	do {
		wpid = wait (&status);
	} 
	while ((wpid != pid) && (wpid != -1));
	(void)signal (SIGINT,(TYPEOFSIGNAL (*)()) savint);	/* restore signals */
	(void)signal (SIGQUIT,(TYPEOFSIGNAL (*)()) savquit);

	if ((status & 0377) != 0 || ((status >> 8) & 0377) == 0377)
		return (-1);

	return ((status >> 8) & 0377);
}
