/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/octarg.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  octarg  --  parse octal integer argument
 *
 *  Usage:  i = octarg (ptr,brk,prompt,min,max,default)
 *    unsigned int i,min,max,default;
 *    char **ptr,*brk,*prompt;
 *
 *  Will attempt to parse an argument from the string pointed to
 *  by "ptr", incrementing ptr to point to the next arg.  If
 *  an arg is found, it is converted into an octal integer.  If there is
 *  no arg or the value of the arg is not within the range
 *  [min..max], then "getoct" is called to ask the user for an
 *  octal integer value.
 *  "Brk" is the list of characters which may terminate an argument;
 *  if 0, then " " is used.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Rewritten for VAX.
 *
 */

#include <ctype.h>
#include <stdio.h>

unsigned int getoct();
char *nxtarg();
unsigned int atoo();
int strcmp();

int octarg (ptr,brk,prompt,min,max,defalt)
char **ptr;
char *brk,*prompt;
unsigned int min,max,defalt;
{
	register unsigned int i;
	register char *arg,*p;

	arg = nxtarg (ptr,brk);

	if (*arg != '\0') {		/* if there was an arg */
		for (p=arg; *p && (*p >= '0' && *p <= '7'); p++) ;
		if (*p) {
			if (strcmp(arg,"?") != 0)  (void)printf ("%s not octal number.  ",arg);
		} 
		else {
			i = atoo (arg);
			if (i<min || i>max) {
				(void)printf ("%s%o out of range.  ",
					(i ? "0" : ""),i);
			}
		}
	}

	if (*arg == '\0' || *p != '\0' || i<min || i>max) {
		i = getoct (prompt,min,max,defalt);
	}

	return (i);
}
