/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/mktemp.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* @(#)mktemp.c	4.1 (Berkeley) 12/21/80 */

/* mktemp -- make unique file name
 *
 * HISTORY
 * 10-Dec-81  Jerry Denlinger (jld) at Carnegie-Mellon University
 *	Added capability for more X's.  As many X's as are supplied
 *	are used for constructing the name.  If n X's are given,
 *	26 ^ (n - 5) unique names can be generated.
 *	
 *	The variable c has been changed to a long which contains the
 *	number of times the routine has been called instead of the
 *	next unique character to be used.
 *
 * 15-Aug-81  Mike Accetta (mja) at Carnegie-Mellon Univeristy
 *	Made changes below conditional under CMU for 4.1BSD.
 *
 * 16-Feb-80  Steven Shafer (sas) at Carnegie-Mellon University
 *	Added "c"; changed code from bogus "access" check for unique
 *	names to a static char that always gets updated.
 *
 */

char *
mktemp(as)
char *as;
{
	register char *s;
	register unsigned pid;
#if	CMU
	register Xcount = 0; 
	static long c = 0;
	long n;
#else
	register i;
#endif

	pid = getpid();
	s = as;
	while (*s++)
		;
	s--;
	while (*--s == 'X') {
#if	CMU
		Xcount++;
#endif
		*s = (pid%10) + '0';
		pid /= 10;
	}
	s++;
#if	CMU
	if (Xcount < 6) return ("/");

	/* add in unique letters -- leave 5 chars for process id */
	for (n=c; Xcount > 5; Xcount--, s++) {
		if (!n) *s = 'a';	/* pad out end with a's */
		else {
			*s = (n % 26) + 'a';
			n /= 26;
		}
	}
	c++;
	if (n) return ("/");
#else
	i = 'a';
	while (access(as, 0) != -1) {
		if (i=='z')
			return("/");
		*s = i++;
	}
#endif
	return(as);
}
