/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/longarg.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  longarg  --  parse long integer argument
 *
 *  Usage:  i = longarg (ptr,brk,prompt,min,max,default)
 *    long i,min,max,default;
 *    char **ptr,*brk,*prompt;
 *
 *  Will attempt to parse an argument from the string pointed to
 *  by "ptr", incrementing ptr to point to the next arg.  If
 *  an arg is found, it is converted into an long.  If there is
 *  no arg or the value of the arg is not within the range
 *  [min..max], then "getlong" is called to ask the user for an
 *  long value.
 *  "brk" is the list of characters which terminate an argument;
 *  if brk is 0, then " " is used.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Created for VAX.
 *
 */

#include <ctype.h>
#include <stdio.h>

long getlong();
char *nxtarg();
long atol();
int strcmp();

long longarg (ptr,brk,prompt,min,max,defalt)
char **ptr;
char *brk, *prompt;
long min,max,defalt;
{
	register long i;
	register char *arg,*p;

	arg = nxtarg (ptr,brk);

	if (*arg != '\0') {		/* if there was an arg */
		for (p=arg; *p && (isdigit(*p) || *p == '-' || *p == '+'); p++) ;
		if (*p) {
			if (strcmp(arg,"?") != 0)  (void)printf ("%s not numeric.  ",arg);
		} 
		else {
			i = atol (arg);
			if (i<min || i>max) {
				(void)printf ("%D out of range.  ",i);
			}
		}
	}

	if (*arg == '\0' || *p != '\0' || i<min || i>max) {
		i = getlong (prompt,min,max,defalt);
	}

	return (i);
}
