/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/hexarg.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  hexarg  --  parse hexadecimal integer argument
 *
 *  Usage:  i = hexarg (ptr,brk,prompt,min,max,default)
 *    unsigned int i,min,max,default;
 *    char **ptr,*brk,*prompt;
 *
 *  Will attempt to parse an argument from the string pointed to
 *  by "ptr", incrementing ptr to point to the next arg.  If
 *  an arg is found, it is converted into an hexadecimal integer.  If there is
 *  no arg or the value of the arg is not within the range
 *  [min..max], then "gethex" is called to ask the user for an
 *  hexadecimal integer value.
 *  "Brk" is the list of characters which may terminate an argument;
 *  if 0, then " " is used.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Created for VAX.
 *
 */

#include <string.h>
#include <stdio.h>
#include <ctype.h>

unsigned int gethex();
char *nxtarg();
unsigned int atoh();
int strcmp();

int hexarg (ptr,brk,prompt,min,max,defalt)
char **ptr;
char *brk,*prompt;
unsigned int min,max,defalt;
{
	register unsigned int i;
	register char *arg,*p;

	arg = nxtarg (ptr,brk);

	if (*arg != '\0') {		/* if there was an arg */
		if (arg[0]=='0' && (arg[1]=='x' || arg[1]=='X'))
			(void)strcpy (arg,arg+2);
		for (p=arg; *p && ((*p >= '0' && *p <= '9') ||
			(*p >= 'a' && *p <= 'f') ||
			(*p >= 'A' && *p <= 'F')); p++);
		if (*p) {
			if (strcmp(arg,"?") != 0)  (void)printf ("%s not hexadecimal number.  ",arg);
		} 
		else {
			i = atoh (arg);
			if (i<min || i>max) {
				(void)printf ("%s%x out of range.  ",
					(i ? "0x" : ""),i);
			}
		}
	}

	if (*arg == '\0' || *p != '\0' || i<min || i>max) {
		i = gethex (prompt,min,max,defalt);
	}

	return (i);
}
