/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/getstr.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  getstr --  prompt user for a string
 *
 *  Usage:  p = getstr (prompt,defalt,answer);
 *	char *p,*prompt,*defalt,*answer;
 *
 *  Getstr prints this message:  prompt  [defalt]
 *  and accepts a line of input from the user.  This line is
 *  entered into "answer", which must be a big char array;
 *  if the user types just carriage return, then the string
 *  "defalt" is copied into answer.
 *  Value returned by getstr is just the same as answer,
 *  i.e. pointer to result string.
 *
 *  HISTORY
 * 21-Oct-80  Fil Alleva (faa) at Carnegie-Mellon University
 *	Getstr() now percuolates any errors from gets() up to the calling
 *	routine.
 *
 * 19-May-80  Steven Shafer (sas) at Carnegie-Mellon University
 *	Increased buffer size to 4000 characters.  Why not?
 *
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Rewritten for VAX.  Mike thinks a 0 pointer for the default should
 *	print no default (i.e. not even braces); I'm not sure I like the idea
 *	of a routine that doesn't explicitly tell you what happens if you
 *	just hit Carriage Return.
 *
 */

#include <stdio.h>
#include <string.h>

char *getstr (prompt,defalt,answer)
char *prompt,*defalt,*answer;
{
	char defbuf[4000];
	register char *retval;

	(void)printf ("%s  [%s]  ",prompt,defalt);
	(void)fflush (stdout);
	(void)strcpy (defbuf,defalt);
	retval = (char *) gets (answer);
	if (*answer == '\0')  (void)strcpy (answer,defbuf);
	if (retval == NULL)
	    return (retval);
	else
	    return (answer);
}
