/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/getsearch.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  getsearch  --  ask user for string in table
 *
 *  Usage:  i = getsearch (prompt,table,defalt)
 *	int i;
 *	char *prompt, **table, *defalt;
 *
 *  Getsrch prints the messge:	prompt  [defalt]
 *  and asks the user to type in a line.  This input text
 *  is compared to all the strings in the table to see which
 *  (if any) it matches; the stabsearch() routine is used
 *  for the matching.  If the string is ambiguous or invalid
 *  (i.e. matches zero strings, or more than one), the cycle
 *  is repeated.  When a valid string is typed, the index
 *  of the string it matches is returned.  If the user just
 *  types carriage return, the default string is used for matching.
 *  The string table may be declared in this way:
 * 	char *table[] = {"string1","string2",...,0};
 *
 *  HISTORY
 * 23-Jan-80  Steven Shafer (sas) at Carnegie-Mellon University
 *	Created.  This is just an alternative to getstab, but with funny
 *	heuristic string-matching and the nifty "May I suggest..." stuff.
 *
 */

#include <string.h>
#include <stdio.h>
#include "c.h"

int getsearch (prompt,table,defalt)
char *prompt, **table, *defalt;
{
	char input[200];
	register int ix;

	do {
		(void)printf ("%s  [%s]  ",prompt, defalt);
		(void)fflush (stdout);
		(void)gets (input);
		if (*input == '\0')  (void)strcpy (input,defalt);
		ix = stabsearch (input,table,FALSE);
	} 
	while (ix < 0);
}
