/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/getoct.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  getoct --  prompt user for octal integer
 *
 *  Usage:  i = getoct (prompt,min,max,defalt)
 *	unsigned int i,min,max,defalt;
 *	char *prompt;
 *
 *  Getoct prints the message:  prompt  (min to max, octal)  [defalt]
 *  and accepts a line of input from the user.  If the input
 *  is not null or numeric, an error message is printed; otherwise,
 *  the value is converted to an octal integer (or the value "defalt" is
 *  substituted if the input is null).  Then, the value is
 *  checked to ensure that is lies within the range "min" to "max".
 *  If it does not, an error message is printed.  As long as
 *  errors occur, the cycle is repeated; when a legal value is
 *  entered, this value is returned by getoct.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Rewritten for VAX.  Now uses all unsigned ints, to avoid
 *	sign problems we had on PDP-11.
 *
 */

#include <stdio.h>
#include <ctype.h>

unsigned int atoo();

unsigned int getoct (prompt,min,max,defalt)
unsigned int min,max,defalt;
char *prompt;
{
	char input [200];
	register char *p;
	register unsigned int i;
	register int err;

	do {

		(void)printf ("%s  (%s%o to %s%o, octal)  [%s%o]  ",
			prompt,(min ? "0" : ""),min,
			(max ? "0" : ""),max,(defalt ? "0" : ""),defalt);
		(void)fflush (stdout);
		(void)gets (input);

		err = 0;
		for (p=input; *p && (*p >= '0' && *p <= '7'); p++) ;

		if (*p) {		/* non-numeric */
			err = 1;
		} 
		else {
			if (*input)	i = atoo (input);
			else		i = defalt;
			err = (i < min || max < i);
		}

		if (err) {
			(void)printf ("Must be an unsigned octal number between %s%o and %s%o\n",
			(min ? "0" : ""),min,(max ? "0" : ""),max);
		}
	} 
	while (err);

	return (i);
}
