/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/getint.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  getint --  prompt user for int
 *
 *  Usage:  i = getint (prompt,min,max,defalt)
 *	int i,min,max,defalt;
 *	char *prompt;
 *
 *  Getint prints the message:  prompt  (min to max)  [defalt]
 *  and accepts a line of input from the user.  If the input
 *  is not null or numeric, an error message is printed; otherwise,
 *  the value is converted to an int (or the value "defalt" is
 *  substituted if the input is null).  Then, the value is
 *  checked to ensure that is lies within the range "min" to "max".
 *  If it does not, an error message is printed.  As long as
 *  errors occur, the cycle is repeated; when a legal value is
 *  entered, this value is returned by getint.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Rewritten for VAX.
 *
 */

#include <stdio.h>
#include <ctype.h>

int getint (prompt,min,max,defalt)
int min,max,defalt;
char *prompt;
{
	char input [200];
	register char *p;
	register int i,err;

	do {

		(void)printf ("%s  (%d to %d)  [%d]  ",prompt,min,max,defalt);
		(void)fflush (stdout);
		(void)gets (input);

		err = 0;
		for (p=input; *p && (isdigit(*p) || *p == '-' || *p == '+'); p++) ;

		if (*p) {		/* non-numeric */
			err = 1;
		} 
		else {
			if (*input)	i = (int)atoi (input);
			else		i = defalt;
			err = (i < min || max < i);
		}

		if (err) (void)printf ("Must be a number between %d and %d\n",
		min,max);
	} 
	while (err);

	return (i);
}
