/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/gethex.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  gethex --  prompt user for hexadecimal integer
 *
 *  Usage:  i = gethex (prompt,min,max,defalt)
 *	unsigned int i,min,max,defalt;
 *	char *prompt;
 *
 *  Gethex prints the message:  prompt  (min to max, hexadecimal)  [defalt]
 *  and accepts a line of input from the user.  If the input
 *  is not null or numeric, an error message is printed; otherwise,
 *  the value is converted to an hexadecimal integer (or the value "defalt" is
 *  substituted if the input is null).  Then, the value is
 *  checked to ensure that is lies within the range "min" to "max".
 *  If it does not, an error message is printed.  As long as
 *  errors occur, the cycle is repeated; when a legal value is
 *  entered, this value is returned by gethex.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Created for VAX.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>

unsigned int atoh();

unsigned int gethex (prompt,min,max,defalt)
unsigned int min,max,defalt;
char *prompt;
{
	char input [200];
	register char *p;
	register unsigned int i;
	register int err;

	do {

		(void)printf ("%s  (%s%x to %s%x, hexadecimal)  [%s%x]  ",
			prompt,(min ? "0x" : ""),min,
			(max ? "0x" : ""),max,(defalt ? "0x" : ""),defalt);
		(void)fflush (stdout);
		(void)gets (input);

		err = 0;
		if (input[0]=='0' && (input[1]=='x' || input[1]=='X'))
			(void)strcpy (input,input+2);
		for (p=input; *p && ((*p>='0' && *p<='9') ||
			(*p>='a' && *p<='f') || (*p>='A' && *p<='F'));
			p++) ;

		if (*p) {		/* non-numeric */
			err = 1;
		} 
		else {
			if (*input)	i = atoh (input);
			else		i = defalt;
			err = (i < min || max < i);
		}

		if (err) {
			(void)printf ("Must be an unsigned hexadecimal number between %s%x and %s%x\n",
			(min ? "0x" : ""),min,(max ? "0x" : ""),max);
		}
	} 
	while (err);

	return (i);
}
