/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/getfloat.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  getfloat --  prompt user for float
 *
 *  Usage:  f = getfloat (prompt,min,max,defalt)
 *	float f,min,max,defalt;
 *	char *prompt;
 *
 *  Getfloat prints the message:  prompt  (min to max)  [defalt]
 *  and accepts a line of input from the user.  If the input
 *  is not null or numeric, an error message is printed; otherwise,
 *  the value is converted to a float (or the value "defalt" is
 *  substituted if the input is null).  Then, the value is
 *  checked to ensure that is lies within the range "min" to "max".
 *  If it does not, an error message is printed.  As long as
 *  errors occur, the cycle is repeated; when a legal value is
 *  entered, this value is returned by getfloat.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Created for VAX.
 *
 */
/*LINTLIBRARY*/
#include <stdio.h>
#include <ctype.h>
#include <math.h>

float getfloat (prompt,min,max,defalt)
float min,max,defalt;
char *prompt;
{
	char input [200];
	register char *p;
	register int err;
	float i;
	do {

		(void)printf ("%s  (%g to %g)  [%g]  ",prompt,min,max,defalt);
		(void)fflush (stdout);
		(void)gets (input);

		err = 0;
		for (p=input; *p &&
		 (isdigit(*p) || *p=='-' || *p=='.' || *p=='+'
		  || *p=='e' || *p=='E');
		 p++);

		if (*p) {		/* non-numeric */
			err = 1;
		} 
		else {
			if (*input)	i = atof (input);
			else		i = defalt;
			err = (i < min || max < i);
		}

		if (err) (void)printf ("Must be a number between %g and %g\n",
		min,max);
	} 
	while (err);

	return (i);
}
