/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/getchr.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  getchr  --  ask user to select a character
 *
 *  Usage:  i = getchr (prompt,legals,defalt)
 *	int i;
 *	char *prompt, *legals, defalt;
 *
 *  Prints the message:		prompt  (legals)  [defalt]
 *  and allows the user to type a line.  The first character
 *  the user types is searched for in the string "legals"; if it
 *  is there, its index is returned; otherwise, the user must
 *  try again.  If the user just types carriage return, the
 *  "defalt" character will be searched for.  In any case, note
 *  that is the INDEX (i.e. 0, 1, 2, ...) of the
 *  character that is returned.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Rewritten for VAX.
 *
 */

#include <stdio.h>
#include <string.h>

char *IDLstrchr();

int getchr (prompt, legals, defalt)
char *prompt, *legals, defalt;
{
	register int i;
	register char *p;
	char input [200];

	do {
		(void)printf ("%s  (%s)  [%c]  ",prompt,legals,defalt);
		(void)fflush (stdout);
		(void)gets (input);
		if (*input == '\0')  *input = defalt;
		p = IDLstrchr (legals, *input);
		if (p == 0)
			(void)printf ("Must be one of: %s\n",legals);
		else
			i = (p - legals);
	} 
	while (p == 0);

	return (i);
}
