/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/execvp.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* @(#)execvp.c	4.1 (Berkeley) 12/21/80 */
/*
 *	execlp(name, arg,...,0)	(like execl, but does path search)
 *	execvp(name, argv)	(like execv, but does path search)
 *
 * HISTORY
 * 15-Aug-81  Mike Accetta (mja) at Carnegie-Mellon University
 *	Inserted changes below into 4.1BSD;  moved definition
 *	of CMU to makefile.
 *
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Modified to define CMU, and to use these CMU mods:
 *	1.  shell command files are executed after a search for the
 *	    shell, rather than by executing "/bin/sh".
 *	2.  the default PATH string includes /usr/cmu/bin.
 *
 */

#include <errno.h>
#include <stdio.h>
#include <string.h>

#ifdef CMU
static  char shell[] = "sh";
static  char defpath[] = ":/usr/cmu/bin:/bin:/usr/bin";
#else
static	char shell[] =	"/bin/sh";
#endif

char	*execat(), *getenv();
char *IDLstrchr();
extern	errno;

execlp(name, argv)
char *name, *argv;
{
	return(execvp(name, &argv));
}

execvp(name, argv)
char *name, **argv;
{
	char *pathstr;
	register char *cp;
	char fname[128];
	char *newargs[256];
	int i;
	register unsigned etxtbsy = 1;
	register eacces = 0;

	if ((pathstr = getenv("PATH")) == NULL)
#ifdef CMU
		pathstr = defpath;
#else
		pathstr = ":/bin:/usr/bin";
#endif
	cp = IDLstrchr(name, '/')? "": pathstr;

	do {
		cp = execat(cp, name, fname);
	retry:
		(void)execv(fname, argv);
		switch(errno) {
		case ENOEXEC:
			newargs[0] = "sh";
			newargs[1] = fname;
			for (i=1; newargs[i+1]=argv[i]; i++) {
				if (i>=254) {
					errno = E2BIG;
					return(-1);
				}
			}
#ifdef CMU
			execvp (shell,newargs);
#else
			(void)execv(shell, newargs);
#endif
			return(-1);
		case ETXTBSY:
			if (++etxtbsy > 5)
				return(-1);
			sleep(etxtbsy);
			goto retry;
		case EACCES:
			eacces++;
			break;
		case ENOMEM:
		case E2BIG:
			return(-1);
		}
	} while (cp);
	if (eacces)
		errno = EACCES;
	return(-1);
}

static char *
execat(s1, s2, si)
register char *s1, *s2;
char *si;
{
	register char *s;

	s = si;
	while (*s1 && *s1 != ':' && *s1 != '-')
		*s++ = *s1++;
	if (si != s)
		*s++ = '/';
	while (*s2)
		*s++ = *s2++;
	*s = '\0';
	return(*s1? ++s1: 0);
}
