/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/editor.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  editor  --  fork editor to edit some text file
 *
 *  Usage:  i = editor (file,prompt);
 *	char *file,*prompt;
 *	int i;
 *
 *  Editor is used to fork the user's favorite editor.
 *  This routine contains all of the special knowledge needed to
 *  execute the editors known to the system; there is a provision
 *  whereby, within certain restrictions, the user's favorite
 *  other editor may be used.
 *  There is assumed to be an environment parameter named "EDITOR"
 *  whose value ("xed", "fred", "ed", etc.) is the name of the
 *  favored editor.  If the EDITOR parameter is missing, some
 *  default (see DEFAULTED below) is assumed.
 *  The runp() routine is then used to find this editor on the
 *  searchlist specified by the PATH variable (or the default path).
 *  "file" is the name of the file to be edited; "prompt" is a
 *  string (of any length) which will be printed in a such a way that
 *  the user can see it at least at the start of the editing session.
 *  Editor() returns the value of the "runp()" call: if the editor
 *  is not executable, terminates by a signal, or is interrupted, then
 *  -1 is returned; if it terminates normally, then its termination
 *  code is returned.
 *
 *  HISTORY
 * 07-Nov-80  Mike Accetta (mja) at Carnegie-Mellon University
 *	Removed support for XED (now extinct).
 *
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Created for VAX.  Numerous modifications have already been made
 *	to this routine from its initial version.  Among possible
 *	future changes anticipated:  adding new editors (such as
 *	Berkeley's "ex" and "vi"; changing "open" in FRED case to use
 *	mode 2 (read/write).
 *
 */

#include <stdio.h>
#include <string.h>
int runp();
int stablk();
char *getenv();
char *IDLstrrchr();

typedef enum {
	MISSING = -2, RANDOM, ED, FRED}
EDITOR;
#define DEFAULTED "/usr/ucb/ex"

static char *edname[] = {
	"ed","fred",0};

int editor (file,prompt)
char *file,*prompt;
{
	register EDITOR ed;
	register int i;
	register char *p;
	int filedesc;
	char *q;

	p = getenv("EDITOR");
	if (p) {
		q = IDLstrrchr (p,'/');
		if (q == 0)  q = p; else q++;
		for (i=0; edname[i] && (strcmp(edname[i],q) != 0); i++) ;
		if (edname[i])	ed = (EDITOR) i;
		else		ed = RANDOM;
	}
	else {
		ed = MISSING;
		p = DEFAULTED;
	}

	switch (ed) {

	case FRED:
		filedesc = open (file,0);
		if (filedesc >= 0) {
			(void)close (filedesc);
			if (*prompt) {
				i = runp (p,p,"-g",prompt,file,0);
			}
			else {
				i = runp (p,p,file,0);
			}
		}
		else {
			if (*prompt) {
				i = runp (p,p,"-f","-g",prompt,file,0);
			}
			else {
				i = runp (p,p,"-f",file,0);
			}
		}
		break;

	case ED:
	case RANDOM:
	case MISSING:
	default:
		if (*prompt)  (void)printf ("%s\n",prompt);
		i = runp (p,p,file,0);
	}

	return (i);
}
