/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/chrarg.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*  chrarg  --  parse character and return its index
 *
 *  Usage:  i = chrarg (ptr,brk,prompt,legals,defalt);
 *	int i;
 *	char **ptr,*brk,*prompt,*legals,defalt;
 *
 *  Chrarg will parse an argument from the string pointed to by "ptr",
 *  bumping ptr to point to the next argument.  The first character
 *  of the arg will be searched for in "legals", and its index
 *  returned; if it is not found, or if there is no argument, then
 *  getchr() will be used to ask the user for a character.
 *  "Brk" is the list of characters which may terminate an argument;
 *  if it is 0, then " " is used.
 *
 *  HISTORY
 * 20-Nov-79  Steven Shafer (sas) at Carnegie-Mellon University
 *	Rewritten for VAX.
 *
 */

#include <stdio.h>
#include <string.h>
int strcmp(), getchr();
char *nxtarg();
char *IDLstrchr();

int chrarg (ptr,brk,prompt,legals,defalt)
char **ptr, *brk, *prompt, *legals, defalt;
{
	register int i;
	register char *arg,*p;

	i = -1;			/* bogus value */

	arg = nxtarg (ptr,brk);	/* parse argument */

	if (*arg) {		/* there was an arg */
		p = IDLstrchr (legals,*arg);
		if (p) {
			i = p - legals;
		} 
		else if (strcmp("?",arg) != 0) {
			(void)printf ("%s: not valid.  ",arg);
		}
	}

	if (i < 0) {
		i = getchr (prompt,legals,defalt);
	}

	return (i);
}
