/***********************************************************************\ 
*									* 
*   File: scorpion/src/IDLlib/libci/atot.c 
*				 					* 
*   Copyright (C) 1991 Steven Shafer
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/*
 *  atot - convert ascii string to time
 *
 **********************************************************************
 * HISTORY
 * 03-Mar-84  Mike Shaddock (unc!shaddock) fixed to work under 4.2bsd.
 *
 * 03-Jan-80  Mike Accetta (mja) at Carnegie-Mellon University
 *	Created.
 *
 **********************************************************************
 *
 *  Usage:  t = atot (date);
 *	time_t t;
 *	char *date;
 *
 *     Converts a date string to its corresponding UNIX date/time
 *  format using pdate().  The month, day and year default to
 *  today, hours, minutes and seconds default to 0.
 *
 *     Returns converted time or -1 on error (bad date string).
 */

#include <sys/types.h>

#ifndef BSD42
#include <time.h>
#endif
#ifdef BSD42
#include <sys/time.h>
#endif

#include "c.h"
#include "libcmu.h"

extern time_t gtime();
extern long time();

time_t atot(str)
char *str;
{

    time_t now;
    register struct tm *tms;

#ifndef BSD42
    (void)time(&now);
#endif
#ifdef BSD42
    struct timeval tp;
    struct timezone tzp;

    gettimeofday(&tp, &tzp);
    now = tp.tv_sec;
#endif

    tms = localtime(&now);
    tms->tm_sec = tms->tm_min = tms->tm_hour = 0;
    if (pdate(str, tms) < 0)
	return(CERROR);
    return(gtime(tms));

}
