IDLnode IDLInode(/* IDLnode anode */	);

#define IDLNnode node_allocate()

IDLnode
node_allocate ()
{
 IDLnode anode;

 anode = (IDLnode) malloc ((unsigned)sizeof (struct IDLRnode));
 if (anode == NULL)
   {
    (void)fprintf (stderr,"Memory error when allocating node\n");
    exit(1);
   }
 return (IDLInode(anode));
} 

/* hash_defs.h */
/* definitions for functions */

static IDLnode IDLfind_tree(/* IDLnode treenode, String key */	);
static void IDLwalk_tree_in(/* IDLnode treenode, void (*action) () */	);
static void IDLwalk_tree_post(/* IDLnode treenode, void (*action) () */	);
static void IDLwalk_tree_pre(/* IDLnode treenode, void (*action) () */	);
static IDLnode IDLinsert_tree(/* IDLnode treenode, String key, IDLtree_entry newentry */	);


/* the hash table definition */
typedef struct IDLHASHTABLE {
	int htabsiz;
 	IDLnode *htab; 
} *IDLHASHTABLE;

static IDLHASHTABLE IDLNewHashTable(/* int size */);
static int IDLKeyHash(/* char *S */);
static IDLnode IDLInsertHashTable(/* HASHTABLE HashTable, String key, tree_entry newentry */);
static void IDLInitHashTable(/* HASHTABLE HashTable */);
static void IDLPrintHashTable(/*  HASHTABLE HashTable, void (*out_tree() */);

/* hash.c */
/* Generic Hash Table functions: each index of hash table is a tree */
/*	user must define type 'entry' for application               */

static int IDLKeyHash();			/* default hash function */
static int  (*IDLHashFunc) () = IDLKeyHash; 	/* hash function pointer */


/* create and return a new hash table */
static IDLHASHTABLE IDLNewHashTable(size)
int size;
{
	IDLHASHTABLE ret_ht;

	ret_ht = (IDLHASHTABLE)GetHeap(sizeof(struct IDLHASHTABLE));
	ret_ht->htab = (IDLnode *)GetHeap(size * sizeof(IDLnode));

	ret_ht->htabsiz = size;
	IDLInitHashTable(ret_ht);
	return(ret_ht);
}

static IDLSetHashFunction(new_hfn)
int  (*new_hfn) ();
{
	IDLHashFunc = new_hfn; 	
}

/* hash a string for the hash table --default hash function */
static int IDLKeyHash(S, htabsiz)
register char *S;
int htabsiz;
{	register int i;
	for (i=0 ; *S ; i += (*S) , S++);
	return(i % (htabsiz-1));
}

/* add an entry to the HashTable and return the tree node*/
static IDLnode IDLInsertHashTable(HashTable, key, newentry, keycmp_fn)
IDLHASHTABLE HashTable;
String key;
IDLtree_entry newentry;
int  (*keycmp_fn) ();
{
	int index;

	index = IDLHashFunc(key, HashTable->htabsiz) % HashTable->htabsiz;

	/* first node for index so create the root node */
	if (HashTable->htab[index] == NULL) {
		HashTable->htab[index] = IDLNnode;
		HashTable->htab[index]->key = key;
	}

	return(IDLinsert_tree(HashTable->htab[index], key, newentry, keycmp_fn));
}

/* find an entry in the HashTable and return the tree node*/
static IDLnode IDLFindHashTable(HashTable, key, keycmp_fn)
IDLHASHTABLE HashTable;
String key;
int  (*keycmp_fn) ();
{
	int index;

	index = IDLHashFunc(key, HashTable->htabsiz) % HashTable->htabsiz;

	/* first node for index so not found */
	if (HashTable->htab[index] == NULL) {
		return(NULL);
	}

	return(IDLfind_tree(HashTable->htab[index], key, keycmp_fn));
}

static void IDLInitHashTable(HashTable)
IDLHASHTABLE HashTable;
{
	int i;

	for (i=0; i<HashTable->htabsiz; i++) {
	    	HashTable->htab[i] = NULL;
	}
}

/* insert_tree.c */

static IDLnode IDLinsert_tree(treenode, key, newentry, keycmp_fn)
IDLnode treenode;
String key;
IDLtree_entry newentry;
int  (*keycmp_fn) ();
{
	int cmp;
	cmp = keycmp_fn(key, treenode->key);

	if (cmp == 0) {
		appendrearIDLSEQtree_entry(treenode->entries, newentry);
		return(treenode);
	}
	else if (cmp < 0) {
		if (treenode->left == NULL) { /* add here */
			treenode->left = IDLNnode;
			treenode->left->key = key;
			appendrearIDLSEQtree_entry(treenode->left->entries,
					  newentry);
			return(treenode->left);
		}
		else return(IDLinsert_tree(treenode->left, key, newentry, 
					keycmp_fn));
	}
	else {
		if (treenode->right == NULL) { /* add here */
			treenode->right = IDLNnode;
			treenode->right->key = key;
			appendrearIDLSEQtree_entry(treenode->right->entries,
					  newentry);
			return(treenode->right);
		}
		else return(IDLinsert_tree(treenode->right, key, newentry, 
					keycmp_fn));
	}
}


/* find_tree.c */

static IDLnode IDLfind_tree(treenode, key, keycmp_fn)
IDLnode treenode;
String key;
int  (*keycmp_fn) ();
{
	int cmp;
	cmp = keycmp_fn(key, treenode->key);

	if (cmp == 0) {
		return(treenode);
	}
	else if (cmp < 0) {
		if (treenode->left == NULL) { /* not found */
			return(NULL);
		}
		else return(IDLfind_tree(treenode->left, key, keycmp_fn));
	}
	else {
		if (treenode->right == NULL) { /* not found */
			return(NULL);
		}
		else return(IDLfind_tree(treenode->right, key, keycmp_fn));
	}
}


/* init_tree.c */

IDLnode IDLInode(anode)
IDLnode anode;
{
	anode->left = NULL;
	anode->right = NULL;
	anode->entries = NULL;
	return(anode);
}

/* walk_tree.c */

/* walks in inorder */

static void IDLwalk_tree_in(treenode, action)
IDLnode treenode;
register void (*action) ();	/* Function to be called at each node */
{
	if (treenode->left != NULL)
		IDLwalk_tree_in(treenode->left, action);

	/* call action for this one */
	action(treenode);
	
	if (treenode->right != NULL)
		IDLwalk_tree_in(treenode->right, action);
}

/* walks in postorder */

static void IDLwalk_tree_post(treenode, action)
IDLnode treenode;
register void (*action) ();	/* Function to be called at each * node */
{
	if (treenode->left != NULL)
		IDLwalk_tree_post(treenode->left, action);

	if (treenode->right != NULL)
		IDLwalk_tree_post(treenode->right, action);

	/* call action for this one */
	action(treenode);
	
}

/* walks in preorder */

static void IDLwalk_tree_pre(treenode, action)
IDLnode treenode;
register void (*action) ();	/* Function to be called at each * node */
{
	/* call action for this one */
	action(treenode);
	
	if (treenode->left != NULL)
		IDLwalk_tree_pre(treenode->left, action);

	if (treenode->right != NULL)
		IDLwalk_tree_pre(treenode->right, action);
}


/* tree_utils.c */
#define IDLHTABSIZ 	203
static IDLHASHTABLE	IDLlabelhashtable;
static int		IDLLabelHashFunc();

static IDLinit_hashtable()
{

	IDLlabelhashtable = IDLNewHashTable(IDLHTABSIZ);
	IDLSetHashFunction(IDLLabelHashFunc);
}

static	int		IDLcmplabel();
static IDLinsert_hashtable(thenode)
nodeDesc thenode;
{

	(void)IDLInsertHashTable(IDLlabelhashtable, 
			      thenode->label,
			      thenode,
			      IDLcmplabel);
}

static nodeDesc IDLfind_label(label)
String label;
{
	IDLnode IDLFindHashTable();  /* HashTable, key, keycmp_fn */
	IDLnode found;
	nodeDesc ret_node;

	if (found = IDLFindHashTable(IDLlabelhashtable, label, IDLcmplabel)) {
		retrievefirstIDLSEQtree_entry(found->entries, ret_node);
		return(ret_node);
	}
	else return(NULL);
}

/* labels are of the form L{d}+ */
static int IDLLabelHashFunc(label)
String label;
{
	return(atoi(&label[1]));
}

static int IDLcmplabel(l1, l2)
String l1, l2;
{
	return(atoi(&l1[1]) - atoi(&l2[1]));
}
