%{
#include <math.h>
#include <ctype.h>
extern YYSTYPE yylval;
static char *IDLString_convert();
#ifdef DEBUG
static char *IDLget_token_name();
#define IDLDreturn(tok)	{(void)fprintf(stderr, "token = %s\n", IDLget_token_name(tok)); return(tok); }
#else
#define IDLDreturn(tok)	return(tok)
#endif
%}

sign	([+-]?)
unint	([0-9]+)
unrat	({brat}|({intrat}"/"{intrat}))
intrat	({unint}|{brat})
brat	({brat1}|{brat2}|{brat3})
brat1	({unint}\.{unint}{exp}?)
brat2	({unint}(\.{unint})?{exp})
brat3	({unint}\#{based}(\.{based})?\#{exp}?)
exp	(E{sign}{unint})
based	([0-9A-F]+)
sschar	[A-Za-z0-9!#$%&'()*+,\-./:;<=>?@[\\\]^_`{|} ]

%%
"<"		{ IDLCharPos++; IDLDreturn (IDLLESS);}
">"		{ IDLCharPos++; IDLDreturn (IDLGREATER);}
"{"		{ IDLCharPos++; IDLDreturn (IDLLBRACE);}
"}"		{ IDLCharPos++; IDLDreturn (IDLRBRACE);}
"["		{ IDLCharPos++; IDLDreturn (IDLLBRACKET);}
"]"		{ IDLCharPos++; IDLDreturn (IDLRBRACKET);}
";"		{ IDLCharPos++; IDLDreturn (IDLSEMICOLON);}
"#"		{ IDLCharPos++;
		  IDLDreturn (IDLEND); 
                }
{sign}{unint}	{ IDLCharPos += yyleng;
                  yylval.intval = NintegerDesc;
		  yylval.intval->stringRep = NewString(yytext);
		  yylval.intval->value = atoi(yytext);
		  IDLDreturn (IDLINTEGER); 
		}
{sign}{unrat}	{ IDLCharPos += yyleng;
                  yylval.ratval = NrationalDesc;
		  yylval.ratval->stringRep = NewString(yytext);
		  yylval.ratval->value = (float) atof(yytext);
		  IDLDreturn (IDLRATIONAL); 
		}
[a-zA-Z][a-zA-Z0-9_]*":" { IDLCharPos += yyleng;
		  yytext[yyleng-1] = '\0';	/* strip off ':'  */
		  yylval.name = NewString(yytext);
  		  IDLDreturn(IDLLABEL);
		}
[a-zA-Z][a-zA-Z0-9_]*"^" { IDLCharPos += yyleng;
                  yytext[yyleng-1] = '\0';	/* strip off '^' */
		  yylval.name = NewString(yytext);
  		  IDLDreturn(IDLLABELREF);
		}
[Tt][Rr][Uu][Ee] {IDLCharPos += yyleng;
		  yylval.boolval = NbooleanDesc;
		  yylval.boolval->value = TRUE;
		  IDLDreturn(IDLBOOLEAN);
		}
[Ff][Aa][Ll][Ss][Ee] {IDLCharPos += yyleng;
		  yylval.boolval = NbooleanDesc;
		  yylval.boolval->value = FALSE;
		  IDLDreturn(IDLBOOLEAN);
		}
[a-zA-Z][a-zA-Z0-9_]* {IDLCharPos += yyleng;
		  yylval.name = NewString(yytext);
		  IDLDreturn(IDLNAME);
		}
\"((\"\")|(\~{sschar})|(\~\~)|({sschar}))*\"	{
		/* was \"([^"~]*(\"\")*(~[~{@-_])*)*\"/[^"]	*/
                  IDLCharPos += yyleng;
		  yylval.strval = NstringDesc;
		  yylval.strval->value = 
			NewString(IDLString_convert(yytext, yyleng));
		  IDLDreturn (IDLSTRING); 
		}
"-- structure".*\n { /* comment or if on first line - name of structure */
		 int i,j;
		 if (IDLlineNumber == 1 && IDLCharPos == 0)
		    {
			for (i=12;yytext[i] && isspace(yytext[i]);i++)
				;
			for (j=0;yytext[i] && yytext[i] != '\n';j++,i++)
			   IDLStructureName[j] = yytext[i];
			IDLStructureName[j] = '\0';
		    }
                 IDLlineNumber++; 
		 IDLCharPos = 0;
		}
"-- ".*\n 	{ /* comment */
                 IDLlineNumber++; 
		 IDLCharPos = 0;
		}
[ \t]*	{ IDLCharPos += yyleng; /* white space */ ; }
\n		{ IDLlineNumber++ /* more white space */; IDLCharPos = 0;}    
.		{ IDLCharPos += yyleng; (void)fprintf(stderr, "Unknown token:  '%s'\n", yytext); }
%%

static char * IDLString_convert(st,len)
char *st;
int  len;
{
    char *result;
    char *save;
    int  i;

    result = (char *)GetHeap(len+1);
    save = result;
    st++;
    for(i=1;i<len-1;i++)
    {
	if(*st == '~')
	{
	    st++;
	    i++;
	    if(*st >= '@' && *st <= '_')
	    {
		*result = *st - '@';
		result++;
	    }
	    else if(*st == '~')
		 {
		     *result = '~';
		     result++;
		 }
		 else if(*st == '{')
		      {
			  *result = '\177';	/* DEL  */
			  result++;
		      }
	}
	else if(*st == '"')
	     {
		 st++;
		 i++;
		 *result = '"';
		 result++;
	     }
	     else { *result = *st; result++; }
    st++;
    }
	*result = '\0';
	result = save;
	return(result);
}
static char *IDLget_token_name(tok)
int tok;
{
	static char buf[50];
	switch (tok) {
		case IDLLPAREN:	return("IDLLPAREN");
		case IDLRPAREN:	return("IDLRPAREN");
		case IDLLBRACKET:	return("IDLLBRACKET");
		case IDLRBRACKET:	return("IDLRBRACKET");
		case IDLLBRACE:	return("IDLLBRACE");
		case IDLRBRACE:	return("IDLRBRACE");
		case IDLLESS:	return("IDLLESS");
		case IDLGREATER:	return("IDLGREATER");
		case IDLSEMICOLON:	return("IDLSEMICOLON");
		case IDLEND:	return("IDLEND");
		case IDLSTRING:	return("IDLSTRING");
		case IDLRATIONAL:	return("IDLRATIONAL");
		case IDLINTEGER:	return("IDLINTEGER");
		case IDLBOOLEAN:	return("IDLBOOLEAN");
		case IDLNAME:	return("IDLNAME");
		case IDLLABELREF:	return("IDLLABELREF");
		case IDLLABEL:	return("IDLLABEL");
		default:	(void)sprintf(buf, "<%d>", tok);
				return(buf);
	}
}

yywrap() 
{ 
    return(1);
}
