# include "stdio.h"
# define IDLU(x) x
# define IDLNLSTATE yyprevious=YYNEWLINE
# define IDLBEGIN yybgin = yysvec + 1 +
# define IDLINITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define IDLoutput(c) putc(c,yyout)
# define IDLunput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define IDLECHO fprintf(yyout, "%s",yytext)
# define IDLREJECT { IDLnstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
#include <math.h>
#include <ctype.h>
extern YYSTYPE yylval;
static char *IDLString_convert();
#ifdef DEBUG
static char *IDLget_token_name();
#define IDLDreturn(tok)	{(void)fprintf(stderr, "token = %s\n", IDLget_token_name(tok)); return(tok); }
#else
#define IDLDreturn(tok)	return(tok)
#endif
# define YYNEWLINE 10
yylex(){
int IDLnstr; extern int yyprevious;
while((IDLnstr = yylook()) >= 0)
yyfussy: switch(IDLnstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	{ IDLCharPos++; IDLDreturn (IDLLESS);}
break;
case 2:
	{ IDLCharPos++; IDLDreturn (IDLGREATER);}
break;
case 3:
	{ IDLCharPos++; IDLDreturn (IDLLBRACE);}
break;
case 4:
	{ IDLCharPos++; IDLDreturn (IDLRBRACE);}
break;
case 5:
	{ IDLCharPos++; IDLDreturn (IDLLBRACKET);}
break;
case 6:
	{ IDLCharPos++; IDLDreturn (IDLRBRACKET);}
break;
case 7:
	{ IDLCharPos++; IDLDreturn (IDLSEMICOLON);}
break;
case 8:
	{ IDLCharPos++;
		  IDLDreturn (IDLEND); 
                }
break;
case 9:
{ IDLCharPos += yyleng;
                  yylval.intval = NintegerDesc;
		  yylval.intval->stringRep = NewString(yytext);
		  yylval.intval->value = atoi(yytext);
		  IDLDreturn (IDLINTEGER); 
		}
break;
case 10:
{ IDLCharPos += yyleng;
                  yylval.ratval = NrationalDesc;
		  yylval.ratval->stringRep = NewString(yytext);
		  yylval.ratval->value = (float) atof(yytext);
		  IDLDreturn (IDLRATIONAL); 
		}
break;
case 11:
{ IDLCharPos += yyleng;
		  yytext[yyleng-1] = '\0';	/* strip off ':'  */
		  yylval.name = NewString(yytext);
  		  IDLDreturn(IDLLABEL);
		}
break;
case 12:
{ IDLCharPos += yyleng;
                  yytext[yyleng-1] = '\0';	/* strip off '^' */
		  yylval.name = NewString(yytext);
  		  IDLDreturn(IDLLABELREF);
		}
break;
case 13:
{IDLCharPos += yyleng;
		  yylval.boolval = NbooleanDesc;
		  yylval.boolval->value = TRUE;
		  IDLDreturn(IDLBOOLEAN);
		}
break;
case 14:
{IDLCharPos += yyleng;
		  yylval.boolval = NbooleanDesc;
		  yylval.boolval->value = FALSE;
		  IDLDreturn(IDLBOOLEAN);
		}
break;
case 15:
{IDLCharPos += yyleng;
		  yylval.name = NewString(yytext);
		  IDLDreturn(IDLNAME);
		}
break;
case 16:
{
		/* was \"([^"~]*(\"\")*(~[~{@-_])*)*\"/[^"]	*/
                  IDLCharPos += yyleng;
		  yylval.strval = NstringDesc;
		  yylval.strval->value = 
			NewString(IDLString_convert(yytext, yyleng));
		  IDLDreturn (IDLSTRING); 
		}
break;
case 17:
{ /* comment or if on first line - name of structure */
		 int i,j;
		 if (IDLlineNumber == 1 && IDLCharPos == 0)
		    {
			for (i=12;yytext[i] && isspace(yytext[i]);i++)
				;
			for (j=0;yytext[i] && yytext[i] != '\n';j++,i++)
			   IDLStructureName[j] = yytext[i];
			IDLStructureName[j] = '\0';
		    }
                 IDLlineNumber++; 
		 IDLCharPos = 0;
		}
break;
case 18:
	{ /* comment */
                 IDLlineNumber++; 
		 IDLCharPos = 0;
		}
break;
case 19:
{ IDLCharPos += yyleng; /* white space */ ; }
break;
case 20:
	{ IDLlineNumber++ /* more white space */; IDLCharPos = 0;}
break;
case 21:
	{ IDLCharPos += yyleng; (void)fprintf(stderr, "Unknown token:  '%s'\n", yytext); }
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",IDLnstr);
} return(0); }
/* end of yylex */

static char * IDLString_convert(st,len)
char *st;
int  len;
{
    char *result;
    char *save;
    int  i;

    result = (char *)GetHeap(len+1);
    save = result;
    st++;
    for(i=1;i<len-1;i++)
    {
	if(*st == '~')
	{
	    st++;
	    i++;
	    if(*st >= '@' && *st <= '_')
	    {
		*result = *st - '@';
		result++;
	    }
	    else if(*st == '~')
		 {
		     *result = '~';
		     result++;
		 }
		 else if(*st == '{')
		      {
			  *result = '\177';	/* DEL  */
			  result++;
		      }
	}
	else if(*st == '"')
	     {
		 st++;
		 i++;
		 *result = '"';
		 result++;
	     }
	     else { *result = *st; result++; }
    st++;
    }
	*result = '\0';
	result = save;
	return(result);
}
static char *IDLget_token_name(tok)
int tok;
{
	static char buf[50];
	switch (tok) {
		case IDLLPAREN:	return("IDLLPAREN");
		case IDLRPAREN:	return("IDLRPAREN");
		case IDLLBRACKET:	return("IDLLBRACKET");
		case IDLRBRACKET:	return("IDLRBRACKET");
		case IDLLBRACE:	return("IDLLBRACE");
		case IDLRBRACE:	return("IDLRBRACE");
		case IDLLESS:	return("IDLLESS");
		case IDLGREATER:	return("IDLGREATER");
		case IDLSEMICOLON:	return("IDLSEMICOLON");
		case IDLEND:	return("IDLEND");
		case IDLSTRING:	return("IDLSTRING");
		case IDLRATIONAL:	return("IDLRATIONAL");
		case IDLINTEGER:	return("IDLINTEGER");
		case IDLBOOLEAN:	return("IDLBOOLEAN");
		case IDLNAME:	return("IDLNAME");
		case IDLLABELREF:	return("IDLLABELREF");
		case IDLLABEL:	return("IDLLABEL");
		default:	(void)sprintf(buf, "<%d>", tok);
				return(buf);
	}
}

yywrap() 
{ 
    return(1);
}
int yyvstop[] = {
0,

19,
0,

19,
0,

21,
0,

19,
21,
0,

20,
0,

21,
0,

8,
21,
0,

21,
0,

21,
0,

9,
21,
0,

7,
21,
0,

1,
21,
0,

2,
21,
0,

15,
21,
0,

15,
21,
0,

15,
21,
0,

5,
21,
0,

6,
21,
0,

3,
21,
0,

4,
21,
0,

19,
0,

16,
0,

9,
0,

15,
0,

11,
0,

12,
0,

15,
0,

15,
0,

10,
0,

10,
0,

10,
0,

15,
0,

15,
0,

18,
0,

10,
0,

15,
0,

13,
15,
0,

10,
0,

10,
0,

10,
0,

14,
15,
0,

10,
0,

10,
0,

10,
0,

10,
0,

17,
18,
0,
0};
# define YYTYPE char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
0,0,	0,0,	4,21,	0,0,	
0,0,	4,21,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,4,	1,3,	1,6,	
1,7,	4,21,	23,22,	10,27,	
26,36,	0,0,	0,0,	0,0,	
1,8,	0,0,	1,9,	9,26,	
37,47,	1,10,	10,28,	10,29,	
0,0,	2,6,	2,7,	0,0,	
0,0,	0,0,	0,0,	37,48,	
1,11,	1,12,	41,29,	1,13,	
2,9,	38,29,	1,14,	1,14,	
15,34,	0,0,	1,14,	1,15,	
1,14,	10,30,	0,0,	0,0,	
0,0,	1,14,	2,11,	2,12,	
0,0,	2,13,	0,0,	1,14,	
1,14,	1,16,	1,14,	38,49,	
0,0,	0,0,	57,47,	16,35,	
1,17,	25,27,	1,18,	73,68,	
1,3,	0,0,	1,14,	0,0,	
15,34,	0,0,	1,14,	1,15,	
25,28,	25,29,	34,42,	35,43,	
42,53,	43,54,	2,17,	59,29,	
2,18,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	16,35,	
1,19,	61,70,	1,20,	25,30,	
28,38,	28,38,	28,38,	28,38,	
28,38,	28,38,	28,38,	28,38,	
28,38,	28,38,	34,42,	35,43,	
42,53,	43,54,	2,19,	46,55,	
2,20,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,22,	6,22,	6,23,	53,64,	
55,65,	47,29,	65,71,	67,29,	
68,72,	71,76,	76,79,	6,22,	
79,80,	80,81,	81,82,	0,0,	
6,22,	29,39,	29,39,	29,39,	
29,39,	29,39,	29,39,	29,39,	
29,39,	29,39,	29,39,	47,56,	
0,0,	60,68,	39,50,	0,0,	
0,0,	6,22,	6,22,	53,64,	
0,0,	6,22,	6,22,	6,22,	
60,69,	39,51,	0,0,	0,0,	
6,22,	0,0,	0,0,	0,0,	
0,0,	0,0,	6,22,	6,22,	
6,22,	6,22,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	6,22,	
39,52,	6,22,	0,0,	0,0,	
0,0,	6,22,	6,22,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,32,	0,0,	0,0,	
0,0,	0,0,	6,24,	6,0,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	0,0,	0,0,	
0,0,	14,33,	14,31,	0,0,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	0,0,	0,0,	22,23,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	0,0,	
0,0,	24,0,	27,37,	27,37,	
27,37,	27,37,	27,37,	27,37,	
27,37,	27,37,	27,37,	27,37,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	27,37,	
27,37,	27,37,	27,37,	27,37,	
27,37,	30,40,	0,0,	30,40,	
0,0,	0,0,	30,41,	30,41,	
30,41,	30,41,	30,41,	30,41,	
30,41,	30,41,	30,41,	30,41,	
36,44,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
36,44,	36,45,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	22,24,	
22,0,	40,41,	40,41,	40,41,	
40,41,	40,41,	40,41,	40,41,	
40,41,	40,41,	40,41,	36,44,	
36,44,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	36,44,	0,0,	
0,0,	0,0,	0,0,	36,44,	
44,44,	0,0,	0,0,	0,0,	
0,0,	24,22,	24,0,	0,0,	
44,44,	44,45,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
36,44,	36,44,	0,0,	0,0,	
36,44,	36,44,	36,44,	0,0,	
0,0,	0,0,	0,0,	36,44,	
0,0,	0,0,	0,0,	44,44,	
44,44,	36,44,	36,44,	36,44,	
36,44,	0,0,	0,0,	0,0,	
0,0,	0,0,	44,44,	0,0,	
0,0,	0,0,	36,44,	44,44,	
36,44,	49,58,	0,0,	49,58,	
36,44,	36,44,	49,59,	49,59,	
49,59,	49,59,	49,59,	49,59,	
49,59,	49,59,	49,59,	49,59,	
44,44,	44,44,	36,46,	0,0,	
44,44,	44,44,	44,44,	0,0,	
0,0,	0,0,	0,0,	44,44,	
0,0,	0,0,	0,0,	0,0,	
0,0,	44,44,	44,44,	44,44,	
44,44,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	44,44,	0,0,	
44,44,	0,0,	0,0,	0,0,	
44,44,	44,44,	48,57,	48,57,	
48,57,	48,57,	48,57,	48,57,	
48,57,	48,57,	48,57,	48,57,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	48,57,	
48,57,	48,57,	48,57,	48,57,	
48,57,	50,60,	50,60,	50,60,	
50,60,	50,60,	50,60,	50,60,	
50,60,	50,60,	50,60,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	50,60,	50,60,	
50,60,	50,60,	50,60,	50,60,	
51,61,	51,61,	51,61,	51,61,	
51,61,	51,61,	51,61,	51,61,	
51,61,	51,61,	52,62,	0,0,	
52,62,	0,0,	0,0,	52,63,	
52,63,	52,63,	52,63,	52,63,	
52,63,	52,63,	52,63,	52,63,	
52,63,	56,66,	0,0,	56,66,	
0,0,	0,0,	56,67,	56,67,	
56,67,	56,67,	56,67,	56,67,	
56,67,	56,67,	56,67,	56,67,	
58,59,	58,59,	58,59,	58,59,	
58,59,	58,59,	58,59,	58,59,	
58,59,	58,59,	62,63,	62,63,	
62,63,	62,63,	62,63,	62,63,	
62,63,	62,63,	62,63,	62,63,	
66,67,	66,67,	66,67,	66,67,	
66,67,	66,67,	66,67,	66,67,	
66,67,	66,67,	69,73,	69,73,	
69,73,	69,73,	69,73,	69,73,	
69,73,	69,73,	69,73,	69,73,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	69,73,	
69,73,	69,73,	69,73,	69,73,	
69,73,	70,74,	0,0,	70,74,	
0,0,	0,0,	70,75,	70,75,	
70,75,	70,75,	70,75,	70,75,	
70,75,	70,75,	70,75,	70,75,	
72,77,	0,0,	72,77,	0,0,	
0,0,	72,78,	72,78,	72,78,	
72,78,	72,78,	72,78,	72,78,	
72,78,	72,78,	72,78,	74,75,	
74,75,	74,75,	74,75,	74,75,	
74,75,	74,75,	74,75,	74,75,	
74,75,	77,78,	77,78,	77,78,	
77,78,	77,78,	77,78,	77,78,	
77,78,	77,78,	77,78,	82,82,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	82,82,	
82,83,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	82,82,	82,82,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	82,82,	0,0,	0,0,	
0,0,	0,0,	82,82,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	82,82,	
82,82,	0,0,	0,0,	82,82,	
82,82,	82,82,	0,0,	0,0,	
0,0,	0,0,	82,82,	0,0,	
0,0,	0,0,	0,0,	0,0,	
82,82,	82,82,	82,82,	82,82,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	82,82,	0,0,	82,82,	
0,0,	0,0,	0,0,	82,82,	
82,82,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		yyvstop+1,
yycrank+-19,	yysvec+1,	yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+5,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+10,
yycrank+-144,	0,		yyvstop+12,
yycrank+0,	0,		yyvstop+14,
yycrank+65,	0,		yyvstop+17,
yycrank+2,	yysvec+8,	yyvstop+19,
yycrank+4,	yysvec+8,	yyvstop+21,
yycrank+0,	0,		yyvstop+24,
yycrank+0,	0,		yyvstop+27,
yycrank+0,	0,		yyvstop+30,
yycrank+207,	0,		yyvstop+33,
yycrank+3,	yysvec+14,	yyvstop+36,
yycrank+9,	yysvec+14,	yyvstop+39,
yycrank+0,	0,		yyvstop+42,
yycrank+0,	0,		yyvstop+45,
yycrank+0,	0,		yyvstop+48,
yycrank+0,	0,		yyvstop+51,
yycrank+0,	yysvec+4,	yyvstop+54,
yycrank+-329,	yysvec+6,	0,	
yycrank+4,	0,		yyvstop+56,
yycrank+-363,	yysvec+6,	0,	
yycrank+58,	yysvec+8,	yyvstop+58,
yycrank+8,	0,		0,	
yycrank+350,	0,		0,	
yycrank+80,	0,		0,	
yycrank+145,	0,		0,	
yycrank+378,	0,		0,	
yycrank+0,	yysvec+14,	yyvstop+60,
yycrank+0,	0,		yyvstop+62,
yycrank+0,	0,		yyvstop+64,
yycrank+30,	yysvec+14,	yyvstop+66,
yycrank+22,	yysvec+14,	yyvstop+68,
yycrank+-435,	0,		0,	
yycrank+13,	yysvec+27,	0,	
yycrank+18,	yysvec+28,	yyvstop+70,
yycrank+171,	yysvec+29,	yyvstop+72,
yycrank+409,	0,		0,	
yycrank+15,	yysvec+40,	yyvstop+74,
yycrank+25,	yysvec+14,	yyvstop+76,
yycrank+40,	yysvec+14,	yyvstop+78,
yycrank+-483,	0,		0,	
yycrank+0,	0,		yyvstop+80,
yycrank+-27,	yysvec+44,	0,	
yycrank+134,	0,		yyvstop+82,
yycrank+538,	0,		0,	
yycrank+490,	0,		0,	
yycrank+561,	0,		0,	
yycrank+584,	0,		0,	
yycrank+599,	0,		0,	
yycrank+110,	yysvec+14,	yyvstop+84,
yycrank+0,	yysvec+14,	yyvstop+86,
yycrank+-66,	yysvec+44,	0,	
yycrank+614,	0,		0,	
yycrank+55,	yysvec+48,	0,	
yycrank+624,	0,		0,	
yycrank+64,	yysvec+58,	yyvstop+89,
yycrank+170,	yysvec+50,	0,	
yycrank+56,	yysvec+51,	yyvstop+91,
yycrank+634,	0,		0,	
yycrank+0,	yysvec+62,	yyvstop+93,
yycrank+0,	yysvec+14,	yyvstop+95,
yycrank+-65,	yysvec+44,	0,	
yycrank+644,	0,		0,	
yycrank+136,	yysvec+66,	yyvstop+98,
yycrank+115,	0,		yyvstop+100,
yycrank+654,	0,		0,	
yycrank+682,	0,		0,	
yycrank+-86,	yysvec+44,	0,	
yycrank+697,	0,		0,	
yycrank+60,	yysvec+69,	0,	
yycrank+707,	0,		0,	
yycrank+0,	yysvec+74,	yyvstop+102,
yycrank+-70,	yysvec+44,	0,	
yycrank+717,	0,		0,	
yycrank+0,	yysvec+77,	yyvstop+104,
yycrank+-71,	yysvec+44,	0,	
yycrank+-75,	yysvec+44,	0,	
yycrank+-89,	yysvec+44,	0,	
yycrank+-774,	0,		0,	
yycrank+0,	0,		yyvstop+106,
0,	0,	0};
struct yywork *yytop = yycrank+876;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,011 ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
040 ,'!' ,01  ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'+' ,'!' ,'+' ,'!' ,'!' ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'A' ,'B' ,'B' ,'B' ,'E' ,'F' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'L' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'R' ,'S' ,'T' ,'U' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'!' ,'!' ,'!' ,'!' ,'_' ,
'!' ,'a' ,'G' ,'G' ,'G' ,'e' ,'f' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'L' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'R' ,'S' ,'T' ,'U' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'!' ,'!' ,'!' ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char IDLncform_sccsid[] = "@(#)IDLncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define IDLNLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = yyinput();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{IDLunput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{IDLunput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{IDLunput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{IDLunput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						IDLunput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			IDLunput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = yyinput();
		if (yyprevious>0)
			IDLoutput(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyyyinput(){
	return(yyinput());
	}
yyIDLoutput(c)
  int c; {
	IDLoutput(c);
	}
yyIDLunput(c)
   int c; {
	IDLunput(c);
	}
yyinput(){ 
char c;
int err;
c = (((c=yysptr>yysbuf?IDLU(*--yysptr):((err=read(IDLinputfiledesc,(char *) &c,1))!=1?EOF:c))==10?(yylineno++,c):c)==EOF?0:c);
yytchar = c;
return(c);
}
