%{
typedef struct IDLattr_name_tag 
{
  int linenumber,charpos;
  char *name;
} IDLATTR_NAME;


IDLVALUE IDLanIDLVALUE;
nodeDesc IDLanodeDesc;

/* returned by IDLVALUE */
/* attributes whose values are references are changed into
   string values and appended on IDLattrlabelrefs.

   set (and seq) elements that are references are changed into
   IDLnode values with a node name of IDLref_indicator_name
*/
typedef struct
{
  int isname;		/* boolean */
  union { IDLVALUE value;
	  String name; } value;
} IDLnewIDLVALUE;

/* data stack size */
#define YYMAXDEPTH 50000

unsigned int IDLlinechartemp1,IDLlinechartemp2;
/*#define IDLLINECHARPOS(linenum,charpos) \
  (((IDLlinechartemp1=(linenum<<12)) >= 1048575 ? 1048575 : IDLlinechartemp1) |\
   ((IDLlinechartemp2=(charpos&0xfff)) >= 4095 ? 4095 : IDLlinechartemp2))
*/
#define IDLLINECHARPOS(linenum,charpos) \
  ((((IDLlinechartemp1=linenum)>=0xfffff)?0xfffff:IDLlinechartemp1)<<12 |\
   (((IDLlinechartemp2=charpos)>=0xfff)?0xfff:IDLlinechartemp2))

#ifdef DEBUG
#define IDLReduce(lhs)	(void)fprintf(stderr, "Reduce to %s\n", lhs)
#else
#define IDLReduce(lhs)
#endif
%}

%union{
String	     	name;
stringDesc   	strval;
booleanDesc  	boolval;
rationalDesc 	ratval;
integerDesc  	intval;
nodeDesc     	VnodeDesc;
SEQattrDesc  	VSEQattrDesc;
attrDesc     	VattrDesc;
IDLnewIDLVALUE	VIDLVALUE;
setDesc		VsetDesc;
sequenceDesc	VsequenceDesc;
SEQIDLVALUE	VSEQIDLVALUE;
IDLATTR_NAME    *attr_name_type;
}

%token	IDLLPAREN IDLRPAREN IDLLBRACKET IDLRBRACKET IDLLBRACE IDLRBRACE IDLLESS IDLGREATER IDLSEMICOLON
%token	IDLEND
%token	<strval>  IDLSTRING 
%token	<ratval>  IDLRATIONAL 
%token	<intval>  IDLINTEGER 
%token	<boolval> IDLBOOLEAN 
%token	<name>    IDLNAME IDLLABELREF IDLLABEL

%type <VnodeDesc>    	IDL_nodeDesc IDL_nodeName
%type <name>   		IDL_label
%type <VSEQattrDesc>	IDL_attrseq
%type <VattrDesc>	IDL_attrDesc
%type <VIDLVALUE>	IDL_IDLVALUE
%type <VsetDesc>	IDL_setDesc
%type <VsequenceDesc>	IDL_seqDesc
%type <VSEQIDLVALUE>	IDL_IDLVALUEseq
%type <VSEQIDLVALUE>	IDL_IDLVALUEset
%type <attr_name_type>	IDL_attrname

%start IDL_root
%%
IDL_root			:	IDL_nodeDesc IDL_nodeDescSeq IDLEND
				{
				 IDLReduce("IDL_root");
				 IDLroot_node = $1;
				 /* match all references to the node */
				 IDLmatch_references();
				 YYACCEPT;
				}
			|	/* nothing */
				{
				 IDLReduce("_root");
				 IDLroot_node = NULL;
				 YYACCEPT;
				}
			;

IDL_nodeDescSeq		:	IDL_nodeDescSeq IDL_nodeDesc
				{
				 IDLReduce("IDL_nodeDescSeq");
				}
			|	/* nothing */
				{
				 IDLReduce("IDL_nodeDescSeq");
				}
			;

IDL_nodeDesc		:	IDL_nodeName IDLLBRACKET IDL_attrseq IDLRBRACKET
				{
				 IDLReduce("IDL_nodeDesc");
				 $$ = $1;
				 $$->attributes = $3;
				}
			|	IDL_nodeName IDLLBRACKET IDL_attrseq IDLSEMICOLON IDLRBRACKET
				{
				 IDLReduce("IDL_nodeDesc");
				 $$ = $1;
				 $$->attributes = $3;
				}
			|	IDL_nodeName IDLLBRACKET IDLRBRACKET
				{
				 IDLReduce("IDL_nodeDesc");
				 $$ = $1;
				}
			|	IDL_nodeName
				{
				 IDLReduce("IDL_nodeDesc");
				 $$ = $1;
				}
			;

IDL_nodeName		:	IDL_label IDLNAME
				{
				 IDLReduce("IDL_nodeName");
				 $$ = NnodeDesc;
				 $$->srcpos = IDLLINECHARPOS(IDLlineNumber,IDLCharPos-strlen ($2)+1);
				 $$->label = $1;
				 $$->name = $2;
				 if (strlen($1) > 0) /* has label */
					IDLinsert_hashtable($$);
				}
			;

IDL_label			:	IDLLABEL
				{
				 IDLReduce("IDL_label");
				 $$ = $1;
				}
			|	IDLNothing
				{
				 IDLReduce("IDL_label");
				 $$ = NewString("\0");
				}
			;
IDL_attrseq		: 	IDL_attrseq IDLSEMICOLON IDL_attrDesc
				{
				 IDLReduce("IDL_attrseq");
				 appendrearSEQattrDesc($1, $3);
				 $$ = $1;
				}
			|  	IDL_attrDesc
				{
				 IDLReduce("IDL_attrseq");
				 initializeSEQattrDesc($$);
				 appendfrontSEQattrDesc($$, $1);
				}
			|  	IDL_attrseq IDLSEMICOLON error
				{
				 IDLReduce("IDL_attrseq");
				 $$ = $1;
				}
			|  	error
				{
				 IDLReduce("IDL_attrseq");
				 initializeSEQattrDesc($$);
				}
			;
IDL_attrDesc		:	IDL_attrname IDL_IDLVALUE
				{
				 IDLReduce("IDL_attrDesc");
				 $$ = NattrDesc;
 			         $$->srcpos = IDLLINECHARPOS($1->linenumber,$1->charpos);
				 $$->name = $1->name;
				 if ($2.isname) { /* store name in a stringDesc */
				     stringDesc AstringDesc;

				     AstringDesc = NstringDesc;
				     AstringDesc->value = $2.value.name;
				     $$->value.VstringDesc = AstringDesc;
				     appendrearSEQattrDesc(IDLattrlabelrefs, $$);
				   }
				 else $$->value = $2.value.value;
				}
			;
IDL_attrname		: IDLNAME
				{
				 IDLReduce("IDL_attrname");
				 $$ = (IDLATTR_NAME *)malloc((unsigned)sizeof (IDLATTR_NAME));
				 $$->name = $1;
				 $$->linenumber = IDLlineNumber;		
				 $$->charpos = IDLCharPos - strlen ($1) + 1;
				}
			;
IDL_IDLVALUE		:	IDLINTEGER
				{
				 IDLReduce("IDL_IDLVALUE");
				 $$.isname = FALSE;
				 $$.value.value.VintegerDesc = $1;
				}
			|	IDLRATIONAL
				{
				 IDLReduce("IDL_IDLVALUE");
				 $$.isname = FALSE;
				 $$.value.value.VrationalDesc = $1;
				}
			|	IDLBOOLEAN
				{
				 IDLReduce("IDL_IDLVALUE");
				 $$.isname = FALSE;
				 $$.value.value.VbooleanDesc = $1;
				}
			|	IDLSTRING
				{
				 IDLReduce("IDL_IDLVALUE");
				 $$.isname = FALSE;
				 $$.value.value.VstringDesc = $1;
				}
			|	IDL_setDesc
				{
				 IDLReduce("IDL_IDLVALUE");
				 $$.isname = FALSE;
				 $$.value.value.VsetDesc = $1;
				}
			|	IDL_seqDesc
				{
				 IDLReduce("IDL_IDLVALUE");
				 $$.isname = FALSE;
				 $$.value.value.VsequenceDesc = $1;
				}
			|	IDL_nodeDesc
				{
				 IDLReduce("IDL_IDLVALUE");
				 $$.isname = FALSE;
				 $$.value.value.VnodeDesc = $1;
				}
			|	IDLLABELREF
				{ 
				 IDLReduce("IDL_IDLVALUE");
				 $$.isname = TRUE;
				 $$.value.name = $1;
				}
			;

IDL_setDesc		:	IDLLBRACE IDL_IDLVALUEset IDLRBRACE
				{
				 IDLReduce("IDL_setDesc");
				 $$ = NsetDesc;
				 $$->value = $2;
				 {SEQIDLVALUE Si;
				  IDLVALUE Ai;
				  foreachinSEQIDLVALUE($2, Si, Ai) 
				    if (typeof(Ai)==KnodeDesc) {
				      if (Ai.VnodeDesc->name == IDLref_indicator_name) {
					IDLanIDLVALUE.VsetDesc = $$;
					appendrearSEQIDLVALUE(IDLsetlabelrefs, IDLanIDLVALUE);
					break;
				      }
				    }
				 }
				}
			;

IDL_seqDesc		:	IDLLESS IDL_IDLVALUEseq IDLGREATER
				{
				 IDLReduce("IDL_seqDesc");
				 $$ = NsequenceDesc;
				 $$->value = $2;
				 {SEQIDLVALUE Si;
				  IDLVALUE Ai;
				  foreachinSEQIDLVALUE($2, Si, Ai) 
				    if (typeof(Ai)==KnodeDesc) {
				      if (Ai.VnodeDesc->name == IDLref_indicator_name) {
					IDLanIDLVALUE.VsequenceDesc = $$;
					appendfrontSEQIDLVALUE(IDLseqlabelrefs, IDLanIDLVALUE);
					break;
				      }
				    }
				}
				}
			;

IDL_IDLVALUEset		:	IDL_IDLVALUEset IDL_IDLVALUE
				{
				 IDLReduce("IDL_IDLVALUEset");
				 if ($2.isname) {
				   IDLanodeDesc = NnodeDesc;
				   IDLanodeDesc->name = IDLref_indicator_name;
				   IDLanodeDesc->label = $2.value.name;
				   IDLanIDLVALUE.VnodeDesc = IDLanodeDesc;
				   appendrearSEQIDLVALUE($1,IDLanIDLVALUE);
				 }
				 else appendrearSEQIDLVALUE($1, $2.value.value);
				 $$ = $1;
				}
			|	IDLNothing
				{
				 IDLReduce("IDL_IDLVALUEset");
				 initializeSEQIDLVALUE($$);
				}
			;

IDL_IDLVALUEseq		:	IDL_IDLVALUEseq IDL_IDLVALUE
				{
				 IDLReduce("IDL_IDLVALUEseq");
				 if ($2.isname) {
				   IDLanodeDesc = NnodeDesc;
				   IDLanodeDesc->name = IDLref_indicator_name;
				   IDLanodeDesc->label = $2.value.name;
				   IDLanIDLVALUE.VnodeDesc = IDLanodeDesc;
				   appendrearSEQIDLVALUE($1,IDLanIDLVALUE);
				 }
                                 else appendrearSEQIDLVALUE($1, $2.value.value);
				 $$ = $1;
				}
			|	IDLNothing
				{
				 IDLReduce("IDL_IDLVALUEseq");
				 initializeSEQIDLVALUE($$);
				}
			;

IDLNothing			:
				{
				 IDLReduce("IDL_Nothing");
				}
			; /* nothing */
				
%%
static 
IDLmatch_references()
{
	SEQattrDesc 	Sad;
	attrDesc    	AnattrDesc;
	SEQIDLVALUE 	new_sequence, new_set;
    	IDLVALUE    	anewIDLVALUE;
    	IDLVALUE    	AnIDLVALUE, ASetIDLVALUE, ASeqIDLVALUE;
	SEQIDLVALUE 	SSEQIDLVALUE, SIDLVALUE;
	nodeDesc    	found;
	nodeDesc    	IDLfind_label();

				/* resolve labels as attribute values */
	foreachinSEQattrDesc(IDLattrlabelrefs, Sad, AnattrDesc) {
	  if (found=IDLfind_label(AnattrDesc->value.VstringDesc->value)) {
	    AnattrDesc->value.VnodeDesc = found;
	  }
	  else {
	    (void)fprintf(stderr, "no matching node for label %s\n",
		    AnattrDesc->value.VstringDesc->value);
	  }
	}

				/* resolve labels in sets */
				/* assume that sets contain no duplicates */
	foreachinSEQIDLVALUE(IDLsetlabelrefs, SIDLVALUE, ASetIDLVALUE) {
	  initializeSEQIDLVALUE(new_set);
	  foreachinSEQIDLVALUE(ASetIDLVALUE.VsetDesc->value, SSEQIDLVALUE, AnIDLVALUE) {
	    if (typeof(AnIDLVALUE)==KnodeDesc) {
	      if (AnIDLVALUE.VnodeDesc->name == IDLref_indicator_name) {
				/* found a reference */
		if (found=IDLfind_label(AnIDLVALUE.VnodeDesc->label)) {
		  anewIDLVALUE.VnodeDesc = found;
		  appendrearSEQIDLVALUE(new_set, anewIDLVALUE);
		}
		else {
		  (void)fprintf(stderr, "no matching node for label %s\n",
			  AnIDLVALUE.VnodeDesc->label);
		}
	      }
	      else appendrearSEQIDLVALUE(new_set, AnIDLVALUE);
	    }
	    else appendrearSEQIDLVALUE(new_set, AnIDLVALUE);
	  }
/*	  foreachinSEQIDLVALUE(ASetIDLVALUE.VsetDesc->value, SSEQIDLVALUE, AnIDLVALUE) {
	    removeSEQIDLVALUE(ASetIDLVALUE.VsetDesc->value, AnIDLVALUE);
	  }
*/
	  ASetIDLVALUE.VsetDesc->value = new_set;
	  }

				/* resolve labels in sequences */
	foreachinSEQIDLVALUE(IDLseqlabelrefs, SIDLVALUE, ASeqIDLVALUE) {
	  initializeSEQIDLVALUE(new_sequence);
	  foreachinSEQIDLVALUE(ASeqIDLVALUE.VsequenceDesc->value, SSEQIDLVALUE, AnIDLVALUE) {
	    if (typeof(AnIDLVALUE)==KnodeDesc) {
	      if (AnIDLVALUE.VnodeDesc->name == IDLref_indicator_name) {
				/* found a reference */
		if (found=IDLfind_label(AnIDLVALUE.VnodeDesc->label)) {
		  anewIDLVALUE.VnodeDesc = found;
		    appendrearSEQIDLVALUE(new_sequence, anewIDLVALUE);
		}
		else {
		  (void)fprintf(stderr, "no matching node for label %s\n",
			  AnIDLVALUE.VnodeDesc->label);
		}
	      }
	      else appendrearSEQIDLVALUE(new_sequence, AnIDLVALUE);
	    }
	    else appendrearSEQIDLVALUE(new_sequence, AnIDLVALUE);
	  }
/*	  foreachinSEQIDLVALUE(ASeqIDLVALUE.VsetDesc->value, SSEQIDLVALUE, AnIDLVALUE) {
	    removeSEQIDLVALUE(ASeqIDLVALUE.VsequenceDesc->value, AnIDLVALUE);
	  }
*/
	  ASeqIDLVALUE.VsequenceDesc->value = new_sequence;
	}
}

yyerror(s)
char *s;
{
	if (!strcmp (s,"yacc stack overflow"))
	  (void)sprintf (IDLreaderror,"IDLread: parser stack overflow on line %-d: Increase YYMAXDEPTH in IDLread.c\n",s,IDLlineNumber);
	else
	  (void)sprintf (IDLreaderror,"IDLread: %s on line %-d\n",s,IDLlineNumber);
	(void)fputs (IDLreaderror,stderr);
        (void)fflush (stderr);
}
