/***********************************************************************\ 
*									* 
*   File: scorpion/lib/lintlib/libidl.c 
*				 					* 
*   Copyright (C) 1991 Kwok Chan
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Dec 9 1990 (kkc) Created.					* 
*									* 
\***********************************************************************/ 

/*LINTLABRARY*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/errno.h>
#include <C/global.h>
#include <C/reader.h>
#include <C/writer.h>
#include "ivw.h"

/* MsgChar.c */
void MsgChar(c) char c; {;}

/* alloc.c */
#define MAXSIZE	 400
#define MAXINDEX MAXSIZE/4+1

typedef struct memchunk {
	struct memchunk *next;
} *memchunkptr;

struct {
	memchunkptr free;
} memory_chunks[MAXINDEX];

#define MANY		100
#define FEW		10
#define BOUNDARY	48

#ifdef MONITOR
/* keep an array for count for each size */
int mem_counts[MAXINDEX];
#endif

char *GetHeap(size) int size; {return (char *)NULL;}

/*VARARGS*/
void FreeHeap(hpptr, size) char *hpptr; int size; {;}

void out_of_memory() {;}

void print_memcounts() {;}

/* array.c */
# define FArray(arr,siz)  FreeHeap(arr,siz)
# define MORECELLS 8

Boolean IDLInArray(arr, elem) GenArray arr; int elem; {return TRUE;}

GenArray IDLArraySort(arr, cmpfn) GenArray arr;Boolean (*cmpfn)(); {return arr;}

GenArray IDLArraySortUnion(arr, cmpfn) GenArray arr; Boolean (*cmpfn)(); {return arr;}

void IDLArrayOrderedInsert(arr, elem, cmpfn) 
    GenArray *arr; int elem; Boolean (*cmpfn)();
    {;}

void IDLArrayOrderedInsertUnion(arr, elem, cmpfn)
    GenArray *arr; int elem; Boolean (*cmpfn)();
    {;}
    
void IDLArrayAddFront(arr, elem) GenArray *arr; int elem; {;}

void IDLArrayAddRear(arr, elem) GenArray *arr; int elem; {;}

GenArray IDLArrayTail(arr) GenArray arr; {return arr;}

void IDLArrayRemoveFirstElem(arr) GenArray *arr; {;}

void IDLArrayRemoveIthElem(arr, Iindex) GenArray *arr; int Iindex; {;}

void IDLArrayRemoveElem(arr, elem) GenArray *arr; int elem; {;}

GenArray IDLArrayCopy(arr) GenArray arr; {return arr;}

/* basics.c */
#define MarkRoutine(name, type) void name(t) type t; {;}

/* chkadr.c */
#define TOPADR 0xeffffff
caddr_t sbrk();
extern int end, etext, edata;

int chkadr(adr, len) int adr; int len; {return 1;}

/* cmmlop.c */
int cmmlop() {return 1;}

/* converr.c */
void ConversionError(FromClass, ToClass)
    char *FromClass, *ToClass;
    {;}

/* debug.c */
#define LTABSIZ 1024
void PrintLabelTable(LabelTable)
    LabelRefType LabelTable[LTABSIZ];
    {;}

/* dump.c */
void dump(dmpptr, cnt) char *dmpptr; int cnt; {;}

/* getstrttyprm.c */
char *getstrttyprm (prmstr, str, numchr)
    char *prmstr, *str; int  numchr;
    {return str;}

/* idlr_glb.c */
#define BUFSIZE 1024
char IDLreaderror[BUFSIZE];
char IDLStructureName[BUFSIZE];

/* idlvlib.c */
int dmyincvar, usrdsc;

void IDLVlib() {;}

void IDLView_alert() {;}

/* iniacktrl.c */
void iniacktrl(trladr) char trladr[ACKTRLSIZ]; {;} 

/* inibadacktrl.c */
void inibadacktrl(trladr) char trladr[ACKTRLSIZ]; {;}

/* iniivwmsg.c */
void iniivwmsg(ivwmsgadr) ivwmsghdr *ivwmsgadr; {;}

/* init.c */
int N_INIT(adr,i,size)
    char *adr;
    int i, size;
    {return 1;}

/* inseq.c */
/* Commented out */

/* IDLstring.c */
char *IDLstrchr(s,c) char *s,c; { return (char *)NULL;}
char *IDLstrrchr(s,c) char *s,c; { return (char *)NULL;}

/* labels.c */
# define LTABSIZ 1024
LabelRefType LabelTable[LTABSIZ];
extern PF_AttrStore GenericAttrStore;
enum LErrType { ErrUnresolvedLabel, ErrUnresolvedKids, ErrBadLabelType };
struct LabelRefRecord BlankLabel = { NULL, NULL, 0, 0, NULL, NULL };

int hash(S) char *S; {;}

void LError(E,S) enum LErrType E; String S; {;}

void FixUpRefs(MyLabel,P) LabelRefType MyLabel; PosType P; {;}

LabelRefType FindLabel(LLex) Lexeme LLex; {return (LabelRefType) NULL;}

void ReplaceLabel(Old,New) LabelRefType Old, New; {;}

void SaveLabel(SLex,Value) Lexeme SLex; RepType Value; {;}

RepType LabelRef(RLex) Lexeme RLex; {return (RepType) NULL;}

RepType FakeLabel(ForVal) RepType ForVal; {return ForVal;}

void DelaySeqRef(List,MyLabel,Fake,Where) 
    SeqType List; LabelRefType MyLabel, Fake; PosType Where;
    {;} 

void DelayedRef(NType,Desc,MyLabel,Fake,Where)
    NodeType NType; AttrDesc Desc; LabelRefType MyLabel, Fake; PosType Where;
    {;}

void LabelInit() {;}	

int LabelFinish() {return 1;}

/* libcnncmm.c */
#define PORTNUMBER 2001
#define MAXHSTNAM 31
char hstnam[MAXHSTNAM];
struct hostent *hp;

/*VARARGS*/
int libcnncmm(ivwsess, idlfilnam, serv_host, disp_host, idlbrowse)
char *ivwsess, *idlfilnam;
char *serv_host, *disp_host, *idlbrowse;
{ return 1;}

/* list.c */
#define ENDLIST NULL
#define FIRST(l) l
#define NEXT(l) l->next
#define NCGenList (pGenList)GetListCell(sizeof(struct GenList))
#define XCGenList(c) (FreeListCell(c,sizeof(struct GenList)))

pGenList IDLListInsertAfter(p1, p2) pGenList p1, p2; {return p1;}

pGenList IDLListAddRear(l, value) pGenList l; int value; {return l;}

pGenList IDLListAddFront(l, value) pGenList l; int value; {return l;}

void IDLListModifyIth(l, Mindex, value) pGenList l; int Mindex, value; {;}

int IDLListRetrieveFirst(l) pGenList l; {return 1;}

int IDLListRetrieveLast(l) pGenList l; {return 1;}

int IDLListRetrieveIth(l, Rindex) pGenList l; int Rindex; {return 1;}

pGenList IDLListTail(l) pGenList l; {return l;}

pGenList IDLListLastCell(l) pGenList l; {return l;}

pGenList IDLListConnect(l1, l2) pGenList l1, l2; {return l1;}

pGenList IDLListReverse(l) pGenList l; {return l;}

pGenList IDLListRemoveCell(l, value) pGenList l; int value; {return l;}

pGenList IDLListRemoveFirstCell(l) pGenList l; {return l;}

pGenList IDLListRemoveIthCell(l, Rindex) pGenList l; int Rindex; {return l;}

pGenList IDLListRemoveLastCell(l) pGenList l; {return l;}

Boolean IDLInList(l, value) pGenList l; int value; {return TRUE;}

pGenList IDLListOrderedInsert(list, val, compfn)
    pGenList list; int val; Boolean (*compfn)();
    {return list;}

pGenList IDLListOrderedInsertUnion(list, val, compfn)
    pGenList list; int val; Boolean (*compfn)();
    {return list;}

/*VARARGS*/
pGenList IDLListSort(list, compfn) 
    pGenList list; Boolean (*compfn)(); 	
    {return list;}

pGenList IDLListSortUnion(list, compfn)
    pGenList list; Boolean (*compfn)(); 	
    {return list;}

int IDLListLength(l) pGenList l; {return 1;}

pGenList IDLListCopy(l) pGenList l; {return l;}

Boolean IDLListContains(l1, l2) pGenList l1, l2; {return TRUE;}

Boolean IDLListsEqual(l1, l2) pGenList l1, l2; {return TRUE;}

/* nextOne.c */
int _nextOne(set,offset,max) int set[]; int offset, max; {return 1;}

/* outtokens.c */
char listHeading[]="<",
listLinking[]=" ",
listEnding[]=">",
setHeading[]="{",
setLinking[]=" ",
setEnding[]="}",
stringHeading[]="\"",
stringEnding[]="\"",
nodeHeading[]="[",
nodeEnding[]="]\n",
attrSep[]=";\n",
attrMidSep[]=" ",
trueToken[]="TRUE",
falseToken[]="FALSE";

/* rcvwdwmsg.c */
int rcvwdwmsg (ivwmsg, blkptr) ivwmsghdr *ivwmsg; ptr *blkptr; {return 1;}

/* reader.c */
FILE * Input;
Lexeme Lex;
int OK;
ntype *IDLAllNodeTypes;
char **IDLNodeAttributes;
int IDLnum_nodetypes;
int IDLmax_attributes;
PF_NodeType	GenericNodeAlloc;
PF_AttrStore	GenericAttrStore;
struct Name_Val { Lexeme Name; RepType Val; };

int FindNodeType(str) char *str; {return 1;}

AttrDesc FindAttribute(N, s) int N; char *s; {return 0;}

void RelLex() {;}

void NextLex() {;} 

int IsLex(Expected) LexType Expected; {return 1;}

void SkipLex(LexWanted,CloseLex,OpenLex) LexType LexWanted,CloseLex,OpenLex; {;}

RepType ValueList() {return (RepType) NULL;}

RepType Value() {return (RepType) NULL;}

RepType PValue() {return (RepType) NULL;}

struct Name_Val Pair() {struct Name_Val nv; return nv;}

RepType ParseAttributes(A, Ref) int A; RepType Ref; {return Ref;}

RepType Node() {return (RepType) NULL;}

int LValueList() {return 1;}

RepType NodeRef() {return (RepType) NULL;}

NodeType Reader(InFile) FILE * InFile; {return (NodeType) NULL;}

/* rmisc.c */
void Error(What,Where) ErrType What; PosType Where; {;}

void ErrInit() {;}

void ErrFinish() {;}

SeqType NewSeq() {return (SeqType) NULL;}

SeqType AddSeq(L,V) SeqType L; RepType V; {return (SeqType) NULL;}	

RepType MakeVal(Attr,TLex) RepKind Attr; Lexeme TLex; {return (RepType) NULL;}

RepType MakeBool(TorF,P) int TorF; PosType P; {return (RepType) NULL;}

RepType MakeNode(N,P) NodeType N; PosType P; {return (RepType) NULL;}

RepType MakeSeq(S,P) SeqType S; PosType P; {return (RepType) NULL;}

String StrCopy(S) String S; {return S;}

String GString(R) RepType R; {return (String) NULL;}

Boolean GBoolean(R) RepType R; {return TRUE;}

void DelRep(R) RepType R; {;}

/* scanner.c */
#define PIPECHAR '\174'
#define QUOTE	 '\042'
#define TILDE	 '\176'
#define DEL	 '\177'
#define BUFFERSIZE 8000
char C;
int Line;
char BUFFER[BUFFERSIZE];
int BUFLEN;
#define AddBuffer(c)	\
	{if (BUFLEN<BUFFERSIZE) BUFFER[BUFLEN++] = c; \
	else {fprintf(stderr, "idlreader: Insufficient buffer space\n"); exit(1);}}

char *BufCopy() {return (char *) NULL;}

void LexInit(F) FILE *F; {;}	

Lexeme GetLex(MyFile) FILE * MyFile; {Lexeme l; return l;}	

void escape_check(MyFile, Ret) FILE *MyFile; Lexeme Ret; {;}
		
/* sndabomsg.c */
#define SAFWRTSIZ 10
char safwrt [SAFWRTSIZ+1] = "eeeeeeeeee";

void sndabomsg(lng) int lng; {;} 

/*sndcdlwdw.c */
extern char *IDLcandlefilename;
extern int wdwinists;	

/*VARARGS*/
int sndcdlwdw (id, serve, displa, idlbrowse) /* send Candle to Window */
     char *id, *serve, *displa, *idlbrowse;
{return 1;}


/* sndfstnod.c */
int sndfstnod(adr) ptr adr; {return 1;}

/* sndwdwmsg.c */
int sndwdwmsg(hdr) ivwmsghdr hdr; {return 1;}

/* string.c */
#define STABSIZ 250

typedef struct IDLtag1{
        struct IDLtag1 *next;
        String value;
} CString, *LString;

# define SEQString LString

# define appendfrontSEQString(Stringseq,Stringvalue) Stringseq=\
		(SEQString)IDLListAddFront((pGenList)Stringseq,Stringvalue)

# define foreachinSEQString(Stringseq,Stringptr,Stringvalue) for\
(Stringptr = Stringseq; \
 		Stringptr!=NULL&&((Stringvalue=Stringptr->value)||1); \
Stringptr=Stringptr->next)

# define emptySEQString(Stringseq) ((Stringseq)==NULL)

SEQString StringTable[STABSIZ]; 
SEQString ReaderStringTable[STABSIZ]; 

int StringHash(S) char *S; {return 1;}

String NewString(str) String str; {return str;}

void InitStringTable() {;}

void PrintStringTable() {;}

void InitReaderStringTable() {;}

void PrintReaderStringTable() {;}

String NewReaderString(str) String str; {return str;}

String RetrieveReaderString(str) String str; {return str;}

char *StringToChar(str) String str; {return (char *) NULL;}

int StringCmp(str1, str2) String str1, str2; {return 1;}

Boolean NCStringMatch(s1, s2) String s1, s2; {return TRUE;}

/* wmisc.c */
#define MAXSTRINGLEN 5000
#define IDLStringSize 20

char IDLExternBuf[IDLExternBufSize];

void WError(E) WErrType E; {;}

void WString(S) String S; {;}

char *check_string(S) String S; {return (char *) NULL;}

/* wrat.c */
void WIDLfloat(f) double f; {;}

char *RetIDLfloat(f) double f; {;}

/* writeext.c */
char buffer[256];

int IDLBooleanToExternal(value, result, len)
    Boolean value; char *result; int len;
    {return 1;}

int IDLdoubleToExternal(value, result, len, base)
    double value; char *result; int len; int base;
    {return 1;}

int IDLfloatToExternal(value, result, len, base)
    float value; char *result; int len; int base;
    {return 1;}

int IDLintToExternal(value, result, len)
    int value; char *result; int len;
    {return 1;}

int IDLUnsignedIntToExternal(value, result, len)
    unsigned int value; char *result; int len;
    {return 1;}

int IDLlongToExternal(value, result, len)
    long value; char *result; int len;
    {return 1;}

int IDLUnsignedLongToExternal(value, result, len)
    unsigned long value; char *result; int len;
    {return 1;}

int IDLStringToExternal(value, result, len)
    String value; char *result; int len;
    {return 1;}

/* xivw_util.c */

void apperr (str) char *str; {;}

int readline (fd, rdptr) int fd; char **rdptr;
{ return 1;}

void writeline(fd, wrptr)
     int        fd;
     char     *wrptr;
{;}
