/***********************************************************************\ 
*									* 
*   File: scorpion/lib/lintlib/libci.c 
*				 					* 
*   Copyright (C) 1991 Kwok Chan
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Dec 9 1990 (kkc) Created.					* 
*									* 
\***********************************************************************/ 

/*LINTLIBRARY*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>

/* ftime function not available on iris */
#ifndef sgi
#include <sys/timeb.h>
#endif

#include <sys/stat.h>
#include <sys/dir.h>
#include <string.h>
#include <signal.h>
#include <ctype.h>
#include <math.h>
#include <errno.h>
#include <setjmp.h>
#include "ci.h"
#include "del.h"
#include "c.h"
#include "fold.h"
#include "libcmu.h"

#ifdef hp9000s300
/* dummy function to use the variables _MAXLDBL and _NMAXLDBL 
   from math.h  Only occurs on the hp9000 */
void dummy_mathh () {long_double dummy; dummy = _MAXLDBL; _NMAXLDBL = dummy;}
#endif


/* atoh.c */
unsigned int atoh(ap) char *ap; {return 1;}

/* atoo.c */
unsigned int atoo(ap) char *ap; {return 1;}

/* atot.c */
time_t atot(str) char *str; {return (time_t) 1;}

/* boolarg.c  */
int boolarg(ptr, brk, prompt, defalt)
    char **ptr, *brk, *prompt; int defalt;
    {return 1;}

/* chrarg.c */
int chrarg (ptr, brk, prompt, legals, defalt)
    char **ptr, *brk, *prompt, *legals, defalt;
    {return 1;}

/* ci.c */
int ciquiet, ciexit;
FILE *ciinput;
extern char _argbreak;

#define LINELENGTH 1100	
#define MAXENTRIES 200
#define MAXHELPS 200
int _h_found;	
char **_h_list;
char (*_h_nlist)[20];	

char *delchoice[] = {
	"abort		abort command file",
	"breakpoint	break to tty, then resume command file",
	0};

void ci(prompt, fil, depth, list, helppath, cmdfpath)
    char *prompt; FILE *fil; int depth; CIENTRY *list;
    char *helppath; char *cmdfpath;
    {;}


int _ci_help(filspec) char *filspec; {return 1;}

int ci_hcomp(p, q) char **p, **q; {return 1;}

void ci_help(topic, helppath) char *topic, *helppath; {;}

void ci_show(entry, arg, mode) CIENTRY entry; char *arg; CIMODE mode; {;}

void _ci_sho(etype, eptr) ci_type etype; ci_union *eptr; {;}

void ci_set(entry, arg) CIENTRY entry; char *arg; {;}

void _ci_set(etype, eptr, arg) ci_type etype; ci_union *eptr; char *arg; {;}

/* cidefs.c */
char *MetaHelp;

/* del.c */
int _del_;

int del() {;}

/* doublearg.c */
double doublearg(ptr,brk,prompt,min,max,defalt)
    char **ptr,*brk,*prompt; double min,max,defalt;
    {return min;}

/* editor.c */
typedef enum {
	MISSING = -2, RANDOM, ED, FRED}
EDITOR;
#define DEFAULTED "/usr/ucb/ex"
char *edname[] = {"ed","fred",0};

int editor(file,prompt) char *file,*prompt; {return 1;}

/* errlst.c */
char	*sys_errlist[] = {
	"Error 0",
	"Not owner",
	"No such file or directory",
	"No such process",
	"Interrupted system call",
	"I/O error",
	"No such device or address",
	"Arg list too long",
	"Exec format error",
	"Bad file number",
	"No children",
	"No more processes",
	"Not enough core",
	"Permission denied",
	"Bad address",
	"Block device required",
#if	CMU
	"File or mount device busy",
#else
	"Mount device busy",
#endif
	"File exists",
	"Cross-device link",
	"No such device",
	"Not a directory",
	"Is a directory",
	"Invalid argument",
	"File table overflow",
	"Too many open files",
	"Not a typewriter",
	"Text file busy",
	"File too large",
	"No space left on device",
	"Illegal seek",
	"Read-only file system",
	"Too many links",
	"Broken pipe",
	"Argument too large",
	"Result too large",
};
int	sys_nerr;

/* execvp.c */
#ifdef CMU
char shell[] = "sh";
char defpath[] = ":/usr/cmu/bin:/bin:/usr/bin";
#else
char shell[] =	"/bin/sh";
#endif
int errno;

/*VARARGS*/
int execlp(name, argv) char *name, *argv; {return 1;}

int execvp(name, argv) char *name, **argv; {return 1;} 

char *execat(s1, s2, si) char *s1, *s2, *si; {return s1;}

/*  expand.c  */
#define META "[*?"	
#define SLASH '/'
#define DOT '.'
int nres;	

/*VARARGS*/
int expand(fname, buf, bsize) char *fname, **buf; int bsize; {return 1;}

/*VARARGS*/
int xexpand(fname, buf, bsize) char *fname, **buf; int bsize; {return 1;}

int xmatch(name, pattern) char *name, *pattern; {return 1;}

/*  ffilecopy.c */
int ffilecopy(here, there) FILE *here, *there; {return 1;}

/*  filecopy.c  */
int filecopy(here, there) int here, there; {return 1;}

/*  floatarg.c  */
float floatarg(ptr, brk, prompt, min, max, defalt)
    char **ptr, *brk, *prompt;
    float min, max, defalt;
    {return 1.0;}

/*  fold.c  */
char *fold(out, in, whichway) char *in, *out; FOLDMODE whichway; {return NULL;}

char *foldup(out, in) char *in, *out; {return NULL;}

char *folddown(out, in) char *in, *out; {return NULL;}

/*  getbool.c */
int getbool(prompt, defalt) char *prompt; int defalt; {return 1;}

/*  getchr.c  */
int getchr(prompt, legals, defalt) char *prompt, *legals, defalt; {return 1;}

/*  getdouble.c  */
double getdouble(prompt, min, max, defalt)
    double min, max, defalt;
    char *prompt;
    {return min;}

/*  getfloat.c  */
float getfloat(prompt, min, max, defalt)
    float min, max, defalt;
    char *prompt;
    {return min;}

/*  gethex.c  */
unsigned int gethex (prompt, min, max, defalt)
    unsigned int min, max, defalt;
    char *prompt;
    {return min;}

/*  getint.c  */
int getint(prompt, min, max, defalt)
    int min, max, defalt;
    char *prompt;
    {return 1;}

/*  getlong.c  */
long getlong(prompt, min, max, defalt)
    long min, max, defalt;
    char *prompt;
    {return min;}

/*  getoct.c  */
unsigned int getoct(prompt, min, max, defalt)
    unsigned int min, max, defalt;
    char *prompt;
    {return min;}

/*  getsearch.c  */
int getsearch(prompt, table, defalt)
    char *prompt, **table, *defalt;
    {return 1;}

/*  getshort.c  */
short getshort(prompt, min, max, defalt)
    short min, max, defalt;
    char *prompt;
    {return min;}

/*  getstab.c  */
int getstab(prompt, table, defalt) char *prompt, **table, *defalt; {return 1;}

/*  getstr.c  */
char *getstr(prompt, defalt, answer)
    char *prompt, *defalt, *answer;
    {return NULL;}

/*  glob.c  */
int smallsize, bigsize;	/* control Fibonacci storage allocator */
char **results;		/* where to put them */

char **glob(fname) char *fname; {return NULL;}

/*  gtime.c  */
int dmsize[12] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

long gtime(tm) struct tm *tm; {return 1L;}

/*  hexarg.c  */
int hexarg(ptr, brk, prompt, min, max, defalt)
    char **ptr, *brk, *prompt;
    unsigned int min, max, defalt;
    {return 1;}

/*  intarg.c  */
int intarg(ptr, brk, prompt, min, max, defalt)
    char **ptr, *brk, *prompt;
    int min, max, defalt;
    {return 1;}

/*  longarg.c  */
long longarg(ptr, brk, prompt, min, max, defalt)
    char **ptr, *brk, *prompt;
    long min, max, defalt;
    {return min;}

/*  mktemp.c  */
char *mktemp(as) char *as; {return as;}

/*  nxtarg.c  */
char *nxtarg(q, brk) char **q, *brk; {return brk;}

/*  octarg.c  */
int octarg(ptr, brk, prompt, min, max, defalt)
    char **ptr, *brk, *prompt;
    unsigned int min, max, defalt;
    {return 1;}

/*  openp.c  */
int mod, value;
FILE *fvalue;

int func(fnam) char *fnam; {return 1;}

int ffunc(fnam) char *fnam; {return 1;}

int openp(path, file, complete, mode)
    char *path, *file, *complete;
    int mode;
    {return 1;}

FILE *fopenp(path, file, complete, fmode)
    char *path, *file, *complete, *fmode;
    {return (FILE *) NULL;}

/*  path.c  */
void path(original, direc, file) char *original, *direc, *file; {;}

/*  pdate.c  */
struct tm *tm;			
char *strp;		
int delim;	
jmp_buf errbuf;
char *strings[] = { "JANUARY", "FEBRUARY", "MARCH", "APRIL",
                    "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER",
                    "OCTOBER", "NOVEMBER", "DECEMBER", "MONDAY",
                    "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY",
                    "SATURDAY", "SUNDAY", 0 };
# define NUMBER 257
# define WEEKDAY 258
# define MONTH 259

int pdate(str, tmp) char *str; struct tm *tmp; {return 1;}

/*  prstab.c  */
#define SPACE 5		
#define MAXCOLS 71
#define MINROWS 8

void prstab(list) char **list; {;}

/*  putenv.c  */
#define EXTRASIZE 5	
int envsize;

/*VARARGS*/
int putenv(name, envvalue) char *name, *envvalue; {return 1;}

int findenv(name) char *name; {return 1;}

int newenv() {return 1;}

int moreenv() {return 1;}

/*  runv.c  */
#ifdef sequent
#define TYPEOFSIGNAL int
#endif

#ifdef vax
#define TYPEOFSIGNAL int
#endif

/* for suns, mips */
#ifndef TYPEOFSIGNAL
#define TYPEOFSIGNAL void
#endif

int run(name, argv) char *name, *argv; {return 1;}

int runv(name, argv) char *name, **argv; {return 1;}

/*  runvp.c  */
#ifdef sequent
#define TYPEOFSIGNAL int
#endif

#ifdef vax
#define TYPEOFSIGNAL int
#endif

/* for suns, mips */
#ifndef TYPEOFSIGNAL
#define TYPEOFSIGNAL void
#endif

/*VARARGS*/
int runp(name, argv) char *name, *argv; {return 1;}

int runvp(name, argv) char *name, **argv; {return 1;}

/*  searcharg.c  */
int searcharg(ptr, brk, prompt, table, defalt)
    char **ptr, *brk, *prompt, **table, *defalt;
    {return 1;}

/*  searchp.c  */
int searchp(srchpath, file, fullname, cmpfunc)
    char *srchpath, *file, *fullname;
    int (*cmpfunc)();
    {return 1;}

/*  shortarg.c  */
short shortarg(ptr, brk, prompt, min, max, defalt)
    char **ptr, *brk, *prompt;
    short min, max, defalt;
    {return min;}

/*  sindex.c  */
char *sindex(big, small) char *big, *small; {return big;}

/*  skipto.c  */
char *skipover(string, charset) char *charset, *string; {return string;}

char *skipto(string, charset) char *charset, *string; {return string;}

/*  srchscore.c  */
#define INSERTCOST 1	
#define DELETECOST 1
#define CHANGECOST 3	
char *newsmall;

int smatch(big, small) char *big, *small; {return 1;}

int srchscore(big, small) char *big, *small; {return 1;}

/*  stabarg.c  */
int stabarg(ptr, brk, prompt, table, defalt)
    char **ptr, *brk, *prompt, **table, *defalt;
    {return 1;}

/*  stablk.c  */
#define NOTFOUND -1
#define AMBIGUOUS -2
#define MAXSTRINGS 500

int stablk(arg, table, quiet) char *arg, **table; int quiet; {return 1;}

/*  stabsearch.c  */
#define KEEPBEST 6		
#define KEEPPERFECT 50	
#define PERFECT 100
#define THRESHOLD 35	
#define NOMATCH -1
#define MAXLENGTH 400	
#define SCROLLSIZE 20

int stabsearch(arg, table, quiet) char *arg, **table; int quiet; {return 1;}

/*  stlmatch.c  */
int stlmatch(big, small) char *small, *big; {return 1;}

/*  strarg.c  */
char *strarg(ptr, brk, prompt, defalt, buf)
    char **ptr, *brk, *prompt, *defalt, *buf;
    {return brk;}
