{***********************************************************************\ 
*									* 
*   File: scorpion/include/Pascal/writer.i
*				 					* 
*   Copyright (C) 1991 Michael Shapiro and Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*	This file is included in the writer routines			*
*	produced by the IDL processor.					*
*
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const LTABSIZ = 1024;

type ErrType = (ErrNullNode,ErrTooManyLabels);

var RN: RNodeType;
	LabelTable: array[1..LTABSIZ] of RNodeType;
	LabelCount: integer;

procedure error(E: ErrType);
begin
	OK := false;
	write(Output, 'Writer Error: ');
	case E of
	ErrNullNode: writeln(Output, 'null node');
	ErrTooManyLabels: writeln(Output, 'too many labels')
	end
end;

procedure WriteLabel(First:boolean);
var i: integer;
begin
	if First
	then begin
		if LabelCount=LTABSIZ
		then error(ErrTooManyLabels)
		else begin
			LabelCount:=LabelCount + 1;
			LabelTable[LabelCount]:=RN;
			write(Output,'L',LabelCount:1,':')
			end
		end
	else for i:=1 to LabelCount do	(* assumes that there is only one *)
		if CompNodeType(LabelTable[i], RN)
		then write(Output,'L',i:1,'^')
end;

procedure WBoolean(B:boolean);
begin
	case B of
	true:	write(Output,'TRUE');
	false:	write(Output,'FALSE')
	end
end;

procedure WString(S:String);
var i:integer;
    c : char;
begin

    write(Output,'"');
    if (S <> nil) then
	for i := 1 to S^.length do 
	begin
	 c := S^.value[i];
	 if ord(c) <= 31 then
	     begin
		 write(Output,'~');
		 write(Output,chr(ord(c) + ord('@')))
	     end
	 else if c = '~' then
	     begin
		 write(Output,c);
		 write(Output,c)
	     end
	 else if c = '"' then
	     begin
		 write(Output,'"');
		 write(Output,'"')
	     end
	 else if ord(c) = 127 then
	     begin
		 write(Output,'~');
		 write(Output,'{')
	     end
	 else write(Output,c)
	end;
    write(Output,'"')
end;
