{***********************************************************************\ 
*									* 
*   File: scorpion/include/Pascal/reader2.i
*				 					* 
*   Copyright (C) 1991 Michael Shapiro and Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 

*	Main body of the reader.
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

begin
	ErrInit;
	LexInit(Input);
	NextLex;
	TempLex.Pos := Lex.Pos;
	LabelInit;
	NodeRef(CallOK, TempRoot);
	TempLex.Token := nil;
	OK := false;
	if CallOK then begin { check list of labelled values }
		if TempRoot^.Kind=RepLabelRef
			then TempLex.Token := TempRoot^.LabelField^.Name;
		if Lex.Kind = LexEOF
			then OK := true
			else OK := LValueList
		end; { check list of labelled values }
	if Lex.Kind <> LexEOF then Error(ErrEOFExpected,Lex.Pos);
	if CallOK then begin
		if TempLex.Token <> nil then TempRoot := LabelRef(TempLex);
		if not LabelFinish then OK := false;
		if TempRoot^.Kind = RepNode
			then begin { ensure correct root type }
				Root := TempRoot^.NodeField;
				if not InRootSet(Root^.Kind) then begin
					Error(ErrBadRootType,TempLex.Pos);
					OK := false
					end;
				end { ensure correct root type }
			else begin
				Root := nil; {root is unresolved forward ref}
				Error(ErrNoRoot,TempLex.Pos);
				OK := false;
				end;
		end { if CallOK }
	else
		if not LabelFinish then OK := false;
	RelLex(TempLex);
	ErrFinish;
end; (* Reader *)

