/***********************************************************************\ 
*									* 
*   File: scorpion/include/C/writer.h 
*				 					* 
*   Copyright (C) 1991 Tim Maroney
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*LINTLIBRARY*/
#ifndef IDLCINC_writer_h
#define IDLCINC_writer_h

String RetIDLfloat();

/* writer routine macros for basic data types: 
   call to IDL<basic-type>ToExternal */
#define WBoolean(v)\
  (void)IDLBooleanToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wchar(v)\
  (void)IDLcharToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wuchar(v)\
  (void)IDLUnsignedCharToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wu_char(v)\
  (void)IDLUnsignedCharToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define WInteger(v)\
  (void)IDLIntegerToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wint(v)\
  (void)IDLintToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wuint(v)\
  (void)IDLUnsignedIntToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wu_int(v)\
  (void)IDLUnsignedIntToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wshort(v)\
  (void)IDLshortToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wushort(v)\
  (void)IDLUnsignedShortToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wu_short(v)\
  (void)IDLUnsignedShortToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wlong(v)\
  (void)IDLlongToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wulong(v)\
  (void)IDLUnsignedLongToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define Wu_long(v)\
  (void)IDLUnsignedLongToExternal(v,IDLExternBuf,IDLExternBufSize);IDLout(IDLExternBuf)
#define WRational(v)\
  (void)IDLfloatToExternal(v,IDLExternBuf,IDLExternBufSize,10);IDLout(IDLExternBuf)
#define Wfloat(v)\
  (void)IDLfloatToExternal(v,IDLExternBuf,IDLExternBufSize,10);IDLout(IDLExternBuf)
#define Wdouble(v)\
  (void)IDLdoubleToExternal(v,IDLExternBuf,IDLExternBufSize,10);IDLout(IDLExternBuf)
void WString();

extern char charBuf[256];

# define IDLout(v)	(void)fputs(v,IDLcurrentFile)
# define IDLoutC(c)	(void)putc(c,IDLcurrentFile)
# define IDLoutLabel(v)	(IDLout("L"),IDLout(itoa((int) v)))

# define itoa(v)	((void)sprintf(charBuf,"%d",(v)),charBuf)
# define dtoa(v)	((void)sprintf(charBuf,"%g",(v)),charBuf)
# define CBSIZ	256

/*  static char charBuf[CBSIZ];  */

# define MBoolean(X)
# define MString(X)
# define MInteger(X)
# define Mchar(X)
# define Muchar(X)
# define Mshort(X)
# define Mushort(X)
# define Mint(X)
# define Muint(X)
# define Mlong(X)
# define Mulong(X)
# define Mdouble(X)
# define Mfloat(X)

void WSetInteger(),WAInteger();
void WSetDouble(),WAdouble();
void WSetFloat(),WAfloat();
void WSetBoolean(),WABoolean();
void WIDLfloat();

FILE *IDLcurrentFile;

typedef enum { ErrPortMode, ErrNullNode, ErrBadClassType } WErrType;

# define DoubleQuote '"'
# define ListLink ' '
# define OpenAngle '<'
# define CloseAngle '>'
# define OpenBrace '{'
# define CloseBrace '}'
# define CloseBracket ']'
# define UpArrow '^'
# define Colon ':'
# define OpenBracket '['
# define AttrSep '\t'

# define P0 0

void WError();
void O_Node();
#endif
