/***********************************************************************\ 
*									* 
*   File: scorpion/include/C/IDLwrite.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef IDLGEN_IDLWRITE_h
#define IDLGEN_IDLWRITE_h

#include <stdio.h>
#include <fcntl.h>
#define IDLLENGTHSTRINGEXTEND 20	/* extra characters for escape characters */
				/* in external representation */

static void IDLwrite_node();
static void IDLwrite_value();

#ifdef NeXT
#define TYPEOFMEMPARAM void
#endif
#ifndef NeXT
#define TYPEOFMEMPARAM char
#endif

TYPEOFMEMPARAM *malloc();

int IDLStringToExternal();
int IDLepoch = 1;
static int IDLwritefd,
  IDLstatus = TRUE,
  IDLindex,			/* used in putstr */
  IDLlength;			/* used in finishup */
#define IDLLABELLENGTH 12		/* maximum generated label is */
				/* 10^(IDLLABELLENGTH - 2) - 1 */
#define IDLSIZEBUFFER 1024
static char IDLbuffer[IDLSIZEBUFFER],
  *IDLbufferptr,
  *IDLbufferend = &(IDLbuffer[IDLSIZEBUFFER]); /* a constant:1 past the last character*/

#define IDLputchr(x) {  \
  *(IDLbufferptr++) = (x); \
  if (IDLbufferptr==IDLbufferend) { \
     if (IDLstatus) \
       IDLstatus = (write(IDLwritefd, IDLbuffer, IDLSIZEBUFFER)==IDLSIZEBUFFER); \
     IDLbufferptr = IDLbuffer; \
     } }
							
#define IDLputstr(x) for (IDLindex=0; (x)[IDLindex]!='\0'; IDLindex++) IDLputchr((x)[IDLindex])

#define IDLfinishup \
  if ((IDLstatus) && (IDLlength = IDLbufferptr - IDLbuffer) > 0) \
     IDLstatus = (write(IDLwritefd, IDLbuffer, IDLlength)==IDLlength)

static int IDLcurrentcount;	/* used to generate new labels */

static void IDLcheck_node();

static void IDLcheck_VALUE(this)
IDLVALUE this;
{
  IDLVALUE AnIDLVALUE;
  SEQIDLVALUE SIDLVALUE;

  switch (typeof(this)) {
  case KintegerDesc:
  case KrationalDesc:
  case KbooleanDesc:
  case KstringDesc:
    break;			/* do nothing with basic types */
  case KsetDesc:
    foreachinSEQIDLVALUE(this.VsetDesc->value, SIDLVALUE, AnIDLVALUE)
      IDLcheck_VALUE(AnIDLVALUE);
    break;
  case KsequenceDesc:
    foreachinSEQIDLVALUE(this.VsequenceDesc->value, SIDLVALUE, AnIDLVALUE)
	 IDLcheck_VALUE(AnIDLVALUE);
    break;
  case KnodeDesc:
    IDLcheck_node(this.VnodeDesc);
    break;
  }
}

static void IDLcheck_node(thisnode)
nodeDesc thisnode;
{
  attrDesc Anattribute;
  SEQattrDesc Sattributes;
  char *newlabel;

  if (thisnode->touched == IDLepoch) {
    if ((thisnode->label == NULL) || thisnode->label[0] == '\0') {
      newlabel = (char *)malloc((unsigned)IDLLABELLENGTH);
      newlabel[0] = 'L';
      (void)sprintf(newlabel+1,"%d",IDLcurrentcount++);
      thisnode->label = newlabel;
    }
  }
  else {
    thisnode->touched = IDLepoch;
    foreachinSEQattrDesc(thisnode->attributes, Sattributes, Anattribute)
      IDLcheck_VALUE(Anattribute->value);
  }
}

int IDLwrite(thisfd, root)
int thisfd;
nodeDesc root;
{
  IDLwritefd = thisfd;
  IDLcurrentcount = 1;
  IDLbufferptr = IDLbuffer;
  IDLepoch++;
  IDLcheck_node(root);		/* check that labels are present */
  if (!IDLStructureName[0])
    IDLputstr("-- output from idlwrite\n")
  else {
    IDLputstr("-- structure ");
    IDLputstr(IDLStructureName);
    IDLputchr('\n');
  }
  IDLepoch++;
  IDLwrite_node(root);
  IDLputstr("#\n");
  IDLfinishup;
  if (IDLstatus) return(0);
  else return(-1);
}

static void IDLwrite_node(thisnode)
nodeDesc thisnode;
{
  attrDesc Anattribute;
  SEQattrDesc Sattributes;
   
  if (thisnode->touched==IDLepoch) {
    IDLputstr(thisnode->label);
    IDLputchr('^');
  }
  else {			/* first time to print node */
    thisnode->touched = IDLepoch;
    if (strcmp(thisnode->label, "") != 0) {
      IDLputstr(thisnode->label);
      IDLputchr(':');
    }
    IDLputstr(thisnode->name);
    if (! emptySEQattrDesc(thisnode->attributes))
      {IDLputchr('[');
       foreachinSEQattrDesc(thisnode->attributes, Sattributes, Anattribute) {
	 IDLputstr(Anattribute->name);
	 IDLputchr(' ');
	 IDLwrite_value(Anattribute->value);
	 IDLputstr(";\n");
       }
       IDLputchr(']');
     }
  }
}

static void IDLwrite_value(this)
IDLVALUE this;
{
  IDLVALUE AnIDLVALUE;
  SEQIDLVALUE SIDLVALUE;
  int newlength;
  char *stringbuffer;
  char numbuffer[256];
  
  switch (typeof(this)) {
  case KintegerDesc:
    (void)IDLlongToExternal((long)this.VintegerDesc->value,numbuffer,256);
    IDLputstr(numbuffer);
    break;
  case KrationalDesc:
    (void)IDLdoubleToExternal((double)this.VrationalDesc->value,numbuffer,256,10);
    IDLputstr(numbuffer);
    break;
  case KbooleanDesc:
    if (this.VbooleanDesc->value)
      IDLputstr("TRUE")
    else IDLputstr("FALSE");
    break;
  case KstringDesc:
    newlength = strlen (this.VstringDesc->value) + 1 + IDLLENGTHSTRINGEXTEND;
    stringbuffer = (char *)malloc((unsigned)newlength);
    newlength = IDLStringToExternal(this.VstringDesc->value, stringbuffer, newlength);
    if (newlength != 0) {
      free((TYPEOFMEMPARAM *)stringbuffer);
      stringbuffer = (char *)malloc((unsigned)newlength);	/* try again, with bigger buffer */
      newlength = IDLStringToExternal(this.VstringDesc->value, stringbuffer, newlength);
      if (newlength != 0) {
	IDLstatus = -1;
	stringbuffer[0] = '\0';
      }
    }
    IDLputstr(stringbuffer);
    free((TYPEOFMEMPARAM *)stringbuffer);
    break;
  case KsetDesc:
    IDLputchr('{');
    foreachinSEQIDLVALUE(this.VsetDesc->value, SIDLVALUE, AnIDLVALUE) {
      IDLwrite_value(AnIDLVALUE);
      IDLputchr('\n');
    };
    IDLputchr('}');
    break;
  case KsequenceDesc:
    IDLputchr('<');
    foreachinSEQIDLVALUE(this.VsequenceDesc->value, SIDLVALUE, AnIDLVALUE) {
      IDLwrite_value(AnIDLVALUE);
      IDLputchr('\n');
    };
    IDLputchr('>');
    break;
  case KnodeDesc:
    IDLwrite_node(this.VnodeDesc);
    break;
  }
}
#endif
