/***********************************************************************\ 
*									* 
*   File: scorpion/include/C/IDLread.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef IDLCINC_IDLREAD_c
#define IDLCINC_IDLREAD_c
#include <stdio.h>
#include <ctype.h>
#ifdef NeXT
#define TYPEOFMEMPARAM void
#define TYPEOFFREEMEM void
#endif
#ifndef NeXT
#define TYPEOFMEMPARAM char
#define TYPEOFFREEMEM int
#endif
extern char IDLyytext[];
TYPEOFFREEMEM free();


/* globals for parser */
static nodeDesc 	IDLroot_node;
static SEQattrDesc	IDLattrlabelrefs; /* sequence of unresolved attributes */
static SEQIDLVALUE	IDLsetlabelrefs; /* sequence of sets containing unresolved elements */
static SEQIDLVALUE	IDLseqlabelrefs; /* sequence of sequences containing */
				/* unresolved elements */
static int IDLinputfiledesc=0;
static int IDLlineNumber;
static int IDLCharPos;
static String IDLref_indicator_name;

static int IDLinit_hashtable();
void exit();
TYPEOFMEMPARAM *malloc(), *realloc();

nodeDesc
IDLread(inpfd)
int inpfd;
{
        IDLinputfiledesc = inpfd;
	IDLreaderror[0] = IDLStructureName[0] = '\0';
	initializeSEQattrDesc(IDLattrlabelrefs);
	initializeSEQIDLVALUE(IDLsetlabelrefs);
	initializeSEQIDLVALUE(IDLseqlabelrefs);
	IDLref_indicator_name = NewString("_IDL_REF_INDICATOR");
	IDLinit_hashtable();
	IDLlineNumber = 1;
	IDLCharPos = 0;

	/* IDLyyparse changed to accept input from inpfd */
	if (!IDLyyparse()) {
		return IDLroot_node;
	}
	else
	{
	 	return NULL;
	}
}
typedef nodeDesc IDLtree_entry;

typedef struct IDLRnode * IDLnode;

/* Sets and Sequences */
typedef struct IDLtree_tag{
        struct tree_tag *next;
        nodeDesc value;
} *IDLSEQtree_entry;

# define appendrearIDLSEQtree_entry(tree_entryseq,tree_entryvalue) tree_entryseq=\
		(IDLSEQtree_entry)IDLListAddRear((pGenList)tree_entryseq,(int)tree_entryvalue)
# define retrievefirstIDLSEQtree_entry(tree_entryseq, tree_entryvalue)\
 		tree_entryvalue = (IDLtree_entry)IDLListRetrieveFirst((pGenList)tree_entryseq)

struct IDLRnode { IDLnodeHeader IDLhidden;
    IDLnode right;
    IDLnode left;
    IDLSEQtree_entry entries;
    String key;
};
/* tree.c  Combination of :
   hash_defs.h, hash.c, insert_tree.c, find_tree.c, init_tree.c, 
   walk_tree.c tree_utils.c 
*/

IDLnode IDLInode(/* IDLnode anode */	);

#define IDLNnode node_allocate()

IDLnode
node_allocate ()
{
 IDLnode anode;

 anode = (IDLnode) malloc ((unsigned)sizeof (struct IDLRnode));
 if (anode == NULL)
   {
    (void)(void)fprintf (stderr,"Memory error when allocating node\n");
    exit(1);
   }
 return (IDLInode(anode));
} 

/* hash_defs.h */
/* definitions for functions */

static IDLnode IDLfind_tree(/* IDLnode treenode, String key */	);
static void IDLwalk_tree_in(/* IDLnode treenode, void (*action) () */	);
static void IDLwalk_tree_post(/* IDLnode treenode, void (*action) () */	);
static void IDLwalk_tree_pre(/* IDLnode treenode, void (*action) () */	);
static IDLnode IDLinsert_tree(/* IDLnode treenode, String key, IDLtree_entry newentry */	);


/* the hash table definition */
typedef struct IDLHASHTABLE {
	int htabsiz;
 	IDLnode *htab; 
} *IDLHASHTABLE;

static IDLHASHTABLE IDLNewHashTable(/* int size */);
static int IDLKeyHash(/* char *S */);
static IDLnode IDLInsertHashTable(/* HASHTABLE HashTable, String key, tree_entry newentry */);
static void IDLInitHashTable(/* HASHTABLE HashTable */);
static void IDLPrintHashTable(/*  HASHTABLE HashTable, void (*out_tree() */);

/* hash.c */
/* Generic Hash Table functions: each index of hash table is a tree */
/*	user must define type 'entry' for application               */

static int IDLKeyHash();			/* default hash function */
static int  (*IDLHashFunc) () = IDLKeyHash; 	/* hash function pointer */


/* create and return a new hash table */
static IDLHASHTABLE IDLNewHashTable(size)
int size;
{
	IDLHASHTABLE ret_ht;

	ret_ht = (IDLHASHTABLE)GetHeap(sizeof(struct IDLHASHTABLE));
	ret_ht->htab = (IDLnode *)GetHeap(size * sizeof(IDLnode));

	ret_ht->htabsiz = size;
	IDLInitHashTable(ret_ht);
	return(ret_ht);
}

static IDLSetHashFunction(new_hfn)
int  (*new_hfn) ();
{
	IDLHashFunc = new_hfn; 	
}

/* hash a string for the hash table --default hash function */
static int IDLKeyHash(S, htabsiz)
register char *S;
int htabsiz;
{	register int i;
	for (i=0 ; *S ; i += (*S) , S++);
	return(i % (htabsiz-1));
}

/* add an entry to the HashTable and return the tree node*/
static IDLnode IDLInsertHashTable(HashTable, key, newentry, keycmp_fn)
IDLHASHTABLE HashTable;
String key;
IDLtree_entry newentry;
int  (*keycmp_fn) ();
{
	int index;

	index = IDLHashFunc(key, HashTable->htabsiz) % HashTable->htabsiz;

	/* first node for index so create the root node */
	if (HashTable->htab[index] == NULL) {
		HashTable->htab[index] = IDLNnode;
		HashTable->htab[index]->key = key;
	}

	return(IDLinsert_tree(HashTable->htab[index], key, newentry, keycmp_fn));
}

/* find an entry in the HashTable and return the tree node*/
static IDLnode IDLFindHashTable(HashTable, key, keycmp_fn)
IDLHASHTABLE HashTable;
String key;
int  (*keycmp_fn) ();
{
	int index;

	index = IDLHashFunc(key, HashTable->htabsiz) % HashTable->htabsiz;

	/* first node for index so not found */
	if (HashTable->htab[index] == NULL) {
		return(NULL);
	}

	return(IDLfind_tree(HashTable->htab[index], key, keycmp_fn));
}

static void IDLInitHashTable(HashTable)
IDLHASHTABLE HashTable;
{
	int i;

	for (i=0; i<HashTable->htabsiz; i++) {
	    	HashTable->htab[i] = NULL;
	}
}

/* insert_tree.c */

static IDLnode IDLinsert_tree(treenode, key, newentry, keycmp_fn)
IDLnode treenode;
String key;
IDLtree_entry newentry;
int  (*keycmp_fn) ();
{
	int cmp;
	cmp = keycmp_fn(key, treenode->key);

	if (cmp == 0) {
		appendrearIDLSEQtree_entry(treenode->entries, newentry);
		return(treenode);
	}
	else if (cmp < 0) {
		if (treenode->left == NULL) { /* add here */
			treenode->left = IDLNnode;
			treenode->left->key = key;
			appendrearIDLSEQtree_entry(treenode->left->entries,
					  newentry);
			return(treenode->left);
		}
		else return(IDLinsert_tree(treenode->left, key, newentry, 
					keycmp_fn));
	}
	else {
		if (treenode->right == NULL) { /* add here */
			treenode->right = IDLNnode;
			treenode->right->key = key;
			appendrearIDLSEQtree_entry(treenode->right->entries,
					  newentry);
			return(treenode->right);
		}
		else return(IDLinsert_tree(treenode->right, key, newentry, 
					keycmp_fn));
	}
}


/* find_tree.c */

static IDLnode IDLfind_tree(treenode, key, keycmp_fn)
IDLnode treenode;
String key;
int  (*keycmp_fn) ();
{
	int cmp;
	cmp = keycmp_fn(key, treenode->key);

	if (cmp == 0) {
		return(treenode);
	}
	else if (cmp < 0) {
		if (treenode->left == NULL) { /* not found */
			return(NULL);
		}
		else return(IDLfind_tree(treenode->left, key, keycmp_fn));
	}
	else {
		if (treenode->right == NULL) { /* not found */
			return(NULL);
		}
		else return(IDLfind_tree(treenode->right, key, keycmp_fn));
	}
}


/* init_tree.c */

IDLnode IDLInode(anode)
IDLnode anode;
{
	anode->left = NULL;
	anode->right = NULL;
	anode->entries = NULL;
	return(anode);
}

/* walk_tree.c */

/* walks in inorder */

static void IDLwalk_tree_in(treenode, action)
IDLnode treenode;
register void (*action) ();	/* Function to be called at each node */
{
	if (treenode->left != NULL)
		IDLwalk_tree_in(treenode->left, action);

	/* call action for this one */
	action(treenode);
	
	if (treenode->right != NULL)
		IDLwalk_tree_in(treenode->right, action);
}

/* walks in postorder */

static void IDLwalk_tree_post(treenode, action)
IDLnode treenode;
register void (*action) ();	/* Function to be called at each * node */
{
	if (treenode->left != NULL)
		IDLwalk_tree_post(treenode->left, action);

	if (treenode->right != NULL)
		IDLwalk_tree_post(treenode->right, action);

	/* call action for this one */
	action(treenode);
	
}

/* walks in preorder */

static void IDLwalk_tree_pre(treenode, action)
IDLnode treenode;
register void (*action) ();	/* Function to be called at each * node */
{
	/* call action for this one */
	action(treenode);
	
	if (treenode->left != NULL)
		IDLwalk_tree_pre(treenode->left, action);

	if (treenode->right != NULL)
		IDLwalk_tree_pre(treenode->right, action);
}


/* tree_utils.c */
#define IDLHTABSIZ 	203
static IDLHASHTABLE	IDLlabelhashtable;
static int		IDLLabelHashFunc();

static IDLinit_hashtable()
{

	IDLlabelhashtable = IDLNewHashTable(IDLHTABSIZ);
	IDLSetHashFunction(IDLLabelHashFunc);
}

static	int		IDLcmplabel();
static IDLinsert_hashtable(thenode)
nodeDesc thenode;
{

	(void)IDLInsertHashTable(IDLlabelhashtable, 
			      thenode->label,
			      thenode,
			      IDLcmplabel);
}

static nodeDesc IDLfind_label(label)
String label;
{
	IDLnode IDLFindHashTable();  /* HashTable, key, keycmp_fn */
	IDLnode found;
	nodeDesc ret_node;

	if (found = IDLFindHashTable(IDLlabelhashtable, label, IDLcmplabel)) {
		retrievefirstIDLSEQtree_entry(found->entries, ret_node);
		return(ret_node);
	}
	else return(NULL);
}

/* labels are of the form L{d}+ */
static int IDLLabelHashFunc(label)
String label;
{
	return(atoi(&label[1]));
}

static int IDLcmplabel(l1, l2)
String l1, l2;
{
	return(atoi(&l1[1]) - atoi(&l2[1]));
}


typedef struct IDLattr_name_tag 
{
  int linenumber,charpos;
  char *name;
} IDLATTR_NAME;


IDLVALUE IDLanIDLVALUE;
nodeDesc IDLanodeDesc;

/* returned by IDLVALUE */
/* attributes whose values are references are changed into
   string values and appended on IDLattrlabelrefs.

   set (and seq) elements that are references are changed into
   IDLnode values with a node name of IDLref_indicator_name
*/
typedef struct
{
  int isname;		/* boolean */
  union { IDLVALUE value;
	  String name; } value;
} IDLnewIDLVALUE;

/* data stack size */
#define IDLYYMAXDEPTH 50000

unsigned int IDLlinechartemp1,IDLlinechartemp2;
/*#define IDLLINECHARPOS(linenum,charpos) \
  (((IDLlinechartemp1=(linenum<<12)) >= 1048575 ? 1048575 : IDLlinechartemp1) |\
   ((IDLlinechartemp2=(charpos&0xfff)) >= 4095 ? 4095 : IDLlinechartemp2))
*/
#define IDLLINECHARPOS(linenum,charpos) \
  ((((IDLlinechartemp1=linenum)>=0xfffff)?0xfffff:IDLlinechartemp1)<<12 |\
   (((IDLlinechartemp2=charpos)>=0xfff)?0xfff:IDLlinechartemp2))

#ifdef DEBUG
#define IDLReduce(lhs)	(void)(void)fprintf(stderr, "Reduce to %s\n", lhs)
#else
#define IDLReduce(lhs)
#endif

typedef union {
String	     	name;
stringDesc   	strval;
booleanDesc  	boolval;
rationalDesc 	ratval;
integerDesc  	intval;
nodeDesc     	VnodeDesc;
SEQattrDesc  	VSEQattrDesc;
attrDesc     	VattrDesc;
IDLnewIDLVALUE	VIDLVALUE;
setDesc		VsetDesc;
sequenceDesc	VsequenceDesc;
SEQIDLVALUE	VSEQIDLVALUE;
IDLATTR_NAME    *attr_name_type;
} IDLYYSTYPE;
# define IDLLPAREN 257
# define IDLRPAREN 258
# define IDLLBRACKET 259
# define IDLRBRACKET 260
# define IDLLBRACE 261
# define IDLRBRACE 262
# define IDLLESS 263
# define IDLGREATER 264
# define IDLSEMICOLON 265
# define IDLEND 266
# define IDLSTRING 267
# define IDLRATIONAL 268
# define IDLINTEGER 269
# define IDLBOOLEAN 270
# define IDLNAME 271
# define IDLLABELREF 272
# define IDLLABEL 273
#define IDLyyclearin IDLyychar = -1
#define IDLyyerrok IDLyyerrflag = 0


#ifndef IDLYYMAXDEPTH
#define IDLYYMAXDEPTH 150
#endif
IDLYYSTYPE IDLyylval, IDLyyval;
# define IDLYYERRCODE 256


static 
IDLmatch_references()
{
	SEQattrDesc 	Sad;
	attrDesc    	AnattrDesc;
	SEQIDLVALUE 	new_sequence, new_set;
    	IDLVALUE    	anewIDLVALUE;
    	IDLVALUE    	AnIDLVALUE, ASetIDLVALUE, ASeqIDLVALUE;
	SEQIDLVALUE 	SSEQIDLVALUE, SIDLVALUE;
	nodeDesc    	found;
	nodeDesc    	IDLfind_label();

				/* resolve labels as attribute values */
	foreachinSEQattrDesc(IDLattrlabelrefs, Sad, AnattrDesc) {
	  if (found=IDLfind_label(AnattrDesc->value.VstringDesc->value)) {
	    AnattrDesc->value.VnodeDesc = found;
	  }
	  else {
	    (void)(void)fprintf(stderr, "no matching node for label %s\n",
		    AnattrDesc->value.VstringDesc->value);
	  }
	}

				/* resolve labels in sets */
				/* assume that sets contain no duplicates */
	foreachinSEQIDLVALUE(IDLsetlabelrefs, SIDLVALUE, ASetIDLVALUE) {
	  initializeSEQIDLVALUE(new_set);
	  foreachinSEQIDLVALUE(ASetIDLVALUE.VsetDesc->value, SSEQIDLVALUE, AnIDLVALUE) {
	    if (typeof(AnIDLVALUE)==KnodeDesc) {
	      if (AnIDLVALUE.VnodeDesc->name == IDLref_indicator_name) {
				/* found a reference */
		if (found=IDLfind_label(AnIDLVALUE.VnodeDesc->label)) {
		  anewIDLVALUE.VnodeDesc = found;
		  appendrearSEQIDLVALUE(new_set, anewIDLVALUE);
		}
		else {
		  (void)(void)fprintf(stderr, "no matching node for label %s\n",
			  AnIDLVALUE.VnodeDesc->label);
		}
	      }
	      else appendrearSEQIDLVALUE(new_set, AnIDLVALUE);
	    }
	    else appendrearSEQIDLVALUE(new_set, AnIDLVALUE);
	  }
/*	  foreachinSEQIDLVALUE(ASetIDLVALUE.VsetDesc->value, SSEQIDLVALUE, AnIDLVALUE) {
	    removeSEQIDLVALUE(ASetIDLVALUE.VsetDesc->value, AnIDLVALUE);
	  }
*/
	  ASetIDLVALUE.VsetDesc->value = new_set;
	  }

				/* resolve labels in sequences */
	foreachinSEQIDLVALUE(IDLseqlabelrefs, SIDLVALUE, ASeqIDLVALUE) {
	  initializeSEQIDLVALUE(new_sequence);
	  foreachinSEQIDLVALUE(ASeqIDLVALUE.VsequenceDesc->value, SSEQIDLVALUE, AnIDLVALUE) {
	    if (typeof(AnIDLVALUE)==KnodeDesc) {
	      if (AnIDLVALUE.VnodeDesc->name == IDLref_indicator_name) {
				/* found a reference */
		if (found=IDLfind_label(AnIDLVALUE.VnodeDesc->label)) {
		  anewIDLVALUE.VnodeDesc = found;
		    appendrearSEQIDLVALUE(new_sequence, anewIDLVALUE);
		}
		else {
		  (void)(void)fprintf(stderr, "no matching node for label %s\n",
			  AnIDLVALUE.VnodeDesc->label);
		}
	      }
	      else appendrearSEQIDLVALUE(new_sequence, AnIDLVALUE);
	    }
	    else appendrearSEQIDLVALUE(new_sequence, AnIDLVALUE);
	  }
/*	  foreachinSEQIDLVALUE(ASeqIDLVALUE.VsetDesc->value, SSEQIDLVALUE, AnIDLVALUE) {
	    removeSEQIDLVALUE(ASeqIDLVALUE.VsequenceDesc->value, AnIDLVALUE);
	  }
*/
	  ASeqIDLVALUE.VsequenceDesc->value = new_sequence;
	}
}

IDLyyerror(s)
char *s;
{
	if (!strcmp (s,"yacc stack overflow"))
	  (void)(void)sprintf (IDLreaderror,"IDLread: parser stack overflow on line %-d: Increase IDLYYMAXDEPTH in IDLread.c\n",s,IDLlineNumber);
	else
	  (void)(void)sprintf (IDLreaderror,"IDLread: %s on line %-d\n",s,IDLlineNumber);
	(void)fputs (IDLreaderror,stderr);
        (void)fflush (stderr);
}
int IDLyyexca[] ={
-1, 0,
	271, 32,
	-2, 2,
-1, 1,
	0, -1,
	-2, 0,
	};
# define IDLYYNPROD 33
# define IDLYYLAST 67
int IDLyyact[]={

    29,    33,    30,    40,     5,    31,    24,    22,    21,    23,
    10,    28,     5,    29,    38,    30,    17,     5,     9,    24,
    22,    21,    23,     8,    28,     5,    29,    15,    30,    20,
     6,    13,    24,    22,    21,    23,    18,    28,     5,    14,
     7,    19,    17,    27,     2,     1,    16,    34,    36,    26,
    25,    11,    12,     4,     3,     0,     0,     0,     0,    32,
    35,    37,     0,     0,    39,     0,    41 };
int IDLyypact[]={

  -269, -1000, -1000,  -236,  -253, -1000, -1000,  -256,  -229, -1000,
 -1000, -1000,  -224, -1000, -1000, -1000,  -235, -1000, -1000,  -255,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,  -248, -1000,  -261, -1000, -1000, -1000,
 -1000, -1000 };
int IDLyypgo[]={

     0,    43,    54,    53,    52,    39,    29,    50,    49,    48,
    47,    46,    45,    40,    30 };
int IDLyyr1[]={

     0,    12,    12,    13,    13,     1,     1,     1,     1,     2,
     3,     3,     4,     4,     4,     4,     5,    11,     6,     6,
     6,     6,     6,     6,     6,     6,     7,     8,    10,    10,
     9,     9,    14 };
int IDLyyr2[]={

     0,     7,     1,     5,     1,     9,    11,     7,     3,     5,
     3,     3,     7,     3,     7,     3,     5,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     7,     7,     5,     3,
     5,     3,     1 };
int IDLyychk[]={

 -1000,   -12,    -1,    -2,    -3,   273,   -14,   -13,   259,   271,
   266,    -1,    -4,   260,    -5,   256,   -11,   271,   260,   265,
    -6,   269,   268,   270,   267,    -7,    -8,    -1,   272,   261,
   263,   260,    -5,   256,   -10,   -14,    -9,   -14,   262,    -6,
   264,    -6 };
int IDLyydef[]={

    -2,    -2,     4,     8,     0,    10,    11,    32,     0,     9,
     1,     3,     0,     7,    13,    15,    32,    17,     5,     0,
    16,    18,    19,    20,    21,    22,    23,    24,    25,    32,
    32,     6,    12,    14,    32,    29,    32,    31,    26,    28,
    27,    30 };
typedef struct { char *t_name; int t_val; } IDLyytoktype;
#ifndef IDLYYDEBUG
#	define IDLYYDEBUG	0	/* don't allow debugging */
#endif

#if IDLYYDEBUG

IDLyytoktype IDLyytoks[] =
{
	"IDLLPAREN",	257,
	"IDLRPAREN",	258,
	"IDLLBRACKET",	259,
	"IDLRBRACKET",	260,
	"IDLLBRACE",	261,
	"IDLRBRACE",	262,
	"IDLLESS",	263,
	"IDLGREATER",	264,
	"IDLSEMICOLON",	265,
	"IDLEND",	266,
	"IDLSTRING",	267,
	"IDLRATIONAL",	268,
	"IDLINTEGER",	269,
	"IDLBOOLEAN",	270,
	"IDLNAME",	271,
	"IDLLABELREF",	272,
	"IDLLABEL",	273,
	"-unknown-",	-1	/* ends search */
};

char * IDLyyreds[] =
{
	"-no such reduction-",
	"IDL_root : IDL_nodeDesc IDL_nodeDescSeq IDLEND",
	"IDL_root : /* empty */",
	"IDL_nodeDescSeq : IDL_nodeDescSeq IDL_nodeDesc",
	"IDL_nodeDescSeq : /* empty */",
	"IDL_nodeDesc : IDL_nodeName IDLLBRACKET IDL_attrseq IDLRBRACKET",
	"IDL_nodeDesc : IDL_nodeName IDLLBRACKET IDL_attrseq IDLSEMICOLON IDLRBRACKET",
	"IDL_nodeDesc : IDL_nodeName IDLLBRACKET IDLRBRACKET",
	"IDL_nodeDesc : IDL_nodeName",
	"IDL_nodeName : IDL_label IDLNAME",
	"IDL_label : IDLLABEL",
	"IDL_label : IDLNothing",
	"IDL_attrseq : IDL_attrseq IDLSEMICOLON IDL_attrDesc",
	"IDL_attrseq : IDL_attrDesc",
	"IDL_attrseq : IDL_attrseq IDLSEMICOLON error",
	"IDL_attrseq : error",
	"IDL_attrDesc : IDL_attrname IDL_IDLVALUE",
	"IDL_attrname : IDLNAME",
	"IDL_IDLVALUE : IDLINTEGER",
	"IDL_IDLVALUE : IDLRATIONAL",
	"IDL_IDLVALUE : IDLBOOLEAN",
	"IDL_IDLVALUE : IDLSTRING",
	"IDL_IDLVALUE : IDL_setDesc",
	"IDL_IDLVALUE : IDL_seqDesc",
	"IDL_IDLVALUE : IDL_nodeDesc",
	"IDL_IDLVALUE : IDLLABELREF",
	"IDL_setDesc : IDLLBRACE IDL_IDLVALUEset IDLRBRACE",
	"IDL_seqDesc : IDLLESS IDL_IDLVALUEseq IDLGREATER",
	"IDL_IDLVALUEset : IDL_IDLVALUEset IDL_IDLVALUE",
	"IDL_IDLVALUEset : IDLNothing",
	"IDL_IDLVALUEseq : IDL_IDLVALUEseq IDL_IDLVALUE",
	"IDL_IDLVALUEseq : IDLNothing",
	"IDLNothing : /* empty */",
};
#endif /* IDLYYDEBUG */
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define IDLYYERROR		goto IDLyyerrlab
#define IDLYYACCEPT	{ free((TYPEOFMEMPARAM *)IDLyys); free((TYPEOFMEMPARAM *)IDLyyv); return(0); }
#define IDLYYABORT		{ free((TYPEOFMEMPARAM *)IDLyys); free((TYPEOFMEMPARAM *)IDLyyv); return(1); }
#define IDLYYBACKUP( newtoken, newvalue )\
{\
	if ( IDLyychar >= 0 || ( IDLyyr2[ IDLyytmp ] >> 1 ) != 1 )\
	{\
		IDLyyerror( "syntax error - cannot backup" );\
		goto IDLyyerrlab;\
	}\
	IDLyychar = newtoken;\
	IDLyystate = *IDLyyps;\
	IDLyylval = newvalue;\
	goto IDLyynewstate;\
}
#define IDLYYRECOVERING()	(!!IDLyyerrflag)
#ifndef IDLYYDEBUG
#	define IDLYYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int IDLyydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define IDLYYFLAG		(-1000)

/*
** static variables used by the parser
*/
static IDLYYSTYPE *IDLyyv;			/* value stack */
static int *IDLyys;			/* state stack */

static IDLYYSTYPE *IDLyypv;			/* top of value stack */
static int *IDLyyps;			/* top of state stack */

static int IDLyystate;			/* current state */
static int IDLyytmp;			/* extra var (lasts between blocks) */

int IDLyynerrs;			/* number of errors */

int IDLyyerrflag;			/* error recovery flag */
int IDLyychar;			/* current input token number */


/*
** IDLyyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
IDLyyparse()
{
	register IDLYYSTYPE *IDLyypvt;	/* top of value stack for $vars */
	unsigned IDLyymaxdepth = IDLYYMAXDEPTH;

	/*
	** Initialize externals - IDLyyparse may be called more than once
	*/
	IDLyyv = (IDLYYSTYPE*)malloc(IDLyymaxdepth*sizeof(IDLYYSTYPE));
	IDLyys = (int*)malloc(IDLyymaxdepth*sizeof(int));
	if (!IDLyyv || !IDLyys)
	{
		IDLyyerror( "out of memory" );
		return(1);
	}
	IDLyypv = &IDLyyv[-1];
	IDLyyps = &IDLyys[-1];
	IDLyystate = 0;
	IDLyytmp = 0;
	IDLyynerrs = 0;
	IDLyyerrflag = 0;
	IDLyychar = -1;

	goto IDLyystack;
	{
		register IDLYYSTYPE *IDLyy_pv;	/* top of value stack */
		register int *IDLyy_ps;		/* top of state stack */
		register int IDLyy_state;		/* current state */
		register int  IDLyy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if IDLYYBACKUP was called.
		*/
	IDLyynewstate:
		IDLyy_pv = IDLyypv;
		IDLyy_ps = IDLyyps;
		IDLyy_state = IDLyystate;
		goto IDLyy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	IDLyystack:
		IDLyy_pv = IDLyypv;
		IDLyy_ps = IDLyyps;
		IDLyy_state = IDLyystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	IDLyy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if IDLYYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( IDLyydebug )
		{
			register int IDLyy_i;

			(void)printf( "State %d, token ", IDLyy_state );
			if ( IDLyychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( IDLyychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( IDLyy_i = 0; IDLyytoks[IDLyy_i].t_val >= 0;
					IDLyy_i++ )
				{
					if ( IDLyytoks[IDLyy_i].t_val == IDLyychar )
						break;
				}
				(void)printf( "%s\n", IDLyytoks[IDLyy_i].t_name );
			}
		}
#endif /* IDLYYDEBUG */
		if ( ++IDLyy_ps >= &IDLyys[ IDLyymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int IDLyyps_index = (IDLyy_ps - IDLyys);
			int IDLyypv_index = (IDLyy_pv - IDLyyv);
			int IDLyypvt_index = (IDLyypvt - IDLyyv);
			IDLyymaxdepth += IDLYYMAXDEPTH;
			IDLyyv = (IDLYYSTYPE*)realloc((char*)IDLyyv,
				IDLyymaxdepth * sizeof(IDLYYSTYPE));
			IDLyys = (int*)realloc((char*)IDLyys,
				IDLyymaxdepth * sizeof(int));
			if (!IDLyyv || !IDLyys)
			{
				IDLyyerror( "yacc stack overflow" );
				return(1);
			}
			IDLyy_ps = IDLyys + IDLyyps_index;
			IDLyy_pv = IDLyyv + IDLyypv_index;
			IDLyypvt = IDLyyv + IDLyypvt_index;
		}
		*IDLyy_ps = IDLyy_state;
		*++IDLyy_pv = IDLyyval;

		/*
		** we have a new state - find out what to do
		*/
	IDLyy_newstate:
		if ( ( IDLyy_n = IDLyypact[ IDLyy_state ] ) <= IDLYYFLAG )
			goto IDLyydefault;		/* simple state */
#if IDLYYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		IDLyytmp = IDLyychar < 0;
#endif
		if ( ( IDLyychar < 0 ) && ( ( IDLyychar = IDLyylex() ) < 0 ) )
			IDLyychar = 0;		/* reached EOF */
#if IDLYYDEBUG
		if ( IDLyydebug && IDLyytmp )
		{
			register int IDLyy_i;

			(void)printf( "Received token " );
			if ( IDLyychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( IDLyychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( IDLyy_i = 0; IDLyytoks[IDLyy_i].t_val >= 0;
					IDLyy_i++ )
				{
					if ( IDLyytoks[IDLyy_i].t_val == IDLyychar )
						break;
				}
				(void)printf( "%s\n", IDLyytoks[IDLyy_i].t_name );
			}
		}
#endif /* IDLYYDEBUG */
		if ( ( ( IDLyy_n += IDLyychar ) < 0 ) || ( IDLyy_n >= IDLYYLAST ) )
			goto IDLyydefault;
		if ( IDLyychk[ IDLyy_n = IDLyyact[ IDLyy_n ] ] == IDLyychar )	/*valid shift*/
		{
			IDLyychar = -1;
			IDLyyval = IDLyylval;
			IDLyy_state = IDLyy_n;
			if ( IDLyyerrflag > 0 )
				IDLyyerrflag--;
			goto IDLyy_stack;
		}

	IDLyydefault:
		if ( ( IDLyy_n = IDLyydef[ IDLyy_state ] ) == -2 )
		{
#if IDLYYDEBUG
			IDLyytmp = IDLyychar < 0;
#endif
			if ( ( IDLyychar < 0 ) && ( ( IDLyychar = IDLyylex() ) < 0 ) )
				IDLyychar = 0;		/* reached EOF */
#if IDLYYDEBUG
			if ( IDLyydebug && IDLyytmp )
			{
				register int IDLyy_i;

				(void)printf( "Received token " );
				if ( IDLyychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( IDLyychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( IDLyy_i = 0;
						IDLyytoks[IDLyy_i].t_val >= 0;
						IDLyy_i++ )
					{
						if ( IDLyytoks[IDLyy_i].t_val
							== IDLyychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", IDLyytoks[IDLyy_i].t_name );
				}
			}
#endif /* IDLYYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *IDLyyxi = IDLyyexca;

				while ( ( *IDLyyxi != -1 ) ||
					( IDLyyxi[1] != IDLyy_state ) )
				{
					IDLyyxi += 2;
				}
				while ( ( *(IDLyyxi += 2) >= 0 ) &&
					( *IDLyyxi != IDLyychar ) )
					;
				if ( ( IDLyy_n = IDLyyxi[1] ) < 0 )
					IDLYYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( IDLyy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( IDLyyerrflag )
			{
			case 0:		/* new error */
				IDLyyerror( "syntax error" );
				goto skip_init;
			IDLyyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				IDLyy_pv = IDLyypv;
				IDLyy_ps = IDLyyps;
				IDLyy_state = IDLyystate;
				IDLyynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				IDLyyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( IDLyy_ps >= IDLyys )
				{
					IDLyy_n = IDLyypact[ *IDLyy_ps ] + IDLYYERRCODE;
					if ( IDLyy_n >= 0 && IDLyy_n < IDLYYLAST &&
						IDLyychk[IDLyyact[IDLyy_n]] == IDLYYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						IDLyy_state = IDLyyact[ IDLyy_n ];
						goto IDLyy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if IDLYYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( IDLyydebug )
						(void)printf( _POP_, *IDLyy_ps,
							IDLyy_ps[-1] );
#	undef _POP_
#endif
					IDLyy_ps--;
					IDLyy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				IDLYYABORT;
			case 3:		/* no shift yet; eat a token */
#if IDLYYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( IDLyydebug )
				{
					register int IDLyy_i;

					(void)printf( "Error recovery discards " );
					if ( IDLyychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( IDLyychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( IDLyy_i = 0;
							IDLyytoks[IDLyy_i].t_val >= 0;
							IDLyy_i++ )
						{
							if ( IDLyytoks[IDLyy_i].t_val
								== IDLyychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							IDLyytoks[IDLyy_i].t_name );
					}
				}
#endif /* IDLYYDEBUG */
				if ( IDLyychar == 0 )	/* reached EOF. quit */
					IDLYYABORT;
				IDLyychar = -1;
				goto IDLyy_newstate;
			}
		}/* end if ( IDLyy_n == 0 ) */
		/*
		** reduction by production IDLyy_n
		** put stack tops, etc. so things right after switch
		*/
#if IDLYYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( IDLyydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				IDLyy_n, IDLyyreds[ IDLyy_n ] );
#endif
		IDLyytmp = IDLyy_n;			/* value to switch over */
		IDLyypvt = IDLyy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using IDLyy_state here as temporary
		** register variable, but why not, if it works...
		** If IDLyyr2[ IDLyy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto IDLyy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int IDLyy_len = IDLyyr2[ IDLyy_n ];

			if ( !( IDLyy_len & 01 ) )
			{
				IDLyy_len >>= 1;
				IDLyyval = ( IDLyy_pv -= IDLyy_len )[1];	/* $$ = $1 */
				IDLyy_state = IDLyypgo[ IDLyy_n = IDLyyr1[ IDLyy_n ] ] +
					*( IDLyy_ps -= IDLyy_len ) + 1;
				if ( IDLyy_state >= IDLYYLAST ||
					IDLyychk[ IDLyy_state =
					IDLyyact[ IDLyy_state ] ] != -IDLyy_n )
				{
					IDLyy_state = IDLyyact[ IDLyypgo[ IDLyy_n ] ];
				}
				goto IDLyy_stack;
			}
			IDLyy_len >>= 1;
			IDLyyval = ( IDLyy_pv -= IDLyy_len )[1];	/* $$ = $1 */
			IDLyy_state = IDLyypgo[ IDLyy_n = IDLyyr1[ IDLyy_n ] ] +
				*( IDLyy_ps -= IDLyy_len ) + 1;
			if ( IDLyy_state >= IDLYYLAST ||
				IDLyychk[ IDLyy_state = IDLyyact[ IDLyy_state ] ] != -IDLyy_n )
			{
				IDLyy_state = IDLyyact[ IDLyypgo[ IDLyy_n ] ];
			}
		}
					/* save until reenter driver code */
		IDLyystate = IDLyy_state;
		IDLyyps = IDLyy_ps;
		IDLyypv = IDLyy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( IDLyytmp )
	{
		
case 1:
{
				 IDLReduce("IDL_root");
				 IDLroot_node = IDLyypvt[-2].VnodeDesc;
				 /* match all references to the node */
				 IDLmatch_references();
				 IDLYYACCEPT;
				} break;
case 2:
{
				 IDLReduce("_root");
				 IDLroot_node = NULL;
				 IDLYYACCEPT;
				} break;
case 3:
{
				 IDLReduce("IDL_nodeDescSeq");
				} break;
case 4:
{
				 IDLReduce("IDL_nodeDescSeq");
				} break;
case 5:
{
				 IDLReduce("IDL_nodeDesc");
				 IDLyyval.VnodeDesc = IDLyypvt[-3].VnodeDesc;
				 IDLyyval.VnodeDesc->attributes = IDLyypvt[-1].VSEQattrDesc;
				} break;
case 6:
{
				 IDLReduce("IDL_nodeDesc");
				 IDLyyval.VnodeDesc = IDLyypvt[-4].VnodeDesc;
				 IDLyyval.VnodeDesc->attributes = IDLyypvt[-2].VSEQattrDesc;
				} break;
case 7:
{
				 IDLReduce("IDL_nodeDesc");
				 IDLyyval.VnodeDesc = IDLyypvt[-2].VnodeDesc;
				} break;
case 8:
{
				 IDLReduce("IDL_nodeDesc");
				 IDLyyval.VnodeDesc = IDLyypvt[-0].VnodeDesc;
				} break;
case 9:
{
				 IDLReduce("IDL_nodeName");
				 IDLyyval.VnodeDesc = NnodeDesc;
				 IDLyyval.VnodeDesc->srcpos = IDLLINECHARPOS(IDLlineNumber,IDLCharPos-strlen (IDLyypvt[-0].name)+1);
				 IDLyyval.VnodeDesc->label = IDLyypvt[-1].name;
				 IDLyyval.VnodeDesc->name = IDLyypvt[-0].name;
				 if (strlen(IDLyypvt[-1].name) > 0) /* has label */
					IDLinsert_hashtable(IDLyyval.VnodeDesc);
				} break;
case 10:
{
				 IDLReduce("IDL_label");
				 IDLyyval.name = IDLyypvt[-0].name;
				} break;
case 11:
{
				 IDLReduce("IDL_label");
				 IDLyyval.name = NewString("\0");
				} break;
case 12:
{
				 IDLReduce("IDL_attrseq");
				 appendrearSEQattrDesc(IDLyypvt[-2].VSEQattrDesc, IDLyypvt[-0].VattrDesc);
				 IDLyyval.VSEQattrDesc = IDLyypvt[-2].VSEQattrDesc;
				} break;
case 13:
{
				 IDLReduce("IDL_attrseq");
				 initializeSEQattrDesc(IDLyyval.VSEQattrDesc);
				 appendfrontSEQattrDesc(IDLyyval.VSEQattrDesc, IDLyypvt[-0].VattrDesc);
				} break;
case 14:
{
				 IDLReduce("IDL_attrseq");
				 IDLyyval.VSEQattrDesc = IDLyypvt[-2].VSEQattrDesc;
				} break;
case 15:
{
				 IDLReduce("IDL_attrseq");
				 initializeSEQattrDesc(IDLyyval.VSEQattrDesc);
				} break;
case 16:
{
				 IDLReduce("IDL_attrDesc");
				 IDLyyval.VattrDesc = NattrDesc;
 			         IDLyyval.VattrDesc->srcpos = IDLLINECHARPOS(IDLyypvt[-1].attr_name_type->linenumber,IDLyypvt[-1].attr_name_type->charpos);
				 IDLyyval.VattrDesc->name = IDLyypvt[-1].attr_name_type->name;
				 if (IDLyypvt[-0].VIDLVALUE.isname) { /* store name in a stringDesc */
				     stringDesc AstringDesc;

				     AstringDesc = NstringDesc;
				     AstringDesc->value = IDLyypvt[-0].VIDLVALUE.value.name;
				     IDLyyval.VattrDesc->value.VstringDesc = AstringDesc;
				     appendrearSEQattrDesc(IDLattrlabelrefs, IDLyyval.VattrDesc);
				   }
				 else IDLyyval.VattrDesc->value = IDLyypvt[-0].VIDLVALUE.value.value;
				} break;
case 17:
{
				 IDLReduce("IDL_attrname");
				 IDLyyval.attr_name_type = (IDLATTR_NAME *)malloc((unsigned)sizeof (IDLATTR_NAME));
				 IDLyyval.attr_name_type->name = IDLyypvt[-0].name;
				 IDLyyval.attr_name_type->linenumber = IDLlineNumber;		
				 IDLyyval.attr_name_type->charpos = IDLCharPos - strlen (IDLyypvt[-0].name) + 1;
				} break;
case 18:
{
				 IDLReduce("IDL_IDLVALUE");
				 IDLyyval.VIDLVALUE.isname = FALSE;
				 IDLyyval.VIDLVALUE.value.value.VintegerDesc = IDLyypvt[-0].intval;
				} break;
case 19:
{
				 IDLReduce("IDL_IDLVALUE");
				 IDLyyval.VIDLVALUE.isname = FALSE;
				 IDLyyval.VIDLVALUE.value.value.VrationalDesc = IDLyypvt[-0].ratval;
				} break;
case 20:
{
				 IDLReduce("IDL_IDLVALUE");
				 IDLyyval.VIDLVALUE.isname = FALSE;
				 IDLyyval.VIDLVALUE.value.value.VbooleanDesc = IDLyypvt[-0].boolval;
				} break;
case 21:
{
				 IDLReduce("IDL_IDLVALUE");
				 IDLyyval.VIDLVALUE.isname = FALSE;
				 IDLyyval.VIDLVALUE.value.value.VstringDesc = IDLyypvt[-0].strval;
				} break;
case 22:
{
				 IDLReduce("IDL_IDLVALUE");
				 IDLyyval.VIDLVALUE.isname = FALSE;
				 IDLyyval.VIDLVALUE.value.value.VsetDesc = IDLyypvt[-0].VsetDesc;
				} break;
case 23:
{
				 IDLReduce("IDL_IDLVALUE");
				 IDLyyval.VIDLVALUE.isname = FALSE;
				 IDLyyval.VIDLVALUE.value.value.VsequenceDesc = IDLyypvt[-0].VsequenceDesc;
				} break;
case 24:
{
				 IDLReduce("IDL_IDLVALUE");
				 IDLyyval.VIDLVALUE.isname = FALSE;
				 IDLyyval.VIDLVALUE.value.value.VnodeDesc = IDLyypvt[-0].VnodeDesc;
				} break;
case 25:
{ 
				 IDLReduce("IDL_IDLVALUE");
				 IDLyyval.VIDLVALUE.isname = TRUE;
				 IDLyyval.VIDLVALUE.value.name = IDLyypvt[-0].name;
				} break;
case 26:
{
				 IDLReduce("IDL_setDesc");
				 IDLyyval.VsetDesc = NsetDesc;
				 IDLyyval.VsetDesc->value = IDLyypvt[-1].VSEQIDLVALUE;
				 {SEQIDLVALUE Si;
				  IDLVALUE Ai;
				  foreachinSEQIDLVALUE(IDLyypvt[-1].VSEQIDLVALUE, Si, Ai) 
				    if (typeof(Ai)==KnodeDesc) {
				      if (Ai.VnodeDesc->name == IDLref_indicator_name) {
					IDLanIDLVALUE.VsetDesc = IDLyyval.VsetDesc;
					appendrearSEQIDLVALUE(IDLsetlabelrefs, IDLanIDLVALUE);
					break;
				      }
				    }
				 }
				} break;
case 27:
{
				 IDLReduce("IDL_seqDesc");
				 IDLyyval.VsequenceDesc = NsequenceDesc;
				 IDLyyval.VsequenceDesc->value = IDLyypvt[-1].VSEQIDLVALUE;
				 {SEQIDLVALUE Si;
				  IDLVALUE Ai;
				  foreachinSEQIDLVALUE(IDLyypvt[-1].VSEQIDLVALUE, Si, Ai) 
				    if (typeof(Ai)==KnodeDesc) {
				      if (Ai.VnodeDesc->name == IDLref_indicator_name) {
					IDLanIDLVALUE.VsequenceDesc = IDLyyval.VsequenceDesc;
					appendfrontSEQIDLVALUE(IDLseqlabelrefs, IDLanIDLVALUE);
					break;
				      }
				    }
				}
				} break;
case 28:
{
				 IDLReduce("IDL_IDLVALUEset");
				 if (IDLyypvt[-0].VIDLVALUE.isname) {
				   IDLanodeDesc = NnodeDesc;
				   IDLanodeDesc->name = IDLref_indicator_name;
				   IDLanodeDesc->label = IDLyypvt[-0].VIDLVALUE.value.name;
				   IDLanIDLVALUE.VnodeDesc = IDLanodeDesc;
				   appendrearSEQIDLVALUE(IDLyypvt[-1].VSEQIDLVALUE,IDLanIDLVALUE);
				 }
				 else appendrearSEQIDLVALUE(IDLyypvt[-1].VSEQIDLVALUE, IDLyypvt[-0].VIDLVALUE.value.value);
				 IDLyyval.VSEQIDLVALUE = IDLyypvt[-1].VSEQIDLVALUE;
				} break;
case 29:
{
				 IDLReduce("IDL_IDLVALUEset");
				 initializeSEQIDLVALUE(IDLyyval.VSEQIDLVALUE);
				} break;
case 30:
{
				 IDLReduce("IDL_IDLVALUEseq");
				 if (IDLyypvt[-0].VIDLVALUE.isname) {
				   IDLanodeDesc = NnodeDesc;
				   IDLanodeDesc->name = IDLref_indicator_name;
				   IDLanodeDesc->label = IDLyypvt[-0].VIDLVALUE.value.name;
				   IDLanIDLVALUE.VnodeDesc = IDLanodeDesc;
				   appendrearSEQIDLVALUE(IDLyypvt[-1].VSEQIDLVALUE,IDLanIDLVALUE);
				 }
                                 else appendrearSEQIDLVALUE(IDLyypvt[-1].VSEQIDLVALUE, IDLyypvt[-0].VIDLVALUE.value.value);
				 IDLyyval.VSEQIDLVALUE = IDLyypvt[-1].VSEQIDLVALUE;
				} break;
case 31:
{
				 IDLReduce("IDL_IDLVALUEseq");
				 initializeSEQIDLVALUE(IDLyyval.VSEQIDLVALUE);
				} break;
case 32:
{
				 IDLReduce("IDL_Nothing");
				} break;
	}
	goto IDLyystack;		/* reset registers in driver code */
}
# include "stdio.h"
# define IDLU(x) x
# define IDLNLSTATE IDLyyprevious=IDLYYNEWLINE
# define IDLBEGIN IDLyybgin = IDLyysvec + 1 +
# define IDLINITIAL 0
# define IDLYYLERR IDLyysvec
# define IDLYYSTATE (IDLyyestate-IDLyysvec-1)
# define IDLYYOPTIM 1
# define IDLYYLMAX BUFSIZ
# define IDLoutput(c) (void)putc(c,IDLyyout)
# define IDLunput(c) {IDLyytchar= (c);if(IDLyytchar=='\n')IDLyylineno--;*IDLyysptr++=IDLyytchar;}
# define IDLyymore() (IDLyymorfg=1)
# define IDLECHO (void)fprintf(IDLyyout, "%s",IDLyytext)
# define IDLREJECT { IDLnstr = IDLyyreject(); goto IDLyyfussy;}
int IDLyyleng; 
int IDLyymorfg;

int IDLyytchar;
FILE *IDLyyin = {stdin}, *IDLyyout = {stdout};

struct IDLyysvf { 
	struct IDLyywork *IDLyystoff;
	struct IDLyysvf *IDLyyother;
	int *IDLyystops;};
struct IDLyysvf *IDLyyestate;

#include <math.h>
#include <ctype.h>

static char *IDLString_convert();
#ifdef DEBUG
static char *IDLget_token_name();
#define IDLDreturn(tok)	{(void)(void)fprintf(stderr, "token = %s\n", IDLget_token_name(tok)); return(tok); }
#else
#define IDLDreturn(tok)	return(tok)
#endif
# define IDLYYNEWLINE 10
IDLyylex(){
int IDLnstr; 
while((IDLnstr = IDLyylook()) >= 0)
IDLyyfussy: switch(IDLnstr){
case 0:
if(IDLyywrap()) return(0); break;
case 1:
	{ IDLCharPos++; IDLDreturn (IDLLESS);}
break;
case 2:
	{ IDLCharPos++; IDLDreturn (IDLGREATER);}
break;
case 3:
	{ IDLCharPos++; IDLDreturn (IDLLBRACE);}
break;
case 4:
	{ IDLCharPos++; IDLDreturn (IDLRBRACE);}
break;
case 5:
	{ IDLCharPos++; IDLDreturn (IDLLBRACKET);}
break;
case 6:
	{ IDLCharPos++; IDLDreturn (IDLRBRACKET);}
break;
case 7:
	{ IDLCharPos++; IDLDreturn (IDLSEMICOLON);}
break;
case 8:
	{ IDLCharPos++;
		  IDLDreturn (IDLEND); 
                }
break;
case 9:
{ IDLCharPos += IDLyyleng;
                  IDLyylval.intval = NintegerDesc;
		  IDLyylval.intval->stringRep = NewString(IDLyytext);
		  IDLyylval.intval->value = atoi(IDLyytext);
		  IDLDreturn (IDLINTEGER); 
		}
break;
case 10:
{ IDLCharPos += IDLyyleng;
                  IDLyylval.ratval = NrationalDesc;
		  IDLyylval.ratval->stringRep = NewString(IDLyytext);
		  IDLyylval.ratval->value = (float) atof(IDLyytext);
		  IDLDreturn (IDLRATIONAL); 
		}
break;
case 11:
{ IDLCharPos += IDLyyleng;
		  IDLyytext[IDLyyleng-1] = '\0';	/* strip off ':'  */
		  IDLyylval.name = NewString(IDLyytext);
  		  IDLDreturn(IDLLABEL);
		}
break;
case 12:
{ IDLCharPos += IDLyyleng;
                  IDLyytext[IDLyyleng-1] = '\0';	/* strip off '^' */
		  IDLyylval.name = NewString(IDLyytext);
  		  IDLDreturn(IDLLABELREF);
		}
break;
case 13:
{IDLCharPos += IDLyyleng;
		  IDLyylval.boolval = NbooleanDesc;
		  IDLyylval.boolval->value = TRUE;
		  IDLDreturn(IDLBOOLEAN);
		}
break;
case 14:
{IDLCharPos += IDLyyleng;
		  IDLyylval.boolval = NbooleanDesc;
		  IDLyylval.boolval->value = FALSE;
		  IDLDreturn(IDLBOOLEAN);
		}
break;
case 15:
{IDLCharPos += IDLyyleng;
		  IDLyylval.name = NewString(IDLyytext);
		  IDLDreturn(IDLNAME);
		}
break;
case 16:
{
		/* was \"([^"~]*(\"\")*(~[~{@-_])*)*\"/[^"]	*/
                  IDLCharPos += IDLyyleng;
		  IDLyylval.strval = NstringDesc;
		  IDLyylval.strval->value = 
			NewString(IDLString_convert(IDLyytext, IDLyyleng));
		  IDLDreturn (IDLSTRING); 
		}
break;
case 17:
{ /* comment or if on first line - name of structure */
		 int i,j;
		 if (IDLlineNumber == 1 && IDLCharPos == 0)
		    {
			for (i=12;IDLyytext[i] && isspace(IDLyytext[i]);i++)
				;
			for (j=0;IDLyytext[i] && IDLyytext[i] != '\n';j++,i++)
			   IDLStructureName[j] = IDLyytext[i];
			IDLStructureName[j] = '\0';
		    }
                 IDLlineNumber++; 
		 IDLCharPos = 0;
		}
break;
case 18:
	{ /* comment */
                 IDLlineNumber++; 
		 IDLCharPos = 0;
		}
break;
case 19:
{ IDLCharPos += IDLyyleng; /* white space */ ; }
break;
case 20:
	{ IDLlineNumber++ /* more white space */; IDLCharPos = 0;}
break;
case 21:
	{ IDLCharPos += IDLyyleng; (void)(void)fprintf(stderr, "Unknown token:  '%s'\n", IDLyytext); }
break;
case -1:
break;
default:
(void)fprintf(IDLyyout,"bad switch IDLyylook %d",IDLnstr);
} return(0); }
/* end of IDLyylex */

static char * IDLString_convert(st,len)
char *st;
int  len;
{
    char *result;
    char *save;
    int  i;

    result = (char *)GetHeap(len+1);
    save = result;
    st++;
    for(i=1;i<len-1;i++)
    {
	if(*st == '~')
	{
	    st++;
	    i++;
	    if(*st >= '@' && *st <= '_')
	    {
		*result = *st - '@';
		result++;
	    }
	    else if(*st == '~')
		 {
		     *result = '~';
		     result++;
		 }
		 else if(*st == '{')
		      {
			  *result = '\177';	/* DEL  */
			  result++;
		      }
	}
	else if(*st == '"')
	     {
		 st++;
		 i++;
		 *result = '"';
		 result++;
	     }
	     else { *result = *st; result++; }
    st++;
    }
	*result = '\0';
	result = save;
	return(result);
}
static char *IDLget_token_name(tok)
int tok;
{
	static char buf[50];
	switch (tok) {
		case IDLLPAREN:	return("IDLLPAREN");
		case IDLRPAREN:	return("IDLRPAREN");
		case IDLLBRACKET:	return("IDLLBRACKET");
		case IDLRBRACKET:	return("IDLRBRACKET");
		case IDLLBRACE:	return("IDLLBRACE");
		case IDLRBRACE:	return("IDLRBRACE");
		case IDLLESS:	return("IDLLESS");
		case IDLGREATER:	return("IDLGREATER");
		case IDLSEMICOLON:	return("IDLSEMICOLON");
		case IDLEND:	return("IDLEND");
		case IDLSTRING:	return("IDLSTRING");
		case IDLRATIONAL:	return("IDLRATIONAL");
		case IDLINTEGER:	return("IDLINTEGER");
		case IDLBOOLEAN:	return("IDLBOOLEAN");
		case IDLNAME:	return("IDLNAME");
		case IDLLABELREF:	return("IDLLABELREF");
		case IDLLABEL:	return("IDLLABEL");
		default:	(void)(void)sprintf(buf, "<%d>", tok);
				return(buf);
	}
}

IDLyywrap() 
{ 
    return(1);
}
int IDLyyvstop[] = {
0,

19,
0,

19,
0,

21,
0,

19,
21,
0,

20,
0,

21,
0,

8,
21,
0,

21,
0,

21,
0,

9,
21,
0,

7,
21,
0,

1,
21,
0,

2,
21,
0,

15,
21,
0,

15,
21,
0,

15,
21,
0,

5,
21,
0,

6,
21,
0,

3,
21,
0,

4,
21,
0,

19,
0,

16,
0,

9,
0,

15,
0,

11,
0,

12,
0,

15,
0,

15,
0,

10,
0,

10,
0,

10,
0,

15,
0,

15,
0,

18,
0,

10,
0,

15,
0,

13,
15,
0,

10,
0,

10,
0,

10,
0,

14,
15,
0,

10,
0,

10,
0,

10,
0,

10,
0,

17,
18,
0,
0};
# define IDLYYTYPE char
struct IDLyywork { IDLYYTYPE verify, advance; } IDLyycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
0,0,	0,0,	4,21,	0,0,	
0,0,	4,21,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,4,	1,3,	1,6,	
1,7,	4,21,	23,22,	10,27,	
26,36,	0,0,	0,0,	0,0,	
1,8,	0,0,	1,9,	9,26,	
37,47,	1,10,	10,28,	10,29,	
0,0,	2,6,	2,7,	0,0,	
0,0,	0,0,	0,0,	37,48,	
1,11,	1,12,	41,29,	1,13,	
2,9,	38,29,	1,14,	1,14,	
15,34,	0,0,	1,14,	1,15,	
1,14,	10,30,	0,0,	0,0,	
0,0,	1,14,	2,11,	2,12,	
0,0,	2,13,	0,0,	1,14,	
1,14,	1,16,	1,14,	38,49,	
0,0,	0,0,	57,47,	16,35,	
1,17,	25,27,	1,18,	73,68,	
1,3,	0,0,	1,14,	0,0,	
15,34,	0,0,	1,14,	1,15,	
25,28,	25,29,	34,42,	35,43,	
42,53,	43,54,	2,17,	59,29,	
2,18,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	8,25,	
8,25,	8,25,	8,25,	16,35,	
1,19,	61,70,	1,20,	25,30,	
28,38,	28,38,	28,38,	28,38,	
28,38,	28,38,	28,38,	28,38,	
28,38,	28,38,	34,42,	35,43,	
42,53,	43,54,	2,19,	46,55,	
2,20,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,22,	6,22,	6,23,	53,64,	
55,65,	47,29,	65,71,	67,29,	
68,72,	71,76,	76,79,	6,22,	
79,80,	80,81,	81,82,	0,0,	
6,22,	29,39,	29,39,	29,39,	
29,39,	29,39,	29,39,	29,39,	
29,39,	29,39,	29,39,	47,56,	
0,0,	60,68,	39,50,	0,0,	
0,0,	6,22,	6,22,	53,64,	
0,0,	6,22,	6,22,	6,22,	
60,69,	39,51,	0,0,	0,0,	
6,22,	0,0,	0,0,	0,0,	
0,0,	0,0,	6,22,	6,22,	
6,22,	6,22,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	6,22,	
39,52,	6,22,	0,0,	0,0,	
0,0,	6,22,	6,22,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,32,	0,0,	0,0,	
0,0,	0,0,	6,24,	6,0,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	0,0,	0,0,	
0,0,	14,33,	14,31,	0,0,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	14,31,	14,31,	
14,31,	14,31,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	22,0,	22,0,	22,0,	
22,0,	0,0,	0,0,	22,23,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	24,0,	
24,0,	24,0,	24,0,	0,0,	
0,0,	24,0,	27,37,	27,37,	
27,37,	27,37,	27,37,	27,37,	
27,37,	27,37,	27,37,	27,37,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	27,37,	
27,37,	27,37,	27,37,	27,37,	
27,37,	30,40,	0,0,	30,40,	
0,0,	0,0,	30,41,	30,41,	
30,41,	30,41,	30,41,	30,41,	
30,41,	30,41,	30,41,	30,41,	
36,44,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
36,44,	36,45,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	22,24,	
22,0,	40,41,	40,41,	40,41,	
40,41,	40,41,	40,41,	40,41,	
40,41,	40,41,	40,41,	36,44,	
36,44,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	36,44,	0,0,	
0,0,	0,0,	0,0,	36,44,	
44,44,	0,0,	0,0,	0,0,	
0,0,	24,22,	24,0,	0,0,	
44,44,	44,45,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
36,44,	36,44,	0,0,	0,0,	
36,44,	36,44,	36,44,	0,0,	
0,0,	0,0,	0,0,	36,44,	
0,0,	0,0,	0,0,	44,44,	
44,44,	36,44,	36,44,	36,44,	
36,44,	0,0,	0,0,	0,0,	
0,0,	0,0,	44,44,	0,0,	
0,0,	0,0,	36,44,	44,44,	
36,44,	49,58,	0,0,	49,58,	
36,44,	36,44,	49,59,	49,59,	
49,59,	49,59,	49,59,	49,59,	
49,59,	49,59,	49,59,	49,59,	
44,44,	44,44,	36,46,	0,0,	
44,44,	44,44,	44,44,	0,0,	
0,0,	0,0,	0,0,	44,44,	
0,0,	0,0,	0,0,	0,0,	
0,0,	44,44,	44,44,	44,44,	
44,44,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	44,44,	0,0,	
44,44,	0,0,	0,0,	0,0,	
44,44,	44,44,	48,57,	48,57,	
48,57,	48,57,	48,57,	48,57,	
48,57,	48,57,	48,57,	48,57,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	48,57,	
48,57,	48,57,	48,57,	48,57,	
48,57,	50,60,	50,60,	50,60,	
50,60,	50,60,	50,60,	50,60,	
50,60,	50,60,	50,60,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	50,60,	50,60,	
50,60,	50,60,	50,60,	50,60,	
51,61,	51,61,	51,61,	51,61,	
51,61,	51,61,	51,61,	51,61,	
51,61,	51,61,	52,62,	0,0,	
52,62,	0,0,	0,0,	52,63,	
52,63,	52,63,	52,63,	52,63,	
52,63,	52,63,	52,63,	52,63,	
52,63,	56,66,	0,0,	56,66,	
0,0,	0,0,	56,67,	56,67,	
56,67,	56,67,	56,67,	56,67,	
56,67,	56,67,	56,67,	56,67,	
58,59,	58,59,	58,59,	58,59,	
58,59,	58,59,	58,59,	58,59,	
58,59,	58,59,	62,63,	62,63,	
62,63,	62,63,	62,63,	62,63,	
62,63,	62,63,	62,63,	62,63,	
66,67,	66,67,	66,67,	66,67,	
66,67,	66,67,	66,67,	66,67,	
66,67,	66,67,	69,73,	69,73,	
69,73,	69,73,	69,73,	69,73,	
69,73,	69,73,	69,73,	69,73,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	69,73,	
69,73,	69,73,	69,73,	69,73,	
69,73,	70,74,	0,0,	70,74,	
0,0,	0,0,	70,75,	70,75,	
70,75,	70,75,	70,75,	70,75,	
70,75,	70,75,	70,75,	70,75,	
72,77,	0,0,	72,77,	0,0,	
0,0,	72,78,	72,78,	72,78,	
72,78,	72,78,	72,78,	72,78,	
72,78,	72,78,	72,78,	74,75,	
74,75,	74,75,	74,75,	74,75,	
74,75,	74,75,	74,75,	74,75,	
74,75,	77,78,	77,78,	77,78,	
77,78,	77,78,	77,78,	77,78,	
77,78,	77,78,	77,78,	82,82,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	82,82,	
82,83,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	82,82,	82,82,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	82,82,	0,0,	0,0,	
0,0,	0,0,	82,82,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	82,82,	
82,82,	0,0,	0,0,	82,82,	
82,82,	82,82,	0,0,	0,0,	
0,0,	0,0,	82,82,	0,0,	
0,0,	0,0,	0,0,	0,0,	
82,82,	82,82,	82,82,	82,82,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	82,82,	0,0,	82,82,	
0,0,	0,0,	0,0,	82,82,	
82,82,	0,0,	0,0,	0,0,	
0,0};
struct IDLyysvf IDLyysvec[] = {
0,	0,	0,
IDLyycrank+-1,	0,		IDLyyvstop+1,
IDLyycrank+-19,	IDLyysvec+1,	IDLyyvstop+3,
IDLyycrank+0,	0,		IDLyyvstop+5,
IDLyycrank+5,	0,		IDLyyvstop+7,
IDLyycrank+0,	0,		IDLyyvstop+10,
IDLyycrank+-144,	0,		IDLyyvstop+12,
IDLyycrank+0,	0,		IDLyyvstop+14,
IDLyycrank+65,	0,		IDLyyvstop+17,
IDLyycrank+2,	IDLyysvec+8,	IDLyyvstop+19,
IDLyycrank+4,	IDLyysvec+8,	IDLyyvstop+21,
IDLyycrank+0,	0,		IDLyyvstop+24,
IDLyycrank+0,	0,		IDLyyvstop+27,
IDLyycrank+0,	0,		IDLyyvstop+30,
IDLyycrank+207,	0,		IDLyyvstop+33,
IDLyycrank+3,	IDLyysvec+14,	IDLyyvstop+36,
IDLyycrank+9,	IDLyysvec+14,	IDLyyvstop+39,
IDLyycrank+0,	0,		IDLyyvstop+42,
IDLyycrank+0,	0,		IDLyyvstop+45,
IDLyycrank+0,	0,		IDLyyvstop+48,
IDLyycrank+0,	0,		IDLyyvstop+51,
IDLyycrank+0,	IDLyysvec+4,	IDLyyvstop+54,
IDLyycrank+-329,	IDLyysvec+6,	0,	
IDLyycrank+4,	0,		IDLyyvstop+56,
IDLyycrank+-363,	IDLyysvec+6,	0,	
IDLyycrank+58,	IDLyysvec+8,	IDLyyvstop+58,
IDLyycrank+8,	0,		0,	
IDLyycrank+350,	0,		0,	
IDLyycrank+80,	0,		0,	
IDLyycrank+145,	0,		0,	
IDLyycrank+378,	0,		0,	
IDLyycrank+0,	IDLyysvec+14,	IDLyyvstop+60,
IDLyycrank+0,	0,		IDLyyvstop+62,
IDLyycrank+0,	0,		IDLyyvstop+64,
IDLyycrank+30,	IDLyysvec+14,	IDLyyvstop+66,
IDLyycrank+22,	IDLyysvec+14,	IDLyyvstop+68,
IDLyycrank+-435,	0,		0,	
IDLyycrank+13,	IDLyysvec+27,	0,	
IDLyycrank+18,	IDLyysvec+28,	IDLyyvstop+70,
IDLyycrank+171,	IDLyysvec+29,	IDLyyvstop+72,
IDLyycrank+409,	0,		0,	
IDLyycrank+15,	IDLyysvec+40,	IDLyyvstop+74,
IDLyycrank+25,	IDLyysvec+14,	IDLyyvstop+76,
IDLyycrank+40,	IDLyysvec+14,	IDLyyvstop+78,
IDLyycrank+-483,	0,		0,	
IDLyycrank+0,	0,		IDLyyvstop+80,
IDLyycrank+-27,	IDLyysvec+44,	0,	
IDLyycrank+134,	0,		IDLyyvstop+82,
IDLyycrank+538,	0,		0,	
IDLyycrank+490,	0,		0,	
IDLyycrank+561,	0,		0,	
IDLyycrank+584,	0,		0,	
IDLyycrank+599,	0,		0,	
IDLyycrank+110,	IDLyysvec+14,	IDLyyvstop+84,
IDLyycrank+0,	IDLyysvec+14,	IDLyyvstop+86,
IDLyycrank+-66,	IDLyysvec+44,	0,	
IDLyycrank+614,	0,		0,	
IDLyycrank+55,	IDLyysvec+48,	0,	
IDLyycrank+624,	0,		0,	
IDLyycrank+64,	IDLyysvec+58,	IDLyyvstop+89,
IDLyycrank+170,	IDLyysvec+50,	0,	
IDLyycrank+56,	IDLyysvec+51,	IDLyyvstop+91,
IDLyycrank+634,	0,		0,	
IDLyycrank+0,	IDLyysvec+62,	IDLyyvstop+93,
IDLyycrank+0,	IDLyysvec+14,	IDLyyvstop+95,
IDLyycrank+-65,	IDLyysvec+44,	0,	
IDLyycrank+644,	0,		0,	
IDLyycrank+136,	IDLyysvec+66,	IDLyyvstop+98,
IDLyycrank+115,	0,		IDLyyvstop+100,
IDLyycrank+654,	0,		0,	
IDLyycrank+682,	0,		0,	
IDLyycrank+-86,	IDLyysvec+44,	0,	
IDLyycrank+697,	0,		0,	
IDLyycrank+60,	IDLyysvec+69,	0,	
IDLyycrank+707,	0,		0,	
IDLyycrank+0,	IDLyysvec+74,	IDLyyvstop+102,
IDLyycrank+-70,	IDLyysvec+44,	0,	
IDLyycrank+717,	0,		0,	
IDLyycrank+0,	IDLyysvec+77,	IDLyyvstop+104,
IDLyycrank+-71,	IDLyysvec+44,	0,	
IDLyycrank+-75,	IDLyysvec+44,	0,	
IDLyycrank+-89,	IDLyysvec+44,	0,	
IDLyycrank+-774,	0,		0,	
IDLyycrank+0,	0,		IDLyyvstop+106,
0,	0,	0};
struct IDLyywork *IDLyytop = IDLyycrank+876;
struct IDLyysvf *IDLyybgin = IDLyysvec+1;
char IDLyymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,011 ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
040 ,'!' ,01  ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'+' ,'!' ,'+' ,'!' ,'!' ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'A' ,'B' ,'B' ,'B' ,'E' ,'F' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'L' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'R' ,'S' ,'T' ,'U' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'!' ,'!' ,'!' ,'!' ,'_' ,
'!' ,'a' ,'G' ,'G' ,'G' ,'e' ,'f' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'L' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'R' ,'S' ,'T' ,'U' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'!' ,'!' ,'!' ,01  ,01  ,
0};
char IDLyyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char IDLncform_sccsid[] = "@(#)IDLncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int IDLyylineno =1;
# define IDLYYU(x) x
# define IDLNLSTATE IDLyyprevious=IDLYYNEWLINE
char IDLyytext[IDLYYLMAX];
struct IDLyysvf *IDLyylstate [IDLYYLMAX], **IDLyylsp, **IDLyyolsp;
char IDLyysbuf[IDLYYLMAX];
char *IDLyysptr = IDLyysbuf;
int *IDLyyfnd;

int IDLyyprevious = IDLYYNEWLINE;
IDLyylook(){
	register struct IDLyysvf *IDLyystate, **lsp;
	register struct IDLyywork *IDLyyt;
	struct IDLyysvf *IDLyyz;
	int IDLyych, IDLyyfirst;
	struct IDLyywork *IDLyyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *IDLyylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	IDLyyfirst=1;
	if (!IDLyymorfg)
		IDLyylastch = IDLyytext;
	else {
		IDLyymorfg=0;
		IDLyylastch = IDLyytext+IDLyyleng;
		}
	for(;;){
		lsp = IDLyylstate;
		IDLyyestate = IDLyystate = IDLyybgin;
		if (IDLyyprevious==IDLYYNEWLINE) IDLyystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)(void)fprintf(IDLyyout,"state %d\n",IDLyystate-IDLyysvec-1);
# endif
			IDLyyt = IDLyystate->IDLyystoff;
			if(IDLyyt == IDLyycrank && !IDLyyfirst){  /* may not be any transitions */
				IDLyyz = IDLyystate->IDLyyother;
				if(IDLyyz == 0)break;
				if(IDLyyz->IDLyystoff == IDLyycrank)break;
				}
			*IDLyylastch++ = IDLyych = IDLyyinput();
			IDLyyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				(void)fprintf(IDLyyout,"char ");
				allprint(IDLyych);
				(void)putchar('\n');
				}
# endif
			IDLyyr = IDLyyt;
			if ( (int)IDLyyt > (int)IDLyycrank){
				IDLyyt = IDLyyr + IDLyych;
				if (IDLyyt <= IDLyytop && IDLyyt->verify+IDLyysvec == IDLyystate){
					if(IDLyyt->advance+IDLyysvec == IDLYYLERR)	/* error transitions */
						{IDLunput(*--IDLyylastch);break;}
					*lsp++ = IDLyystate = IDLyyt->advance+IDLyysvec;
					goto contin;
					}
				}
# ifdef IDLYYOPTIM
			else if((int)IDLyyt < (int)IDLyycrank) {		/* r < IDLyycrank */
				IDLyyt = IDLyyr = IDLyycrank+(IDLyycrank-IDLyyt);
# ifdef LEXDEBUG
				if(debug)(void)fprintf(IDLyyout,"compressed state\n");
# endif
				IDLyyt = IDLyyt + IDLyych;
				if(IDLyyt <= IDLyytop && IDLyyt->verify+IDLyysvec == IDLyystate){
					if(IDLyyt->advance+IDLyysvec == IDLYYLERR)	/* error transitions */
						{IDLunput(*--IDLyylastch);break;}
					*lsp++ = IDLyystate = IDLyyt->advance+IDLyysvec;
					goto contin;
					}
				IDLyyt = IDLyyr + IDLYYU(IDLyymatch[IDLyych]);
# ifdef LEXDEBUG
				if(debug){
					(void)fprintf(IDLyyout,"try fall back character ");
					allprint(IDLYYU(IDLyymatch[IDLyych]));
					(void)putchar('\n');
					}
# endif
				if(IDLyyt <= IDLyytop && IDLyyt->verify+IDLyysvec == IDLyystate){
					if(IDLyyt->advance+IDLyysvec == IDLYYLERR)	/* error transition */
						{IDLunput(*--IDLyylastch);break;}
					*lsp++ = IDLyystate = IDLyyt->advance+IDLyysvec;
					goto contin;
					}
				}
			if ((IDLyystate = IDLyystate->IDLyyother) && (IDLyyt= IDLyystate->IDLyystoff) != IDLyycrank){
# ifdef LEXDEBUG
				if(debug)(void)fprintf(IDLyyout,"fall back to state %d\n",IDLyystate-IDLyysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{IDLunput(*--IDLyylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				(void)fprintf(IDLyyout,"state %d char ",IDLyystate-IDLyysvec-1);
				allprint(IDLyych);
				(void)putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			(void)fprintf(IDLyyout,"stopped at %d with ",*(lsp-1)-IDLyysvec-1);
			allprint(IDLyych);
			(void)putchar('\n');
			}
# endif
		while (lsp-- > IDLyylstate){
			*IDLyylastch-- = 0;
			if (*lsp != 0 && (IDLyyfnd= (*lsp)->IDLyystops) && *IDLyyfnd > 0){
				IDLyyolsp = lsp;
				if(IDLyyextra[*IDLyyfnd]){		/* must backup */
					while(IDLyyback((*lsp)->IDLyystops,-*IDLyyfnd) != 1 && lsp > IDLyylstate){
						lsp--;
						IDLunput(*IDLyylastch--);
						}
					}
				IDLyyprevious = IDLYYU(*IDLyylastch);
				IDLyylsp = lsp;
				IDLyyleng = IDLyylastch-IDLyytext+1;
				IDLyytext[IDLyyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					(void)fprintf(IDLyyout,"\nmatch ");
					sprint(IDLyytext);
					(void)fprintf(IDLyyout," action %d\n",*IDLyyfnd);
					}
# endif
				return(*IDLyyfnd++);
				}
			IDLunput(*IDLyylastch);
			}
		if (IDLyytext[0] == 0  /* && feof(IDLyyin) */)
			{
			IDLyysptr=IDLyysbuf;
			return(0);
			}
		IDLyyprevious = IDLyytext[0] = IDLyyinput();
		if (IDLyyprevious>0)
			IDLoutput(IDLyyprevious);
		IDLyylastch=IDLyytext;
# ifdef LEXDEBUG
		if(debug)(void)putchar('\n');
# endif
		}
	}
IDLyyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
IDLyyIDLyyinput(){
	return(IDLyyinput());
	}
IDLyyIDLoutput(c)
  int c; {
	IDLoutput(c);
	}
IDLyyIDLunput(c)
   int c; {
	IDLunput(c);
	}
IDLyyinput(){ 
char c;
int err;
c = (((c=IDLyysptr>IDLyysbuf?IDLU(*--IDLyysptr):((err=read(IDLinputfiledesc,(char *) &c,1))!=1?EOF:c))==10?(IDLyylineno++,c):c)==EOF?0:c);
IDLyytchar = c;
return(c);
}
#endif
