#include <stdio.h>
#include <rpc/rpc.h>
#include "foo.h"

bool_t xdr_A();

main()
{
  XDR xdrs;
  struct hA *gp;
  gp = (struct hA *) malloc(sizeof(struct hA));
  xdrstdio_create(&xdrs,stdin,XDR_DECODE);
  if (!xdr_A(&xdrs,gp))
    { fprintf(stderr,"Error: XDR failed\n"); exit(99);}
  output_ascii(gp);
}

output_ascii(gp)
     struct hA *gp;
{ printf("-- structure Aval\n");
  printf("Aval [ \nfirst \n");
  output_C(&(gp->first));
  printf("; second \n");
  output_D(&(gp->second));
  printf("; third <\n");
  output_intseq(&(gp->third));
  printf("]\n#\n");
}

output_intseq(gp)
     struct intseq *gp;
{ struct intseq *currnode;
  currnode=gp;
  while (currnode->nodetype!=NULLELEM) {
    printf(" %d ",currnode->val);
    currnode=currnode->next;
  }
  printf(" >\n");
}
output_C(gp)
     struct hC *gp;
{
  printf("Cval [ name \n");
  printf("\"%s\" ; \nEnode ",gp->name);
  output_E(&(gp->Enode)); printf("] \n");
}

output_D(gp)
     struct hD *gp;
{
  printf("Dval [ value \n");
  printf("\"%s\" ; \nEnode ",gp->value);
  output_E(&(gp->Enode)); printf("] \n");
}

output_E(gp)
     struct hE *gp;
{
  if (gp->Etype==ISLABEL) printf(" L%d^ \n",gp->value.label_no);
  else
    { if (gp->value.value.Etype==LABELDEF)
	printf("L%d: \n",gp->value.value.label_no);
      printf("Eval [ number %d ; \n",gp->value.value.value.number);
      printf("name \"%s\" ; \nvalue %f ; \nflag %d ] \n",
	     gp->value.value.value.name, gp->value.value.value.value,
	     gp->value.value.value.flag);
    }
}
