#include <stdio.h>
#include <rpc/rpc.h>
#include "foo.h"
#include "writer.h"
int global_label=1;

buildA(idlnode,Cnode)
     Aval idlnode;
     struct hA *Cnode;
{
  buildC(idlnode->first,&(Cnode->first));
  buildD(idlnode->second,&(Cnode->second));
  buildintseq(idlnode->third,&(Cnode->third));
}

buildintseq(idlnode,Cnode)
SEQint idlnode;
struct intseq *Cnode;
{ SEQint tempseq;
  int aval;
  struct intseq *currnode;
  currnode=Cnode;
  foreachinSEQint(idlnode,tempseq,aval)
    { currnode->val=aval;
      currnode->nodetype=VALELEM;
      currnode->next = (struct intseq *) malloc(sizeof(struct intseq));
      currnode=currnode->next;
    }
  currnode->nodetype=NULLELEM;
}

buildC(idlnode,Cnode)
     Cval idlnode;
     struct hC *Cnode;
{ 
  Cnode->name=StringToChar(idlnode->name);
  buildE(idlnode->Enode,&(Cnode->Enode));
}

buildD(idlnode,Cnode)
     Dval idlnode;
     struct hD *Cnode;
{
  Cnode->value=StringToChar(idlnode->value);
  buildE(idlnode->Enode,&(Cnode->Enode));
}

buildE(idlnode,Cnode)
     Eval idlnode;
     struct hE *Cnode;
{
  if (idlnode->touched==0)
    { Cnode->Etype=ISLABEL;
      Cnode->value.label_no=idlnode->label_no;
    }
  else {
    Cnode->Etype=ISNODE;
    if (idlnode->shared)
      { Cnode->value.value.Etype=LABELDEF;
	Cnode->value.value.label_no=global_label;
	idlnode->label_no=global_label++;
      }
    else Cnode->value.value.Etype=NOLABEL;
    idlnode->touched=0;
    idlnode->shared=0;
    Cnode->value.value.value.number=idlnode->number;
    Cnode->value.value.value.name=StringToChar(idlnode->name);
    Cnode->value.value.value.value=idlnode->value;
    Cnode->value.value.value.flag=((idlnode->flag)?1:0);
  }
}

markA(node)
     Aval node;
{ 
  markC(node->first);
  markD(node->second);
}

markC(node)
     Cval node;
{
  markE(node->Enode);
}

markD(node)
     Dval node;
{
  markE(node->Enode);
}

markE(node)
     Eval node;
{
  if (node->touched) node->shared=1;
  node->touched=1;
}

main(argc,argv)
     int argc;
     char *argv[];
{ XDR xdrs;
  FILE *fp, *fopen();
  struct hA *cstructure;
  Aval idl_struct;
  if (argc!=2) { fprintf(stderr,"Usage:%s <file>\n",argv[0]);exit(99);}
  if ((fp=fopen(argv[1],"r"))==NULL)
    { fprintf(stderr, "Can't open file %s\n", argv[1]);exit(99);}
  xdrstdio_create(&xdrs,stdout,XDR_ENCODE);
  idl_struct=input(fp);
  markA(idl_struct);
  cstructure= (struct hA *) malloc(sizeof(struct hA));
  buildA(idl_struct,cstructure);
  if (!xdr_A(&xdrs,cstructure))
    fprintf(stderr,"XDR failed\n");
}
