(* file: functionlang/specs/posPconverts.p *)
(* contains the conversion routines for the private type *)
(* source_position, which has two representations: pos and integer. *)

(* source_position is encoded as an integer (32 bit signed) *)
(* as follows *)
(* 15 bits for character offset in source file *)
(* 9 bits for the character offset from the beginning of the line *)
(* 7 bits for line number in the source file *)

#include 'sourceposition.i'
procedure integerTopos(* IDLfrom: integer; var IDLto: pos*);
begin
	IDLto := Npos;
	IDLto^.charoffset := (IDLfrom div 65536) mod 32768;
	IDLto^.lineoffset := (IDLfrom div 128) mod 512;
	IDLto^.linenumber := (IDLfrom ) mod 128;
end;

procedure posTointeger(* IDLfrom: pos; var IDLto: integer *);
begin
	IDLto := ((IDLfrom^.charoffset mod 32768) * 65536) +
			((IDLfrom^.lineoffset mod 512) * 128) +
			 (IDLfrom^.linenumber mod 128);
end;

