(* file: functionlang/semantic/Pascal/typing.p *)

#include "semantic.h"
#include "sem2.h"
#include "semantic.i"

(* the procedure for expression typing *)
procedure expressiontype(*var theexp: expression*);
var	leftexp: expression;  (* for de-referencing left exp of binary op *)
	rightexp: expression; (* for de-referencing right exp of binary op *)
	argexp: expression;   (* for de-referencing argument of unary op *)
	lefttype: types;
	righttype: types;
	argtype: types;
	resulttype: types;
	tempint: int;
	tempTreal: Treal;
begin
	case theexp^.Eexpression of
	Kexpressionconstant: case theexp^.Vconstant^.Econstant of
		Kconstantintegerconstant: begin
			tempint := Nint;
			theexp^.semexptype:= tempint^.Ptypes;
			end;
		Kconstantrealconstant: begin
			tempTreal := NTreal;
			theexp^.semexptype:= tempTreal^.Ptypes;
			end;
		end;

	KexpressionformalparameterRef:
		theexp^.semexptype:=
			theexp^.VformalparameterRef^.sementity^.synparamtype;
		
	Kexpressionoperation: case theexp^.Voperation^.Eoperation of
		Koperationbinaryoperation: begin
			leftexp := theexp^.Voperation^.Vbinaryoperation^.synleft;
			rightexp := theexp^.Voperation^.Vbinaryoperation^.synright;
			expressiontype(leftexp);
			expressiontype(rightexp);
			lefttype:= leftexp^.semexptype;
			righttype:= rightexp^.semexptype;
			case theexp^.Voperation^.Vbinaryoperation^.synop
                                ^.Ebinaryoperator of
			Kbinaryoperatorplus: if (lefttype^.Etypes <> Ktypesint)
					or (righttype^.Etypes <> Ktypesint)
				then begin
					tempTreal := NTreal;
					resulttype:= tempTreal^.Ptypes;
					end
				else begin
					tempint := Nint;
					resulttype:= tempint^.Ptypes;
					end;
			Kbinaryoperatorminus: if (lefttype^.Etypes <> Ktypesint)
					or (righttype^.Etypes <> Ktypesint)
				then begin
					tempTreal := NTreal;
					resulttype:= tempTreal^.Ptypes;
					end
				else begin
					tempint := Nint;
					resulttype:= tempint^.Ptypes;
					end;
			Kbinaryoperatortimes: if (lefttype^.Etypes <> Ktypesint)
					or (righttype^.Etypes <> Ktypesint)
				then begin
					tempTreal := NTreal;
					resulttype:= tempTreal^.Ptypes;
					end
				else begin
					tempint := Nint;
					resulttype:= tempint^.Ptypes;
					end;
			Kbinaryoperatordivide: begin
				tempTreal := NTreal;
				resulttype:= tempTreal^.Ptypes;
				end;
			end;
			theexp^.semexptype:= resulttype;
			end;
		Koperationunaryoperation: begin
			argexp := theexp^.Voperation^.Vunaryoperation^.synargument;
			expressiontype(argexp);
			argtype:= argexp^.semexptype;
			if argtype^.Etypes <> Ktypesint
			then begin
				tempTreal := NTreal;
				resulttype:= tempTreal^.Ptypes;
				end
			else begin
				tempint := Nint;
				resulttype:= tempint^.Ptypes;
				end;
			theexp^.semexptype:= resulttype;
			end;
		end;
	end
end;


